/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.Spinner;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.TextWatcherAdapter;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.textfield.EndIconDelegate;
import com.google.android.material.textfield.TextInputLayout;

class DropdownMenuEndIconDelegate
extends EndIconDelegate {
    private static final int ANIMATION_FADE_IN_DURATION = 67;
    private static final int ANIMATION_FADE_OUT_DURATION = 50;
    private static final boolean IS_LOLLIPOP;
    private final TextInputLayout.AccessibilityDelegate accessibilityDelegate;
    private AccessibilityManager accessibilityManager;
    private final TextInputLayout.OnEditTextAttachedListener dropdownMenuOnEditTextAttachedListener;
    private long dropdownPopupActivatedAt;
    private boolean dropdownPopupDirty = false;
    private final TextInputLayout.OnEndIconChangedListener endIconChangedListener;
    private final TextWatcher exposedDropdownEndIconTextWatcher = new TextWatcherAdapter(){

        @Override
        public void afterTextChanged(Editable editable) {
            editable = DropdownMenuEndIconDelegate.castAutoCompleteTextViewOrThrow(DropdownMenuEndIconDelegate.this.textInputLayout.getEditText());
            if (DropdownMenuEndIconDelegate.this.accessibilityManager.isTouchExplorationEnabled() && DropdownMenuEndIconDelegate.isEditable((EditText)editable) && !DropdownMenuEndIconDelegate.this.endIconView.hasFocus()) {
                editable.dismissDropDown();
            }
            editable.post(new Runnable((AutoCompleteTextView)editable){
                final /* synthetic */ AutoCompleteTextView val$editText;
                {
                    this.val$editText = autoCompleteTextView;
                }

                @Override
                public void run() {
                    boolean bl = this.val$editText.isPopupShowing();
                    DropdownMenuEndIconDelegate.this.setEndIconChecked(bl);
                    DropdownMenuEndIconDelegate.access$402(DropdownMenuEndIconDelegate.this, bl);
                }
            });
        }
    };
    private ValueAnimator fadeInAnim;
    private ValueAnimator fadeOutAnim;
    private StateListDrawable filledPopupBackground;
    private boolean isEndIconChecked = false;
    private final View.OnFocusChangeListener onFocusChangeListener = new View.OnFocusChangeListener(){

        public void onFocusChange(View view, boolean bl) {
            DropdownMenuEndIconDelegate.this.textInputLayout.setEndIconActivated(bl);
            if (!bl) {
                DropdownMenuEndIconDelegate.this.setEndIconChecked(false);
                DropdownMenuEndIconDelegate.access$402(DropdownMenuEndIconDelegate.this, false);
            }
        }
    };
    private MaterialShapeDrawable outlinedPopupBackground;

    static {
        boolean bl = Build.VERSION.SDK_INT >= 21;
        IS_LOLLIPOP = bl;
    }

    DropdownMenuEndIconDelegate(TextInputLayout textInputLayout, int n) {
        super(textInputLayout, n);
        this.accessibilityDelegate = new TextInputLayout.AccessibilityDelegate(this.textInputLayout){

            @Override
            public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                if (!DropdownMenuEndIconDelegate.isEditable(DropdownMenuEndIconDelegate.this.textInputLayout.getEditText())) {
                    accessibilityNodeInfoCompat.setClassName((CharSequence)Spinner.class.getName());
                }
                if (accessibilityNodeInfoCompat.isShowingHintText()) {
                    accessibilityNodeInfoCompat.setHintText(null);
                }
            }

            public void onPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
                super.onPopulateAccessibilityEvent(view, accessibilityEvent);
                view = DropdownMenuEndIconDelegate.castAutoCompleteTextViewOrThrow(DropdownMenuEndIconDelegate.this.textInputLayout.getEditText());
                if (accessibilityEvent.getEventType() == 1 && DropdownMenuEndIconDelegate.this.accessibilityManager.isTouchExplorationEnabled() && !DropdownMenuEndIconDelegate.isEditable(DropdownMenuEndIconDelegate.this.textInputLayout.getEditText())) {
                    DropdownMenuEndIconDelegate.this.showHideDropdown((AutoCompleteTextView)view);
                }
            }
        };
        this.dropdownMenuOnEditTextAttachedListener = new TextInputLayout.OnEditTextAttachedListener(){

            @Override
            public void onEditTextAttached(TextInputLayout textInputLayout) {
                AutoCompleteTextView autoCompleteTextView = DropdownMenuEndIconDelegate.castAutoCompleteTextViewOrThrow(textInputLayout.getEditText());
                DropdownMenuEndIconDelegate.this.setPopupBackground(autoCompleteTextView);
                DropdownMenuEndIconDelegate.this.addRippleEffect(autoCompleteTextView);
                DropdownMenuEndIconDelegate.this.setUpDropdownShowHideBehavior(autoCompleteTextView);
                autoCompleteTextView.setThreshold(0);
                autoCompleteTextView.removeTextChangedListener(DropdownMenuEndIconDelegate.this.exposedDropdownEndIconTextWatcher);
                autoCompleteTextView.addTextChangedListener(DropdownMenuEndIconDelegate.this.exposedDropdownEndIconTextWatcher);
                textInputLayout.setEndIconCheckable(true);
                textInputLayout.setErrorIconDrawable(null);
                if (!DropdownMenuEndIconDelegate.isEditable((EditText)autoCompleteTextView)) {
                    ViewCompat.setImportantForAccessibility((View)DropdownMenuEndIconDelegate.this.endIconView, (int)2);
                }
                textInputLayout.setTextInputAccessibilityDelegate(DropdownMenuEndIconDelegate.this.accessibilityDelegate);
                textInputLayout.setEndIconVisible(true);
            }
        };
        this.endIconChangedListener = new TextInputLayout.OnEndIconChangedListener(){

            @Override
            public void onEndIconChanged(TextInputLayout textInputLayout, int n) {
                if ((textInputLayout = (AutoCompleteTextView)textInputLayout.getEditText()) != null && n == 3) {
                    textInputLayout.post(new Runnable((AutoCompleteTextView)textInputLayout){
                        final /* synthetic */ AutoCompleteTextView val$editText;
                        {
                            this.val$editText = autoCompleteTextView;
                        }

                        @Override
                        public void run() {
                            this.val$editText.removeTextChangedListener(DropdownMenuEndIconDelegate.this.exposedDropdownEndIconTextWatcher);
                        }
                    });
                    if (textInputLayout.getOnFocusChangeListener() == DropdownMenuEndIconDelegate.this.onFocusChangeListener) {
                        textInputLayout.setOnFocusChangeListener(null);
                    }
                    textInputLayout.setOnTouchListener(null);
                    if (IS_LOLLIPOP) {
                        textInputLayout.setOnDismissListener(null);
                    }
                }
            }
        };
        this.dropdownPopupActivatedAt = Long.MAX_VALUE;
    }

    static /* synthetic */ long access$1402(DropdownMenuEndIconDelegate dropdownMenuEndIconDelegate, long l) {
        dropdownMenuEndIconDelegate.dropdownPopupActivatedAt = l;
        return l;
    }

    static /* synthetic */ boolean access$402(DropdownMenuEndIconDelegate dropdownMenuEndIconDelegate, boolean bl) {
        dropdownMenuEndIconDelegate.dropdownPopupDirty = bl;
        return bl;
    }

    private void addRippleEffect(AutoCompleteTextView autoCompleteTextView) {
        if (DropdownMenuEndIconDelegate.isEditable((EditText)autoCompleteTextView)) {
            return;
        }
        int n = this.textInputLayout.getBoxBackgroundMode();
        MaterialShapeDrawable materialShapeDrawable = this.textInputLayout.getBoxBackground();
        int n2 = MaterialColors.getColor((View)autoCompleteTextView, R.attr.colorControlHighlight);
        int[][] nArrayArray = new int[][]{{16842919}, new int[0]};
        if (n == 2) {
            this.addRippleEffectOnOutlinedLayout(autoCompleteTextView, n2, nArrayArray, materialShapeDrawable);
        } else if (n == 1) {
            this.addRippleEffectOnFilledLayout(autoCompleteTextView, n2, nArrayArray, materialShapeDrawable);
        }
    }

    private void addRippleEffectOnFilledLayout(AutoCompleteTextView autoCompleteTextView, int n, int[][] object, MaterialShapeDrawable materialShapeDrawable) {
        int n2 = this.textInputLayout.getBoxBackgroundColor();
        n = MaterialColors.layer(n, n2, 0.1f);
        int[] nArray = new int[]{n, n2};
        if (IS_LOLLIPOP) {
            ViewCompat.setBackground((View)autoCompleteTextView, (Drawable)new RippleDrawable(new ColorStateList(object, nArray), (Drawable)materialShapeDrawable, (Drawable)materialShapeDrawable));
        } else {
            MaterialShapeDrawable materialShapeDrawable2 = new MaterialShapeDrawable(materialShapeDrawable.getShapeAppearanceModel());
            materialShapeDrawable2.setFillColor(new ColorStateList(object, nArray));
            object = new LayerDrawable(new Drawable[]{materialShapeDrawable, materialShapeDrawable2});
            int n3 = ViewCompat.getPaddingStart((View)autoCompleteTextView);
            n2 = autoCompleteTextView.getPaddingTop();
            n = ViewCompat.getPaddingEnd((View)autoCompleteTextView);
            int n4 = autoCompleteTextView.getPaddingBottom();
            ViewCompat.setBackground((View)autoCompleteTextView, (Drawable)object);
            ViewCompat.setPaddingRelative((View)autoCompleteTextView, (int)n3, (int)n2, (int)n, (int)n4);
        }
    }

    private void addRippleEffectOnOutlinedLayout(AutoCompleteTextView autoCompleteTextView, int n, int[][] object, MaterialShapeDrawable materialShapeDrawable) {
        int n2 = MaterialColors.getColor((View)autoCompleteTextView, R.attr.colorSurface);
        MaterialShapeDrawable materialShapeDrawable2 = new MaterialShapeDrawable(materialShapeDrawable.getShapeAppearanceModel());
        n = MaterialColors.layer(n, n2, 0.1f);
        materialShapeDrawable2.setFillColor(new ColorStateList(object, new int[]{n, 0}));
        if (IS_LOLLIPOP) {
            materialShapeDrawable2.setTint(n2);
            object = new ColorStateList(object, new int[]{n, n2});
            MaterialShapeDrawable materialShapeDrawable3 = new MaterialShapeDrawable(materialShapeDrawable.getShapeAppearanceModel());
            materialShapeDrawable3.setTint(-1);
            object = new LayerDrawable(new Drawable[]{new RippleDrawable((ColorStateList)object, (Drawable)materialShapeDrawable2, (Drawable)materialShapeDrawable3), materialShapeDrawable});
        } else {
            object = new LayerDrawable(new Drawable[]{materialShapeDrawable2, materialShapeDrawable});
        }
        ViewCompat.setBackground((View)autoCompleteTextView, (Drawable)object);
    }

    private static AutoCompleteTextView castAutoCompleteTextViewOrThrow(EditText editText) {
        if (editText instanceof AutoCompleteTextView) {
            return (AutoCompleteTextView)editText;
        }
        throw new RuntimeException("EditText needs to be an AutoCompleteTextView if an Exposed Dropdown Menu is being used.");
    }

    private ValueAnimator getAlphaAnimator(int n, float ... object) {
        object = ValueAnimator.ofFloat((float[])object);
        object.setInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        object.setDuration((long)n);
        object.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float f = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                DropdownMenuEndIconDelegate.this.endIconView.setAlpha(f);
            }
        });
        return object;
    }

    private MaterialShapeDrawable getPopUpMaterialShapeDrawable(float f, float f2, float f3, int n) {
        ShapeAppearanceModel shapeAppearanceModel = ShapeAppearanceModel.builder().setTopLeftCornerSize(f).setTopRightCornerSize(f).setBottomLeftCornerSize(f2).setBottomRightCornerSize(f2).build();
        MaterialShapeDrawable materialShapeDrawable = MaterialShapeDrawable.createWithElevationOverlay(this.context, f3);
        materialShapeDrawable.setShapeAppearanceModel(shapeAppearanceModel);
        materialShapeDrawable.setPadding(0, n, 0, n);
        return materialShapeDrawable;
    }

    private void initAnimators() {
        ValueAnimator valueAnimator;
        this.fadeInAnim = this.getAlphaAnimator(67, 0.0f, 1.0f);
        this.fadeOutAnim = valueAnimator = this.getAlphaAnimator(50, 1.0f, 0.0f);
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator2) {
                DropdownMenuEndIconDelegate.this.endIconView.setChecked(DropdownMenuEndIconDelegate.this.isEndIconChecked);
                DropdownMenuEndIconDelegate.this.fadeInAnim.start();
            }
        });
    }

    private boolean isDropdownPopupActive() {
        long l = System.currentTimeMillis() - this.dropdownPopupActivatedAt;
        boolean bl = l < 0L || l > 300L;
        return bl;
    }

    private static boolean isEditable(EditText editText) {
        boolean bl = editText.getKeyListener() != null;
        return bl;
    }

    private void setEndIconChecked(boolean bl) {
        if (this.isEndIconChecked != bl) {
            this.isEndIconChecked = bl;
            this.fadeInAnim.cancel();
            this.fadeOutAnim.start();
        }
    }

    private void setPopupBackground(AutoCompleteTextView autoCompleteTextView) {
        if (IS_LOLLIPOP) {
            int n = this.textInputLayout.getBoxBackgroundMode();
            if (n == 2) {
                autoCompleteTextView.setDropDownBackgroundDrawable((Drawable)this.outlinedPopupBackground);
            } else if (n == 1) {
                autoCompleteTextView.setDropDownBackgroundDrawable((Drawable)this.filledPopupBackground);
            }
        }
    }

    private void setUpDropdownShowHideBehavior(final AutoCompleteTextView autoCompleteTextView) {
        autoCompleteTextView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 1) {
                    if (DropdownMenuEndIconDelegate.this.isDropdownPopupActive()) {
                        DropdownMenuEndIconDelegate.access$402(DropdownMenuEndIconDelegate.this, false);
                    }
                    DropdownMenuEndIconDelegate.this.showHideDropdown(autoCompleteTextView);
                }
                return false;
            }
        });
        autoCompleteTextView.setOnFocusChangeListener(this.onFocusChangeListener);
        if (IS_LOLLIPOP) {
            autoCompleteTextView.setOnDismissListener(new AutoCompleteTextView.OnDismissListener(){

                public void onDismiss() {
                    DropdownMenuEndIconDelegate.access$402(DropdownMenuEndIconDelegate.this, true);
                    DropdownMenuEndIconDelegate.access$1402(DropdownMenuEndIconDelegate.this, System.currentTimeMillis());
                    DropdownMenuEndIconDelegate.this.setEndIconChecked(false);
                }
            });
        }
    }

    private void showHideDropdown(AutoCompleteTextView autoCompleteTextView) {
        if (autoCompleteTextView == null) {
            return;
        }
        if (this.isDropdownPopupActive()) {
            this.dropdownPopupDirty = false;
        }
        if (!this.dropdownPopupDirty) {
            if (IS_LOLLIPOP) {
                this.setEndIconChecked(this.isEndIconChecked ^ true);
            } else {
                this.isEndIconChecked ^= true;
                this.endIconView.toggle();
            }
            if (this.isEndIconChecked) {
                autoCompleteTextView.requestFocus();
                autoCompleteTextView.showDropDown();
            } else {
                autoCompleteTextView.dismissDropDown();
            }
        } else {
            this.dropdownPopupDirty = false;
        }
    }

    @Override
    void initialize() {
        StateListDrawable stateListDrawable;
        float f = this.context.getResources().getDimensionPixelOffset(R.dimen.mtrl_shape_corner_size_small_component);
        float f2 = this.context.getResources().getDimensionPixelOffset(R.dimen.mtrl_exposed_dropdown_menu_popup_elevation);
        int n = this.context.getResources().getDimensionPixelOffset(R.dimen.mtrl_exposed_dropdown_menu_popup_vertical_padding);
        MaterialShapeDrawable materialShapeDrawable = this.getPopUpMaterialShapeDrawable(f, f, f2, n);
        MaterialShapeDrawable materialShapeDrawable2 = this.getPopUpMaterialShapeDrawable(0.0f, f, f2, n);
        this.outlinedPopupBackground = materialShapeDrawable;
        this.filledPopupBackground = stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{0x10100AA}, (Drawable)materialShapeDrawable);
        this.filledPopupBackground.addState(new int[0], (Drawable)materialShapeDrawable2);
        n = this.customEndIcon == 0 ? (IS_LOLLIPOP ? R.drawable.mtrl_dropdown_arrow : R.drawable.mtrl_ic_arrow_drop_down) : this.customEndIcon;
        this.textInputLayout.setEndIconDrawable(n);
        this.textInputLayout.setEndIconContentDescription(this.textInputLayout.getResources().getText(R.string.exposed_dropdown_menu_content_description));
        this.textInputLayout.setEndIconOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                view = (AutoCompleteTextView)DropdownMenuEndIconDelegate.this.textInputLayout.getEditText();
                DropdownMenuEndIconDelegate.this.showHideDropdown((AutoCompleteTextView)view);
            }
        });
        this.textInputLayout.addOnEditTextAttachedListener(this.dropdownMenuOnEditTextAttachedListener);
        this.textInputLayout.addOnEndIconChangedListener(this.endIconChangedListener);
        this.initAnimators();
        this.accessibilityManager = (AccessibilityManager)this.context.getSystemService("accessibility");
    }

    @Override
    boolean isBoxBackgroundModeSupported(int n) {
        boolean bl = n != 0;
        return bl;
    }

    @Override
    boolean shouldTintIconOnError() {
        return true;
    }
}

