/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityManager;
import android.widget.AdapterView;
import android.widget.Filterable;
import android.widget.ListAdapter;
import androidx.appcompat.widget.AppCompatAutoCompleteTextView;
import androidx.appcompat.widget.ListPopupWindow;
import com.google.android.material.R;
import com.google.android.material.internal.ManufacturerUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.textfield.TextInputLayout;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class MaterialAutoCompleteTextView
extends AppCompatAutoCompleteTextView {
    private static final int MAX_ITEMS_MEASURED = 15;
    private final AccessibilityManager accessibilityManager;
    private final ListPopupWindow modalListPopup;
    private final Rect tempRect = new Rect();

    public MaterialAutoCompleteTextView(Context context) {
        this(context, null);
    }

    public MaterialAutoCompleteTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.autoCompleteTextViewStyle);
    }

    public MaterialAutoCompleteTextView(Context context, AttributeSet attributeSet, int n) {
        super(MaterialThemeOverlay.wrap(context, attributeSet, n, 0), attributeSet, n);
        context = this.getContext();
        attributeSet = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.MaterialAutoCompleteTextView, n, R.style.Widget_AppCompat_AutoCompleteTextView, new int[0]);
        if (attributeSet.hasValue(R.styleable.MaterialAutoCompleteTextView_android_inputType) && attributeSet.getInt(R.styleable.MaterialAutoCompleteTextView_android_inputType, 0) == 0) {
            this.setKeyListener(null);
        }
        this.accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        context = new ListPopupWindow(context);
        this.modalListPopup = context;
        context.setModal(true);
        context.setAnchorView((View)this);
        context.setInputMethodMode(2);
        context.setAdapter(this.getAdapter());
        context.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> object, View view, int n, long l) {
                block2: {
                    int n2;
                    block4: {
                        block3: {
                            object = n < 0 ? MaterialAutoCompleteTextView.this.modalListPopup.getSelectedItem() : MaterialAutoCompleteTextView.this.getAdapter().getItem(n);
                            MaterialAutoCompleteTextView.this.updateText(object);
                            object = MaterialAutoCompleteTextView.this.getOnItemClickListener();
                            if (object == null) break block2;
                            if (view == null) break block3;
                            n2 = n;
                            if (n >= 0) break block4;
                        }
                        view = MaterialAutoCompleteTextView.this.modalListPopup.getSelectedView();
                        n2 = MaterialAutoCompleteTextView.this.modalListPopup.getSelectedItemPosition();
                        l = MaterialAutoCompleteTextView.this.modalListPopup.getSelectedItemId();
                    }
                    object.onItemClick((AdapterView)MaterialAutoCompleteTextView.this.modalListPopup.getListView(), view, n2, l);
                }
                MaterialAutoCompleteTextView.this.modalListPopup.dismiss();
            }
        });
        attributeSet.recycle();
    }

    private TextInputLayout findTextInputLayoutAncestor() {
        for (ViewParent viewParent = this.getParent(); viewParent != null; viewParent = viewParent.getParent()) {
            if (!(viewParent instanceof TextInputLayout)) continue;
            return (TextInputLayout)viewParent;
        }
        return null;
    }

    private int measureContentWidth() {
        ListAdapter listAdapter = this.getAdapter();
        TextInputLayout textInputLayout = this.findTextInputLayoutAncestor();
        int n = 0;
        if (listAdapter != null && textInputLayout != null) {
            int n2;
            int n3 = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0);
            int n4 = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0);
            int n5 = Math.max(0, this.modalListPopup.getSelectedItemPosition());
            int n6 = Math.min(listAdapter.getCount(), n5 + 15);
            Drawable drawable2 = null;
            n5 = 0;
            for (n2 = Math.max(0, n6 - 15); n2 < n6; ++n2) {
                int n7 = listAdapter.getItemViewType(n2);
                int n8 = n;
                if (n7 != n) {
                    drawable2 = null;
                    n8 = n7;
                }
                if ((drawable2 = listAdapter.getView(n2, (View)drawable2, (ViewGroup)textInputLayout)).getLayoutParams() == null) {
                    drawable2.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
                }
                drawable2.measure(n3, n4);
                n5 = Math.max(n5, drawable2.getMeasuredWidth());
                n = n8;
            }
            drawable2 = this.modalListPopup.getBackground();
            n2 = n5;
            if (drawable2 != null) {
                drawable2.getPadding(this.tempRect);
                n2 = n5 + (this.tempRect.left + this.tempRect.right);
            }
            return n2 + textInputLayout.getEndIconView().getMeasuredWidth();
        }
        return 0;
    }

    private <T extends ListAdapter & Filterable> void updateText(Object object) {
        if (Build.VERSION.SDK_INT >= 17) {
            this.setText(this.convertSelectionToString(object), false);
        } else {
            ListAdapter listAdapter = this.getAdapter();
            this.setAdapter(null);
            this.setText(this.convertSelectionToString(object));
            this.setAdapter(listAdapter);
        }
    }

    public CharSequence getHint() {
        TextInputLayout textInputLayout = this.findTextInputLayoutAncestor();
        if (textInputLayout != null && textInputLayout.isProvidingHint()) {
            return textInputLayout.getHint();
        }
        return super.getHint();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        TextInputLayout textInputLayout = this.findTextInputLayoutAncestor();
        if (textInputLayout != null && textInputLayout.isProvidingHint() && super.getHint() == null && ManufacturerUtils.isMeizuDevice()) {
            this.setHint("");
        }
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        if (View.MeasureSpec.getMode((int)n) == Integer.MIN_VALUE) {
            this.setMeasuredDimension(Math.min(Math.max(this.getMeasuredWidth(), this.measureContentWidth()), View.MeasureSpec.getSize((int)n)), this.getMeasuredHeight());
        }
    }

    public <T extends ListAdapter & Filterable> void setAdapter(T t) {
        super.setAdapter(t);
        this.modalListPopup.setAdapter(this.getAdapter());
    }

    public void showDropDown() {
        AccessibilityManager accessibilityManager = this.accessibilityManager;
        if (accessibilityManager != null && accessibilityManager.isTouchExplorationEnabled()) {
            this.modalListPopup.show();
        } else {
            super.showDropDown();
        }
    }
}

