/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.View;
import android.widget.EditText;
import com.google.android.material.R;
import com.google.android.material.internal.TextWatcherAdapter;
import com.google.android.material.textfield.EndIconDelegate;
import com.google.android.material.textfield.TextInputLayout;

class PasswordToggleEndIconDelegate
extends EndIconDelegate {
    private final TextInputLayout.OnEditTextAttachedListener onEditTextAttachedListener;
    private final TextInputLayout.OnEndIconChangedListener onEndIconChangedListener;
    private final TextWatcher textWatcher = new TextWatcherAdapter(){

        @Override
        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            PasswordToggleEndIconDelegate.this.endIconView.setChecked(PasswordToggleEndIconDelegate.this.hasPasswordTransformation() ^ true);
        }
    };

    PasswordToggleEndIconDelegate(TextInputLayout textInputLayout, int n) {
        super(textInputLayout, n);
        this.onEditTextAttachedListener = new TextInputLayout.OnEditTextAttachedListener(){

            @Override
            public void onEditTextAttached(TextInputLayout textInputLayout) {
                EditText editText = textInputLayout.getEditText();
                textInputLayout.setEndIconVisible(true);
                textInputLayout.setEndIconCheckable(true);
                PasswordToggleEndIconDelegate.this.endIconView.setChecked(true ^ PasswordToggleEndIconDelegate.this.hasPasswordTransformation());
                editText.removeTextChangedListener(PasswordToggleEndIconDelegate.this.textWatcher);
                editText.addTextChangedListener(PasswordToggleEndIconDelegate.this.textWatcher);
            }
        };
        this.onEndIconChangedListener = new TextInputLayout.OnEndIconChangedListener(){

            @Override
            public void onEndIconChanged(TextInputLayout textInputLayout, int n) {
                if ((textInputLayout = textInputLayout.getEditText()) != null && n == 1) {
                    textInputLayout.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                    textInputLayout.post(new Runnable((EditText)textInputLayout){
                        final /* synthetic */ EditText val$editText;
                        {
                            this.val$editText = editText;
                        }

                        @Override
                        public void run() {
                            this.val$editText.removeTextChangedListener(PasswordToggleEndIconDelegate.this.textWatcher);
                        }
                    });
                }
            }
        };
    }

    private boolean hasPasswordTransformation() {
        EditText editText = this.textInputLayout.getEditText();
        boolean bl = editText != null && editText.getTransformationMethod() instanceof PasswordTransformationMethod;
        return bl;
    }

    private static boolean isInputTypePassword(EditText editText) {
        boolean bl = editText != null && (editText.getInputType() == 16 || editText.getInputType() == 128 || editText.getInputType() == 144 || editText.getInputType() == 224);
        return bl;
    }

    @Override
    void initialize() {
        TextInputLayout textInputLayout = this.textInputLayout;
        int n = this.customEndIcon == 0 ? R.drawable.design_password_eye : this.customEndIcon;
        textInputLayout.setEndIconDrawable(n);
        this.textInputLayout.setEndIconContentDescription(this.textInputLayout.getResources().getText(R.string.password_toggle_content_description));
        this.textInputLayout.setEndIconOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                view = PasswordToggleEndIconDelegate.this.textInputLayout.getEditText();
                if (view == null) {
                    return;
                }
                int n = view.getSelectionEnd();
                if (PasswordToggleEndIconDelegate.this.hasPasswordTransformation()) {
                    view.setTransformationMethod(null);
                } else {
                    view.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                }
                if (n >= 0) {
                    view.setSelection(n);
                }
                PasswordToggleEndIconDelegate.this.textInputLayout.refreshEndIconDrawableState();
            }
        });
        this.textInputLayout.addOnEditTextAttachedListener(this.onEditTextAttachedListener);
        this.textInputLayout.addOnEndIconChangedListener(this.onEndIconChangedListener);
        textInputLayout = this.textInputLayout.getEditText();
        if (PasswordToggleEndIconDelegate.isInputTypePassword((EditText)textInputLayout)) {
            textInputLayout.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        }
    }
}

