/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.text.Editable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import androidx.appcompat.widget.AppCompatEditText;
import com.google.android.material.R;
import com.google.android.material.internal.ManufacturerUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.textfield.TextInputLayout;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class TextInputEditText
extends AppCompatEditText {
    private final Rect parentRect = new Rect();
    private boolean textInputLayoutFocusedRectEnabled;

    public TextInputEditText(Context context) {
        this(context, null);
    }

    public TextInputEditText(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.editTextStyle);
    }

    public TextInputEditText(Context context, AttributeSet attributeSet, int n) {
        super(MaterialThemeOverlay.wrap(context, attributeSet, n, 0), attributeSet, n);
        context = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.TextInputEditText, n, R.style.Widget_Design_TextInputEditText, new int[0]);
        this.setTextInputLayoutFocusedRectEnabled(context.getBoolean(R.styleable.TextInputEditText_textInputLayoutFocusedRectEnabled, false));
        context.recycle();
    }

    private String getAccessibilityNodeInfoText(TextInputLayout object) {
        Editable editable = this.getText();
        object = ((TextInputLayout)((Object)object)).getHint();
        boolean bl = TextUtils.isEmpty((CharSequence)editable);
        boolean bl2 = TextUtils.isEmpty((CharSequence)object);
        if (Build.VERSION.SDK_INT >= 17) {
            this.setLabelFor(R.id.textinput_helper_text);
        }
        CharSequence charSequence = "";
        object = bl2 ^ true ? object.toString() : "";
        if (bl ^ true) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(editable);
            if (!TextUtils.isEmpty((CharSequence)object)) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append((String)object);
                charSequence = ((StringBuilder)charSequence).toString();
            }
            stringBuilder.append((String)charSequence);
            return stringBuilder.toString();
        }
        if (!TextUtils.isEmpty((CharSequence)object)) {
            return object;
        }
        return "";
    }

    private CharSequence getHintFromLayout() {
        Object object = this.getTextInputLayout();
        object = object != null ? object.getHint() : null;
        return object;
    }

    private TextInputLayout getTextInputLayout() {
        ViewParent viewParent = this.getParent();
        while (viewParent instanceof View) {
            if (viewParent instanceof TextInputLayout) {
                return (TextInputLayout)viewParent;
            }
            viewParent = viewParent.getParent();
        }
        return null;
    }

    public void getFocusedRect(Rect rect) {
        super.getFocusedRect(rect);
        TextInputLayout textInputLayout = this.getTextInputLayout();
        if (textInputLayout != null && this.textInputLayoutFocusedRectEnabled && rect != null) {
            textInputLayout.getFocusedRect(this.parentRect);
            rect.bottom = this.parentRect.bottom;
        }
    }

    public boolean getGlobalVisibleRect(Rect rect, Point point) {
        boolean bl = super.getGlobalVisibleRect(rect, point);
        TextInputLayout textInputLayout = this.getTextInputLayout();
        if (textInputLayout != null && this.textInputLayoutFocusedRectEnabled && rect != null) {
            textInputLayout.getGlobalVisibleRect(this.parentRect, point);
            rect.bottom = this.parentRect.bottom;
        }
        return bl;
    }

    public CharSequence getHint() {
        TextInputLayout textInputLayout = this.getTextInputLayout();
        if (textInputLayout != null && textInputLayout.isProvidingHint()) {
            return textInputLayout.getHint();
        }
        return super.getHint();
    }

    public boolean isTextInputLayoutFocusedRectEnabled() {
        return this.textInputLayoutFocusedRectEnabled;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        TextInputLayout textInputLayout = this.getTextInputLayout();
        if (textInputLayout != null && textInputLayout.isProvidingHint() && super.getHint() == null && ManufacturerUtils.isMeizuDevice()) {
            this.setHint("");
        }
    }

    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        InputConnection inputConnection = super.onCreateInputConnection(editorInfo);
        if (inputConnection != null && editorInfo.hintText == null) {
            editorInfo.hintText = this.getHintFromLayout();
        }
        return inputConnection;
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        TextInputLayout textInputLayout = this.getTextInputLayout();
        if (Build.VERSION.SDK_INT < 23 && textInputLayout != null) {
            accessibilityNodeInfo.setText((CharSequence)this.getAccessibilityNodeInfoText(textInputLayout));
        }
    }

    public boolean requestRectangleOnScreen(Rect object) {
        boolean bl = super.requestRectangleOnScreen(object);
        object = this.getTextInputLayout();
        if (object != null && this.textInputLayoutFocusedRectEnabled) {
            this.parentRect.set(0, object.getHeight() - this.getResources().getDimensionPixelOffset(R.dimen.mtrl_edittext_rectangle_top_offset), object.getWidth(), object.getHeight());
            object.requestRectangleOnScreen(this.parentRect, true);
        }
        return bl;
    }

    public void setTextInputLayoutFocusedRectEnabled(boolean bl) {
        this.textInputLayoutFocusedRectEnabled = bl;
    }
}

