/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatTextView;
import com.google.android.material.R;
import com.google.android.material.resources.MaterialAttributes;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class MaterialTextView
extends AppCompatTextView {
    public MaterialTextView(Context context) {
        this(context, null);
    }

    public MaterialTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842884);
    }

    public MaterialTextView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public MaterialTextView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(MaterialThemeOverlay.wrap(context, attributeSet, n, n2), attributeSet, n);
        Resources.Theme theme;
        context = this.getContext();
        if (MaterialTextView.canApplyTextAppearanceLineHeight(context) && !MaterialTextView.viewAttrsHasLineHeight(context, theme = context.getTheme(), attributeSet, n, n2) && (n = MaterialTextView.findViewAppearanceResourceId(theme, attributeSet, n, n2)) != -1) {
            this.applyLineHeightFromViewAppearance(theme, n);
        }
    }

    private void applyLineHeightFromViewAppearance(Resources.Theme theme, int n) {
        theme = theme.obtainStyledAttributes(n, R.styleable.MaterialTextAppearance);
        n = MaterialTextView.readFirstAvailableDimension(this.getContext(), (TypedArray)theme, R.styleable.MaterialTextAppearance_android_lineHeight, R.styleable.MaterialTextAppearance_lineHeight);
        theme.recycle();
        if (n >= 0) {
            this.setLineHeight(n);
        }
    }

    private static boolean canApplyTextAppearanceLineHeight(Context context) {
        return MaterialAttributes.resolveBoolean(context, R.attr.textAppearanceLineHeightEnabled, true);
    }

    private static int findViewAppearanceResourceId(Resources.Theme theme, AttributeSet attributeSet, int n, int n2) {
        theme = theme.obtainStyledAttributes(attributeSet, R.styleable.MaterialTextView, n, n2);
        n = theme.getResourceId(R.styleable.MaterialTextView_android_textAppearance, -1);
        theme.recycle();
        return n;
    }

    private static int readFirstAvailableDimension(Context context, TypedArray typedArray, int ... nArray) {
        int n = -1;
        for (int i = 0; i < nArray.length && n < 0; ++i) {
            n = MaterialResources.getDimensionPixelSize(context, typedArray, nArray[i], -1);
        }
        return n;
    }

    private static boolean viewAttrsHasLineHeight(Context context, Resources.Theme theme, AttributeSet attributeSet, int n, int n2) {
        theme = theme.obtainStyledAttributes(attributeSet, R.styleable.MaterialTextView, n, n2);
        n = R.styleable.MaterialTextView_android_lineHeight;
        boolean bl = false;
        n = MaterialTextView.readFirstAvailableDimension(context, (TypedArray)theme, n, R.styleable.MaterialTextView_lineHeight);
        theme.recycle();
        if (n != -1) {
            bl = true;
        }
        return bl;
    }

    public void setTextAppearance(Context context, int n) {
        super.setTextAppearance(context, n);
        if (MaterialTextView.canApplyTextAppearanceLineHeight(context)) {
            this.applyLineHeightFromViewAppearance(context.getTheme(), n);
        }
    }
}

