/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.LocaleList;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.chip.Chip;
import com.google.android.material.internal.TextWatcherAdapter;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.textfield.TextInputLayout;
import com.google.android.material.timepicker.TimeModel;
import java.util.Arrays;

class ChipTextInputComboView
extends FrameLayout
implements Checkable {
    private final Chip chip;
    private final EditText editText;
    private TextView label;
    private final TextInputLayout textInputLayout;
    private TextWatcher watcher;

    public ChipTextInputComboView(Context context) {
        this(context, null);
    }

    public ChipTextInputComboView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ChipTextInputComboView(Context object, AttributeSet object2, int n) {
        super(object, object2, n);
        EditText editText;
        TextInputLayout textInputLayout;
        object2 = LayoutInflater.from((Context)object);
        object = (Chip)object2.inflate(R.layout.material_time_chip, (ViewGroup)this, false);
        this.chip = object;
        this.textInputLayout = textInputLayout = (TextInputLayout)object2.inflate(R.layout.material_time_input, (ViewGroup)this, false);
        this.editText = editText = textInputLayout.getEditText();
        editText.setVisibility(4);
        object2 = new TextFormatter();
        this.watcher = object2;
        editText.addTextChangedListener((TextWatcher)object2);
        this.updateHintLocales();
        this.addView((View)object);
        this.addView((View)textInputLayout);
        this.label = (TextView)this.findViewById(R.id.material_label);
        editText.setSaveEnabled(false);
    }

    private String formatText(CharSequence charSequence) {
        return TimeModel.formatText(this.getResources(), charSequence);
    }

    private void updateHintLocales() {
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList localeList = this.getContext().getResources().getConfiguration().getLocales();
            this.editText.setImeHintLocales(localeList);
        }
    }

    public void addInputFilter(InputFilter inputFilter) {
        InputFilter[] inputFilterArray = this.editText.getFilters();
        InputFilter[] inputFilterArray2 = Arrays.copyOf(inputFilterArray, inputFilterArray.length + 1);
        inputFilterArray2[inputFilterArray.length] = inputFilter;
        this.editText.setFilters(inputFilterArray2);
    }

    public TextInputLayout getTextInput() {
        return this.textInputLayout;
    }

    public boolean isChecked() {
        return this.chip.isChecked();
    }

    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.updateHintLocales();
    }

    public void setChecked(boolean bl) {
        this.chip.setChecked(bl);
        Object object = this.editText;
        int n = 0;
        int n2 = bl ? 0 : 4;
        object.setVisibility(n2);
        object = this.chip;
        n2 = n;
        if (bl) {
            n2 = 8;
        }
        object.setVisibility(n2);
        if (this.isChecked()) {
            ViewUtils.requestFocusAndShowKeyboard((View)this.editText);
            if (!TextUtils.isEmpty((CharSequence)this.editText.getText())) {
                object = this.editText;
                object.setSelection(object.getText().length());
            }
        }
    }

    public void setChipDelegate(AccessibilityDelegateCompat accessibilityDelegateCompat) {
        ViewCompat.setAccessibilityDelegate((View)this.chip, (AccessibilityDelegateCompat)accessibilityDelegateCompat);
    }

    public void setCursorVisible(boolean bl) {
        this.editText.setCursorVisible(bl);
    }

    public void setHelperText(CharSequence charSequence) {
        this.label.setText(charSequence);
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.chip.setOnClickListener(onClickListener);
    }

    public void setTag(int n, Object object) {
        this.chip.setTag(n, object);
    }

    public void setText(CharSequence charSequence) {
        this.chip.setText(this.formatText(charSequence));
        if (!TextUtils.isEmpty((CharSequence)this.editText.getText())) {
            this.editText.removeTextChangedListener(this.watcher);
            this.editText.setText(null);
            this.editText.addTextChangedListener(this.watcher);
        }
    }

    public void toggle() {
        this.chip.toggle();
    }

    private class TextFormatter
    extends TextWatcherAdapter {
        private static final String DEFAULT_TEXT = "00";

        private TextFormatter() {
        }

        @Override
        public void afterTextChanged(Editable editable) {
            if (TextUtils.isEmpty((CharSequence)editable)) {
                ChipTextInputComboView.this.chip.setText(ChipTextInputComboView.this.formatText(DEFAULT_TEXT));
                return;
            }
            ChipTextInputComboView.this.chip.setText(ChipTextInputComboView.this.formatText((CharSequence)editable));
        }
    }
}

