/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.TextView;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.timepicker.ClockHandView;
import com.google.android.material.timepicker.RadialViewGroup;
import java.util.Arrays;

class ClockFaceView
extends RadialViewGroup
implements ClockHandView.OnRotateListener {
    private static final float EPSILON = 0.001f;
    private static final int INITIAL_CAPACITY = 12;
    private static final String VALUE_PLACEHOLDER = "";
    private final int clockHandPadding;
    private final ClockHandView clockHandView;
    private final int clockSize;
    private float currentHandRotation;
    private final int[] gradientColors;
    private final float[] gradientPositions;
    private final int minimumHeight;
    private final int minimumWidth;
    private final RectF scratch;
    private final ColorStateList textColor;
    private final SparseArray<TextView> textViewPool;
    private final Rect textViewRect = new Rect();
    private final AccessibilityDelegateCompat valueAccessibilityDelegate;
    private String[] values;

    public ClockFaceView(Context context) {
        this(context, null);
    }

    public ClockFaceView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.materialClockStyle);
    }

    public ClockFaceView(Context objectArray, AttributeSet attributeSet, int n) {
        super((Context)objectArray, attributeSet, n);
        ClockHandView clockHandView;
        ColorStateList colorStateList;
        this.scratch = new RectF();
        this.textViewPool = new SparseArray();
        this.gradientPositions = new float[]{0.0f, 0.9f, 1.0f};
        TypedArray typedArray = objectArray.obtainStyledAttributes(attributeSet, R.styleable.ClockFaceView, n, R.style.Widget_MaterialComponents_TimePicker_Clock);
        attributeSet = this.getResources();
        this.textColor = colorStateList = MaterialResources.getColorStateList((Context)objectArray, typedArray, R.styleable.ClockFaceView_clockNumberTextColor);
        LayoutInflater.from((Context)objectArray).inflate(R.layout.material_clockface_view, (ViewGroup)this, true);
        this.clockHandView = clockHandView = (ClockHandView)this.findViewById(R.id.material_clock_hand);
        this.clockHandPadding = attributeSet.getDimensionPixelSize(R.dimen.material_clock_hand_padding);
        n = colorStateList.getDefaultColor();
        n = colorStateList.getColorForState(new int[]{0x10100A1}, n);
        this.gradientColors = new int[]{n, n, colorStateList.getDefaultColor()};
        clockHandView.addOnRotateListener(this);
        n = AppCompatResources.getColorStateList((Context)objectArray, (int)R.color.material_timepicker_clockface).getDefaultColor();
        objectArray = MaterialResources.getColorStateList((Context)objectArray, typedArray, R.styleable.ClockFaceView_clockFaceBackgroundColor);
        if (objectArray != null) {
            n = objectArray.getDefaultColor();
        }
        this.setBackgroundColor(n);
        this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                if (!ClockFaceView.this.isShown()) {
                    return true;
                }
                ClockFaceView.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                int n = ClockFaceView.this.getHeight() / 2;
                int n2 = ClockFaceView.this.clockHandView.getSelectorRadius();
                int n3 = ClockFaceView.this.clockHandPadding;
                ClockFaceView.this.setRadius(n - n2 - n3);
                return true;
            }
        });
        this.setFocusable(true);
        typedArray.recycle();
        this.valueAccessibilityDelegate = new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                int n = (Integer)view.getTag(R.id.material_value_index);
                if (n > 0) {
                    accessibilityNodeInfoCompat.setTraversalAfter((View)ClockFaceView.this.textViewPool.get(n - 1));
                }
                accessibilityNodeInfoCompat.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)0, (int)1, (int)n, (int)1, (boolean)false, (boolean)view.isSelected()));
            }
        };
        objectArray = new String[12];
        Arrays.fill(objectArray, VALUE_PLACEHOLDER);
        this.setValues((String[])objectArray, 0);
        this.minimumHeight = attributeSet.getDimensionPixelSize(R.dimen.material_time_picker_minimum_screen_height);
        this.minimumWidth = attributeSet.getDimensionPixelSize(R.dimen.material_time_picker_minimum_screen_width);
        this.clockSize = attributeSet.getDimensionPixelSize(R.dimen.material_clock_size);
    }

    private void findIntersectingTextView() {
        RectF rectF = this.clockHandView.getCurrentSelectorBox();
        for (int i = 0; i < this.textViewPool.size(); ++i) {
            TextView textView = (TextView)this.textViewPool.get(i);
            if (textView == null) continue;
            textView.getDrawingRect(this.textViewRect);
            this.textViewRect.offset(textView.getPaddingLeft(), textView.getPaddingTop());
            this.offsetDescendantRectToMyCoords((View)textView, this.textViewRect);
            this.scratch.set(this.textViewRect);
            RadialGradient radialGradient = this.getGradientForTextView(rectF, this.scratch);
            textView.getPaint().setShader((Shader)radialGradient);
            textView.invalidate();
        }
    }

    private RadialGradient getGradientForTextView(RectF rectF, RectF rectF2) {
        if (!RectF.intersects((RectF)rectF, (RectF)rectF2)) {
            return null;
        }
        return new RadialGradient(rectF.centerX() - this.scratch.left, rectF.centerY() - this.scratch.top, rectF.width() * 0.5f, this.gradientColors, this.gradientPositions, Shader.TileMode.CLAMP);
    }

    private static float max3(float f, float f2, float f3) {
        return Math.max(Math.max(f, f2), f3);
    }

    private void updateTextViews(int n) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        int n2 = this.textViewPool.size();
        for (int i = 0; i < Math.max(this.values.length, n2); ++i) {
            TextView textView = (TextView)this.textViewPool.get(i);
            if (i >= this.values.length) {
                this.removeView((View)textView);
                this.textViewPool.remove(i);
                continue;
            }
            TextView textView2 = textView;
            if (textView == null) {
                textView2 = (TextView)layoutInflater.inflate(R.layout.material_clockface_textview, (ViewGroup)this, false);
                this.textViewPool.put(i, (Object)textView2);
                this.addView((View)textView2);
            }
            textView2.setVisibility(0);
            textView2.setText((CharSequence)this.values[i]);
            textView2.setTag(R.id.material_value_index, (Object)i);
            ViewCompat.setAccessibilityDelegate((View)textView2, (AccessibilityDelegateCompat)this.valueAccessibilityDelegate);
            textView2.setTextColor(this.textColor);
            if (n == 0) continue;
            textView2.setContentDescription((CharSequence)this.getResources().getString(n, new Object[]{this.values[i]}));
        }
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)accessibilityNodeInfo).setCollectionInfo((Object)AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)1, (int)this.values.length, (boolean)false, (int)1));
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.findIntersectingTextView();
    }

    protected void onMeasure(int n, int n2) {
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        float f = displayMetrics.heightPixels;
        float f2 = displayMetrics.widthPixels;
        n = (int)((float)this.clockSize / ClockFaceView.max3((float)this.minimumHeight / f, (float)this.minimumWidth / f2, 1.0f));
        n2 = View.MeasureSpec.makeMeasureSpec((int)n, (int)0x40000000);
        this.setMeasuredDimension(n, n);
        super.onMeasure(n2, n2);
    }

    @Override
    public void onRotate(float f, boolean bl) {
        if (Math.abs(this.currentHandRotation - f) > 0.001f) {
            this.currentHandRotation = f;
            this.findIntersectingTextView();
        }
    }

    public void setHandRotation(float f) {
        this.clockHandView.setHandRotation(f);
        this.findIntersectingTextView();
    }

    @Override
    public void setRadius(int n) {
        if (n != this.getRadius()) {
            super.setRadius(n);
            this.clockHandView.setCircleRadius(this.getRadius());
        }
    }

    public void setValues(String[] stringArray, int n) {
        this.values = stringArray;
        this.updateTextViews(n);
    }
}

