/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import java.util.ArrayList;
import java.util.List;

class ClockHandView
extends View {
    private static final int ANIMATION_DURATION = 200;
    private boolean animatingOnTouchUp;
    private final float centerDotRadius;
    private boolean changedDuringTouch;
    private int circleRadius;
    private double degRad;
    private float downX;
    private float downY;
    private boolean isInTapRegion;
    private final List<OnRotateListener> listeners = new ArrayList<OnRotateListener>();
    private OnActionUpListener onActionUpListener;
    private float originalDeg;
    private final Paint paint;
    private ValueAnimator rotationAnimator;
    private int scaledTouchSlop;
    private final RectF selectorBox;
    private final int selectorRadius;
    private final int selectorStrokeWidth;

    public ClockHandView(Context context) {
        this(context, null);
    }

    public ClockHandView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.materialClockStyle);
    }

    public ClockHandView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        Paint paint;
        this.paint = paint = new Paint();
        this.selectorBox = new RectF();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ClockHandView, n, R.style.Widget_MaterialComponents_TimePicker_Clock);
        this.circleRadius = typedArray.getDimensionPixelSize(R.styleable.ClockHandView_materialCircleRadius, 0);
        this.selectorRadius = typedArray.getDimensionPixelSize(R.styleable.ClockHandView_selectorSize, 0);
        attributeSet = this.getResources();
        this.selectorStrokeWidth = attributeSet.getDimensionPixelSize(R.dimen.material_clock_hand_stroke_width);
        this.centerDotRadius = attributeSet.getDimensionPixelSize(R.dimen.material_clock_hand_center_dot_radius);
        n = typedArray.getColor(R.styleable.ClockHandView_clockHandColor, 0);
        paint.setAntiAlias(true);
        paint.setColor(n);
        this.setHandRotation(0.0f);
        this.scaledTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        ViewCompat.setImportantForAccessibility((View)this, (int)2);
        typedArray.recycle();
    }

    private void drawSelector(Canvas canvas) {
        int n = this.getHeight() / 2;
        int n2 = this.getWidth() / 2;
        float f = n2;
        float f2 = this.circleRadius;
        float f3 = (float)Math.cos(this.degRad);
        float f4 = n;
        float f5 = this.circleRadius;
        float f6 = (float)Math.sin(this.degRad);
        this.paint.setStrokeWidth(0.0f);
        canvas.drawCircle(f2 * f3 + f, f5 * f6 + f4, (float)this.selectorRadius, this.paint);
        double d = Math.sin(this.degRad);
        double d2 = Math.cos(this.degRad);
        double d3 = this.circleRadius - this.selectorRadius;
        f2 = n2 + (int)(d2 * d3);
        f6 = n + (int)(d3 * d);
        this.paint.setStrokeWidth((float)this.selectorStrokeWidth);
        canvas.drawLine(f, f4, f2, f6, this.paint);
        canvas.drawCircle(f, f4, this.centerDotRadius, this.paint);
    }

    private int getDegreesFromXY(float f, float f2) {
        int n = this.getWidth() / 2;
        int n2 = this.getHeight() / 2;
        double d = f - (float)n;
        n2 = n = (int)Math.toDegrees(Math.atan2(f2 - (float)n2, d)) + 90;
        if (n < 0) {
            n2 = n + 360;
        }
        return n2;
    }

    private Pair<Float, Float> getValuesForAnimation(float f) {
        float f2;
        float f3 = f2 = this.getHandRotation();
        float f4 = f;
        if (Math.abs(f2 - f) > 180.0f) {
            float f5 = f;
            if (f2 > 180.0f) {
                f5 = f;
                if (f < 180.0f) {
                    f5 = f + 360.0f;
                }
            }
            f3 = f2;
            f4 = f5;
            if (f2 < 180.0f) {
                f3 = f2;
                f4 = f5;
                if (f5 > 180.0f) {
                    f3 = f2 + 360.0f;
                    f4 = f5;
                }
            }
        }
        return new Pair((Object)Float.valueOf(f3), (Object)Float.valueOf(f4));
    }

    private boolean handleTouchInput(float f, float f2, boolean bl, boolean bl2, boolean bl3) {
        int n = this.getDegreesFromXY(f, f2);
        f = this.getHandRotation();
        f2 = n;
        boolean bl4 = false;
        n = f != f2 ? 1 : 0;
        if (bl2 && n != 0) {
            return true;
        }
        if (n == 0 && !bl) {
            return false;
        }
        bl = bl4;
        if (bl3) {
            bl = bl4;
            if (this.animatingOnTouchUp) {
                bl = true;
            }
        }
        this.setHandRotation(f2, bl);
        return true;
    }

    private void setHandRotationInternal(float f, boolean bl) {
        float f2;
        this.originalDeg = f2 = f % 360.0f;
        this.degRad = Math.toRadians(f2 - 90.0f);
        int n = this.getHeight() / 2;
        f = (float)(this.getWidth() / 2) + (float)this.circleRadius * (float)Math.cos(this.degRad);
        float f3 = (float)n + (float)this.circleRadius * (float)Math.sin(this.degRad);
        Object object = this.selectorBox;
        n = this.selectorRadius;
        object.set(f - (float)n, f3 - (float)n, f + (float)n, f3 + (float)n);
        object = this.listeners.iterator();
        while (object.hasNext()) {
            ((OnRotateListener)object.next()).onRotate(f2, bl);
        }
        this.invalidate();
    }

    public void addOnRotateListener(OnRotateListener onRotateListener) {
        this.listeners.add(onRotateListener);
    }

    public RectF getCurrentSelectorBox() {
        return this.selectorBox;
    }

    public float getHandRotation() {
        return this.originalDeg;
    }

    public int getSelectorRadius() {
        return this.selectorRadius;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawSelector(canvas);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.setHandRotation(this.getHandRotation());
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent object) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n = object.getActionMasked();
        float f = object.getX();
        float f2 = object.getY();
        if (n != 0) {
            if (n != 1 && n != 2) {
                bl3 = false;
                bl2 = false;
            } else {
                int n2 = (int)(f - this.downX);
                int n3 = (int)(f2 - this.downY);
                bl2 = n2 * n2 + n3 * n3 > this.scaledTouchSlop;
                this.isInTapRegion = bl2;
                bl2 = this.changedDuringTouch;
                bl3 = n == 1;
            }
            bl = false;
        } else {
            this.downX = f;
            this.downY = f2;
            this.isInTapRegion = true;
            this.changedDuringTouch = false;
            bl3 = false;
            bl2 = false;
            bl = true;
        }
        boolean bl4 = this.changedDuringTouch;
        this.changedDuringTouch = bl2 = this.handleTouchInput(f, f2, bl2, bl, bl3) | bl4;
        if (bl2 && bl3 && (object = this.onActionUpListener) != null) {
            object.onActionUp(this.getDegreesFromXY(f, f2), this.isInTapRegion);
        }
        return true;
    }

    public void setAnimateOnTouchUp(boolean bl) {
        this.animatingOnTouchUp = bl;
    }

    public void setCircleRadius(int n) {
        this.circleRadius = n;
        this.invalidate();
    }

    public void setHandRotation(float f) {
        this.setHandRotation(f, false);
    }

    public void setHandRotation(float f, boolean bl) {
        ValueAnimator valueAnimator = this.rotationAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        if (!bl) {
            this.setHandRotationInternal(f, false);
            return;
        }
        valueAnimator = this.getValuesForAnimation(f);
        this.rotationAnimator = valueAnimator = ValueAnimator.ofFloat((float[])new float[]{((Float)valueAnimator.first).floatValue(), ((Float)valueAnimator.second).floatValue()});
        valueAnimator.setDuration(200L);
        this.rotationAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float f = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                ClockHandView.this.setHandRotationInternal(f, true);
            }
        });
        this.rotationAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animator2) {
                animator2.end();
            }
        });
        this.rotationAnimator.start();
    }

    public void setOnActionUpListener(OnActionUpListener onActionUpListener) {
        this.onActionUpListener = onActionUpListener;
    }

    public static interface OnActionUpListener {
        public void onActionUp(float var1, boolean var2);
    }

    public static interface OnRotateListener {
        public void onRotate(float var1, boolean var2);
    }
}

