/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.DialogFragment;
import com.google.android.material.R;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.resources.MaterialAttributes;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.timepicker.TimeModel;
import com.google.android.material.timepicker.TimePickerClockPresenter;
import com.google.android.material.timepicker.TimePickerPresenter;
import com.google.android.material.timepicker.TimePickerTextInputPresenter;
import com.google.android.material.timepicker.TimePickerView;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public final class MaterialTimePicker
extends DialogFragment
implements TimePickerView.OnDoubleTapListener {
    public static final int INPUT_MODE_CLOCK = 0;
    static final String INPUT_MODE_EXTRA = "TIME_PICKER_INPUT_MODE";
    public static final int INPUT_MODE_KEYBOARD = 1;
    static final String NEGATIVE_BUTTON_TEXT_EXTRA = "TIME_PICKER_NEGATIVE_BUTTON_TEXT";
    static final String NEGATIVE_BUTTON_TEXT_RES_EXTRA = "TIME_PICKER_NEGATIVE_BUTTON_TEXT_RES";
    static final String OVERRIDE_THEME_RES_ID = "TIME_PICKER_OVERRIDE_THEME_RES_ID";
    static final String POSITIVE_BUTTON_TEXT_EXTRA = "TIME_PICKER_POSITIVE_BUTTON_TEXT";
    static final String POSITIVE_BUTTON_TEXT_RES_EXTRA = "TIME_PICKER_POSITIVE_BUTTON_TEXT_RES";
    static final String TIME_MODEL_EXTRA = "TIME_PICKER_TIME_MODEL";
    static final String TITLE_RES_EXTRA = "TIME_PICKER_TITLE_RES";
    static final String TITLE_TEXT_EXTRA = "TIME_PICKER_TITLE_TEXT";
    private TimePickerPresenter activePresenter;
    private Button cancelButton;
    private final Set<DialogInterface.OnCancelListener> cancelListeners;
    private int clockIcon;
    private final Set<DialogInterface.OnDismissListener> dismissListeners;
    private int inputMode = 0;
    private int keyboardIcon;
    private MaterialButton modeButton;
    private final Set<View.OnClickListener> negativeButtonListeners;
    private CharSequence negativeButtonText;
    private int negativeButtonTextResId = 0;
    private int overrideThemeResId = 0;
    private final Set<View.OnClickListener> positiveButtonListeners = new LinkedHashSet<View.OnClickListener>();
    private CharSequence positiveButtonText;
    private int positiveButtonTextResId = 0;
    private ViewStub textInputStub;
    private TimeModel time;
    private TimePickerClockPresenter timePickerClockPresenter;
    private TimePickerTextInputPresenter timePickerTextInputPresenter;
    private TimePickerView timePickerView;
    private int titleResId = 0;
    private CharSequence titleText;

    public MaterialTimePicker() {
        this.negativeButtonListeners = new LinkedHashSet<View.OnClickListener>();
        this.cancelListeners = new LinkedHashSet<DialogInterface.OnCancelListener>();
        this.dismissListeners = new LinkedHashSet<DialogInterface.OnDismissListener>();
    }

    static /* synthetic */ int access$1102(MaterialTimePicker materialTimePicker, int n) {
        materialTimePicker.inputMode = n;
        return n;
    }

    private Pair<Integer, Integer> dataForMode(int n) {
        if (n != 0) {
            if (n == 1) {
                return new Pair((Object)this.clockIcon, (Object)R.string.material_timepicker_clock_mode_description);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("no icon for mode: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        return new Pair((Object)this.keyboardIcon, (Object)R.string.material_timepicker_text_input_mode_description);
    }

    private int getThemeResId() {
        int n = this.overrideThemeResId;
        if (n != 0) {
            return n;
        }
        TypedValue typedValue = MaterialAttributes.resolve(this.requireContext(), R.attr.materialTimePickerTheme);
        n = typedValue == null ? 0 : typedValue.data;
        return n;
    }

    private TimePickerPresenter initializeOrRetrieveActivePresenterForMode(int n, TimePickerView timePickerView, ViewStub object) {
        if (n == 0) {
            TimePickerClockPresenter timePickerClockPresenter = this.timePickerClockPresenter;
            object = timePickerClockPresenter;
            if (timePickerClockPresenter == null) {
                object = new TimePickerClockPresenter(timePickerView, this.time);
            }
            this.timePickerClockPresenter = object;
            return object;
        }
        if (this.timePickerTextInputPresenter == null) {
            this.timePickerTextInputPresenter = new TimePickerTextInputPresenter((LinearLayout)object.inflate(), this.time);
        }
        this.timePickerTextInputPresenter.clearCheck();
        return this.timePickerTextInputPresenter;
    }

    private static MaterialTimePicker newInstance(Builder builder) {
        MaterialTimePicker materialTimePicker = new MaterialTimePicker();
        Bundle bundle = new Bundle();
        bundle.putParcelable(TIME_MODEL_EXTRA, (Parcelable)builder.time);
        bundle.putInt(INPUT_MODE_EXTRA, builder.inputMode);
        bundle.putInt(TITLE_RES_EXTRA, builder.titleTextResId);
        if (builder.titleText != null) {
            bundle.putCharSequence(TITLE_TEXT_EXTRA, builder.titleText);
        }
        bundle.putInt(POSITIVE_BUTTON_TEXT_RES_EXTRA, builder.positiveButtonTextResId);
        if (builder.positiveButtonText != null) {
            bundle.putCharSequence(POSITIVE_BUTTON_TEXT_EXTRA, builder.positiveButtonText);
        }
        bundle.putInt(NEGATIVE_BUTTON_TEXT_RES_EXTRA, builder.negativeButtonTextResId);
        if (builder.negativeButtonText != null) {
            bundle.putCharSequence(NEGATIVE_BUTTON_TEXT_EXTRA, builder.negativeButtonText);
        }
        bundle.putInt(OVERRIDE_THEME_RES_ID, builder.overrideThemeResId);
        materialTimePicker.setArguments(bundle);
        return materialTimePicker;
    }

    private void restoreState(Bundle bundle) {
        TimeModel timeModel;
        if (bundle == null) {
            return;
        }
        this.time = timeModel = (TimeModel)bundle.getParcelable(TIME_MODEL_EXTRA);
        if (timeModel == null) {
            this.time = new TimeModel();
        }
        this.inputMode = bundle.getInt(INPUT_MODE_EXTRA, 0);
        this.titleResId = bundle.getInt(TITLE_RES_EXTRA, 0);
        this.titleText = bundle.getCharSequence(TITLE_TEXT_EXTRA);
        this.positiveButtonTextResId = bundle.getInt(POSITIVE_BUTTON_TEXT_RES_EXTRA, 0);
        this.positiveButtonText = bundle.getCharSequence(POSITIVE_BUTTON_TEXT_EXTRA);
        this.negativeButtonTextResId = bundle.getInt(NEGATIVE_BUTTON_TEXT_RES_EXTRA, 0);
        this.negativeButtonText = bundle.getCharSequence(NEGATIVE_BUTTON_TEXT_EXTRA);
        this.overrideThemeResId = bundle.getInt(OVERRIDE_THEME_RES_ID, 0);
    }

    private void updateCancelButtonVisibility() {
        Button button = this.cancelButton;
        if (button != null) {
            int n = this.isCancelable() ? 0 : 8;
            button.setVisibility(n);
        }
    }

    private void updateInputMode(MaterialButton materialButton) {
        if (materialButton != null && this.timePickerView != null && this.textInputStub != null) {
            Pair<Integer, Integer> pair = this.activePresenter;
            if (pair != null) {
                pair.hide();
            }
            pair = this.initializeOrRetrieveActivePresenterForMode(this.inputMode, this.timePickerView, this.textInputStub);
            this.activePresenter = pair;
            pair.show();
            this.activePresenter.invalidate();
            pair = this.dataForMode(this.inputMode);
            materialButton.setIconResource((Integer)pair.first);
            materialButton.setContentDescription(this.getResources().getString(((Integer)pair.second).intValue()));
            materialButton.sendAccessibilityEvent(4);
        }
    }

    public boolean addOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        return this.cancelListeners.add(onCancelListener);
    }

    public boolean addOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        return this.dismissListeners.add(onDismissListener);
    }

    public boolean addOnNegativeButtonClickListener(View.OnClickListener onClickListener) {
        return this.negativeButtonListeners.add(onClickListener);
    }

    public boolean addOnPositiveButtonClickListener(View.OnClickListener onClickListener) {
        return this.positiveButtonListeners.add(onClickListener);
    }

    public void clearOnCancelListeners() {
        this.cancelListeners.clear();
    }

    public void clearOnDismissListeners() {
        this.dismissListeners.clear();
    }

    public void clearOnNegativeButtonClickListeners() {
        this.negativeButtonListeners.clear();
    }

    public void clearOnPositiveButtonClickListeners() {
        this.positiveButtonListeners.clear();
    }

    public int getHour() {
        return this.time.hour % 24;
    }

    public int getInputMode() {
        return this.inputMode;
    }

    public int getMinute() {
        return this.time.minute;
    }

    TimePickerClockPresenter getTimePickerClockPresenter() {
        return this.timePickerClockPresenter;
    }

    public final void onCancel(DialogInterface dialogInterface) {
        Iterator<DialogInterface.OnCancelListener> iterator2 = this.cancelListeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onCancel(dialogInterface);
        }
        super.onCancel(dialogInterface);
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Bundle bundle2 = bundle;
        if (bundle == null) {
            bundle2 = this.getArguments();
        }
        this.restoreState(bundle2);
    }

    public final Dialog onCreateDialog(Bundle bundle) {
        bundle = new Dialog(this.requireContext(), this.getThemeResId());
        Context context = bundle.getContext();
        int n = MaterialAttributes.resolveOrThrow(context, R.attr.colorSurface, MaterialTimePicker.class.getCanonicalName());
        MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable(context, null, R.attr.materialTimePickerStyle, R.style.Widget_MaterialComponents_TimePicker);
        TypedArray typedArray = context.obtainStyledAttributes(null, R.styleable.MaterialTimePicker, R.attr.materialTimePickerStyle, R.style.Widget_MaterialComponents_TimePicker);
        this.clockIcon = typedArray.getResourceId(R.styleable.MaterialTimePicker_clockIcon, 0);
        this.keyboardIcon = typedArray.getResourceId(R.styleable.MaterialTimePicker_keyboardIcon, 0);
        typedArray.recycle();
        materialShapeDrawable.initializeElevationOverlay(context);
        materialShapeDrawable.setFillColor(ColorStateList.valueOf((int)n));
        typedArray = bundle.getWindow();
        typedArray.setBackgroundDrawable((Drawable)materialShapeDrawable);
        typedArray.requestFeature(1);
        typedArray.setLayout(-2, -2);
        materialShapeDrawable.setElevation(ViewCompat.getElevation((View)typedArray.getDecorView()));
        return bundle;
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup object, Bundle bundle) {
        layoutInflater = (ViewGroup)layoutInflater.inflate(R.layout.material_timepicker_dialog, (ViewGroup)object);
        object = (TimePickerView)layoutInflater.findViewById(R.id.material_timepicker_view);
        this.timePickerView = object;
        ((TimePickerView)object).setOnDoubleTapListener(this);
        this.textInputStub = (ViewStub)layoutInflater.findViewById(R.id.material_textinput_timepicker);
        this.modeButton = (MaterialButton)layoutInflater.findViewById(R.id.material_timepicker_mode_button);
        object = (TextView)layoutInflater.findViewById(R.id.header_title);
        int n = this.titleResId;
        if (n != 0) {
            object.setText(n);
        } else if (!TextUtils.isEmpty((CharSequence)this.titleText)) {
            object.setText(this.titleText);
        }
        this.updateInputMode(this.modeButton);
        object = (Button)layoutInflater.findViewById(R.id.material_timepicker_ok_button);
        object.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Iterator iterator2 = MaterialTimePicker.this.positiveButtonListeners.iterator();
                while (iterator2.hasNext()) {
                    ((View.OnClickListener)iterator2.next()).onClick(view);
                }
                MaterialTimePicker.this.dismiss();
            }
        });
        n = this.positiveButtonTextResId;
        if (n != 0) {
            object.setText(n);
        } else if (!TextUtils.isEmpty((CharSequence)this.positiveButtonText)) {
            object.setText(this.positiveButtonText);
        }
        object = (Button)layoutInflater.findViewById(R.id.material_timepicker_cancel_button);
        this.cancelButton = object;
        object.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Iterator iterator2 = MaterialTimePicker.this.negativeButtonListeners.iterator();
                while (iterator2.hasNext()) {
                    ((View.OnClickListener)iterator2.next()).onClick(view);
                }
                MaterialTimePicker.this.dismiss();
            }
        });
        n = this.negativeButtonTextResId;
        if (n != 0) {
            this.cancelButton.setText(n);
        } else if (!TextUtils.isEmpty((CharSequence)this.negativeButtonText)) {
            this.cancelButton.setText(this.negativeButtonText);
        }
        this.updateCancelButtonVisibility();
        this.modeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View object) {
                object = MaterialTimePicker.this;
                int n = ((MaterialTimePicker)object).inputMode == 0 ? 1 : 0;
                MaterialTimePicker.access$1102((MaterialTimePicker)object, n);
                object = MaterialTimePicker.this;
                ((MaterialTimePicker)object).updateInputMode(((MaterialTimePicker)object).modeButton);
            }
        });
        return layoutInflater;
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.activePresenter = null;
        this.timePickerClockPresenter = null;
        this.timePickerTextInputPresenter = null;
        TimePickerView timePickerView = this.timePickerView;
        if (timePickerView != null) {
            timePickerView.setOnDoubleTapListener(null);
            this.timePickerView = null;
        }
    }

    public final void onDismiss(DialogInterface dialogInterface) {
        Iterator<DialogInterface.OnDismissListener> iterator2 = this.dismissListeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onDismiss(dialogInterface);
        }
        super.onDismiss(dialogInterface);
    }

    @Override
    public void onDoubleTap() {
        this.inputMode = 1;
        this.updateInputMode(this.modeButton);
        this.timePickerTextInputPresenter.resetChecked();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putParcelable(TIME_MODEL_EXTRA, (Parcelable)this.time);
        bundle.putInt(INPUT_MODE_EXTRA, this.inputMode);
        bundle.putInt(TITLE_RES_EXTRA, this.titleResId);
        bundle.putCharSequence(TITLE_TEXT_EXTRA, this.titleText);
        bundle.putInt(POSITIVE_BUTTON_TEXT_RES_EXTRA, this.positiveButtonTextResId);
        bundle.putCharSequence(POSITIVE_BUTTON_TEXT_EXTRA, this.positiveButtonText);
        bundle.putInt(NEGATIVE_BUTTON_TEXT_RES_EXTRA, this.negativeButtonTextResId);
        bundle.putCharSequence(NEGATIVE_BUTTON_TEXT_EXTRA, this.negativeButtonText);
        bundle.putInt(OVERRIDE_THEME_RES_ID, this.overrideThemeResId);
    }

    public boolean removeOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        return this.cancelListeners.remove(onCancelListener);
    }

    public boolean removeOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        return this.dismissListeners.remove(onDismissListener);
    }

    public boolean removeOnNegativeButtonClickListener(View.OnClickListener onClickListener) {
        return this.negativeButtonListeners.remove(onClickListener);
    }

    public boolean removeOnPositiveButtonClickListener(View.OnClickListener onClickListener) {
        return this.positiveButtonListeners.remove(onClickListener);
    }

    public void setCancelable(boolean bl) {
        super.setCancelable(bl);
        this.updateCancelButtonVisibility();
    }

    public static final class Builder {
        private int inputMode;
        private CharSequence negativeButtonText;
        private int negativeButtonTextResId = 0;
        private int overrideThemeResId = 0;
        private CharSequence positiveButtonText;
        private int positiveButtonTextResId = 0;
        private TimeModel time = new TimeModel();
        private CharSequence titleText;
        private int titleTextResId = 0;

        public MaterialTimePicker build() {
            return MaterialTimePicker.newInstance(this);
        }

        public Builder setHour(int n) {
            this.time.setHourOfDay(n);
            return this;
        }

        public Builder setInputMode(int n) {
            this.inputMode = n;
            return this;
        }

        public Builder setMinute(int n) {
            this.time.setMinute(n);
            return this;
        }

        public Builder setNegativeButtonText(int n) {
            this.negativeButtonTextResId = n;
            return this;
        }

        public Builder setNegativeButtonText(CharSequence charSequence) {
            this.negativeButtonText = charSequence;
            return this;
        }

        public Builder setPositiveButtonText(int n) {
            this.positiveButtonTextResId = n;
            return this;
        }

        public Builder setPositiveButtonText(CharSequence charSequence) {
            this.positiveButtonText = charSequence;
            return this;
        }

        public Builder setTheme(int n) {
            this.overrideThemeResId = n;
            return this;
        }

        public Builder setTimeFormat(int n) {
            TimeModel timeModel;
            int n2 = this.time.hour;
            int n3 = this.time.minute;
            this.time = timeModel = new TimeModel(n);
            timeModel.setMinute(n3);
            this.time.setHourOfDay(n2);
            return this;
        }

        public Builder setTitleText(int n) {
            this.titleTextResId = n;
            return this;
        }

        public Builder setTitleText(CharSequence charSequence) {
            this.titleText = charSequence;
            return this;
        }
    }
}

