/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.content.Context;
import android.os.Build;
import android.view.accessibility.AccessibilityManager;
import androidx.core.content.ContextCompat;
import com.google.android.material.R;
import com.google.android.material.timepicker.ClickActionDelegate;
import com.google.android.material.timepicker.ClockHandView;
import com.google.android.material.timepicker.TimeModel;
import com.google.android.material.timepicker.TimePickerPresenter;
import com.google.android.material.timepicker.TimePickerView;

class TimePickerClockPresenter
implements ClockHandView.OnRotateListener,
TimePickerView.OnSelectionChange,
TimePickerView.OnPeriodChangeListener,
ClockHandView.OnActionUpListener,
TimePickerPresenter {
    private static final int DEGREES_PER_HOUR = 30;
    private static final int DEGREES_PER_MINUTE = 6;
    private static final String[] HOUR_CLOCK_24_VALUES;
    private static final String[] HOUR_CLOCK_VALUES;
    private static final String[] MINUTE_CLOCK_VALUES;
    private boolean broadcasting = false;
    private float hourRotation;
    private float minuteRotation;
    private TimeModel time;
    private TimePickerView timePickerView;

    static {
        HOUR_CLOCK_VALUES = new String[]{"12", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"};
        HOUR_CLOCK_24_VALUES = new String[]{"00", "2", "4", "6", "8", "10", "12", "14", "16", "18", "20", "22"};
        MINUTE_CLOCK_VALUES = new String[]{"00", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};
    }

    public TimePickerClockPresenter(TimePickerView timePickerView, TimeModel timeModel) {
        this.timePickerView = timePickerView;
        this.time = timeModel;
        this.initialize();
    }

    private int getDegreesPerHour() {
        int n = this.time.format == 1 ? 15 : 30;
        return n;
    }

    private String[] getHourClockValues() {
        String[] stringArray = this.time.format == 1 ? HOUR_CLOCK_24_VALUES : HOUR_CLOCK_VALUES;
        return stringArray;
    }

    private void performHapticFeedback(int n, int n2) {
        if (this.time.minute != n2 || this.time.hour != n) {
            n = Build.VERSION.SDK_INT >= 21 ? 4 : 1;
            this.timePickerView.performHapticFeedback(n);
        }
    }

    private void updateTime() {
        this.timePickerView.updateTime(this.time.period, this.time.getHourForDisplay(), this.time.minute);
    }

    private void updateValues() {
        this.updateValues(HOUR_CLOCK_VALUES, "%d");
        this.updateValues(HOUR_CLOCK_24_VALUES, "%d");
        this.updateValues(MINUTE_CLOCK_VALUES, "%02d");
    }

    private void updateValues(String[] stringArray, String string2) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = TimeModel.formatText(this.timePickerView.getResources(), stringArray[i], string2);
        }
    }

    @Override
    public void hide() {
        this.timePickerView.setVisibility(8);
    }

    @Override
    public void initialize() {
        if (this.time.format == 0) {
            this.timePickerView.showToggle();
        }
        this.timePickerView.addOnRotateListener(this);
        this.timePickerView.setOnSelectionChangeListener(this);
        this.timePickerView.setOnPeriodChangeListener(this);
        this.timePickerView.setOnActionUpListener(this);
        this.updateValues();
        this.invalidate();
    }

    @Override
    public void invalidate() {
        this.hourRotation = this.time.getHourForDisplay() * this.getDegreesPerHour();
        this.minuteRotation = this.time.minute * 6;
        this.setSelection(this.time.selection, false);
        this.updateTime();
    }

    @Override
    public void onActionUp(float f, boolean bl) {
        this.broadcasting = true;
        int n = this.time.minute;
        int n2 = this.time.hour;
        if (this.time.selection == 10) {
            this.timePickerView.setHandRotation(this.hourRotation, false);
            if (!((AccessibilityManager)ContextCompat.getSystemService((Context)this.timePickerView.getContext(), AccessibilityManager.class)).isTouchExplorationEnabled()) {
                this.setSelection(12, true);
            }
        } else {
            int n3 = Math.round(f);
            if (!bl) {
                n3 = (n3 + 15) / 30;
                this.time.setMinute(n3 * 5);
                this.minuteRotation = this.time.minute * 6;
            }
            this.timePickerView.setHandRotation(this.minuteRotation, bl);
        }
        this.broadcasting = false;
        this.updateTime();
        this.performHapticFeedback(n2, n);
    }

    @Override
    public void onPeriodChange(int n) {
        this.time.setPeriod(n);
    }

    @Override
    public void onRotate(float f, boolean bl) {
        if (this.broadcasting) {
            return;
        }
        int n = this.time.hour;
        int n2 = this.time.minute;
        int n3 = Math.round(f);
        if (this.time.selection == 12) {
            this.time.setMinute((n3 + 3) / 6);
            this.minuteRotation = (float)Math.floor(this.time.minute * 6);
        } else {
            int n4 = this.getDegreesPerHour() / 2;
            this.time.setHour((n3 + n4) / this.getDegreesPerHour());
            this.hourRotation = this.time.getHourForDisplay() * this.getDegreesPerHour();
        }
        if (!bl) {
            this.updateTime();
            this.performHapticFeedback(n, n2);
        }
    }

    @Override
    public void onSelectionChanged(int n) {
        this.setSelection(n, true);
    }

    void setSelection(int n, boolean bl) {
        boolean bl2 = n == 12;
        this.timePickerView.setAnimateOnTouchUp(bl2);
        this.time.selection = n;
        TimePickerView timePickerView = this.timePickerView;
        Object object = bl2 ? MINUTE_CLOCK_VALUES : this.getHourClockValues();
        int n2 = bl2 ? R.string.material_minute_suffix : R.string.material_hour_suffix;
        timePickerView.setValues((String[])object, n2);
        object = this.timePickerView;
        float f = bl2 ? this.minuteRotation : this.hourRotation;
        ((TimePickerView)object).setHandRotation(f, bl);
        this.timePickerView.setActiveSelection(n);
        this.timePickerView.setMinuteHourDelegate(new ClickActionDelegate(this.timePickerView.getContext(), R.string.material_hour_selection));
        this.timePickerView.setHourClickDelegate(new ClickActionDelegate(this.timePickerView.getContext(), R.string.material_minute_selection));
    }

    @Override
    public void show() {
        this.timePickerView.setVisibility(0);
    }
}

