/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.text.Editable;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.material.textfield.TextInputLayout;
import com.google.android.material.timepicker.ChipTextInputComboView;
import com.google.android.material.timepicker.TimeModel;

class TimePickerTextInputKeyController
implements TextView.OnEditorActionListener,
View.OnKeyListener {
    private final ChipTextInputComboView hourLayoutComboView;
    private boolean keyListenerRunning = false;
    private final ChipTextInputComboView minuteLayoutComboView;
    private final TimeModel time;

    TimePickerTextInputKeyController(ChipTextInputComboView chipTextInputComboView, ChipTextInputComboView chipTextInputComboView2, TimeModel timeModel) {
        this.hourLayoutComboView = chipTextInputComboView;
        this.minuteLayoutComboView = chipTextInputComboView2;
        this.time = timeModel;
    }

    private void moveSelection(int n) {
        ChipTextInputComboView chipTextInputComboView = this.minuteLayoutComboView;
        boolean bl = true;
        boolean bl2 = n == 12;
        chipTextInputComboView.setChecked(bl2);
        chipTextInputComboView = this.hourLayoutComboView;
        bl2 = n == 10 ? bl : false;
        chipTextInputComboView.setChecked(bl2);
        this.time.selection = n;
    }

    private boolean onHourKeyPress(int n, KeyEvent keyEvent, EditText editText) {
        Editable editable = editText.getText();
        if (editable == null) {
            return false;
        }
        if ((n = n >= 7 && n <= 16 && keyEvent.getAction() == 1 && editText.getSelectionStart() == 2 && editable.length() == 2 ? 1 : 0) != 0) {
            this.moveSelection(12);
            return true;
        }
        return false;
    }

    private boolean onMinuteKeyPress(int n, KeyEvent keyEvent, EditText editText) {
        if ((n = n == 67 && keyEvent.getAction() == 0 && TextUtils.isEmpty((CharSequence)editText.getText()) ? 1 : 0) != 0) {
            this.moveSelection(10);
            return true;
        }
        return false;
    }

    public void bind() {
        TextInputLayout textInputLayout = this.hourLayoutComboView.getTextInput();
        TextInputLayout textInputLayout2 = this.minuteLayoutComboView.getTextInput();
        textInputLayout = textInputLayout.getEditText();
        textInputLayout2 = textInputLayout2.getEditText();
        textInputLayout.setImeOptions(0x10000005);
        textInputLayout2.setImeOptions(0x10000006);
        textInputLayout.setOnEditorActionListener(this);
        textInputLayout.setOnKeyListener(this);
        textInputLayout2.setOnKeyListener(this);
    }

    public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
        boolean bl = n == 5;
        if (bl) {
            this.moveSelection(12);
        }
        return bl;
    }

    public boolean onKey(View view, int n, KeyEvent keyEvent) {
        if (this.keyListenerRunning) {
            return false;
        }
        this.keyListenerRunning = true;
        view = (EditText)view;
        boolean bl = this.time.selection == 12 ? this.onMinuteKeyPress(n, keyEvent, (EditText)view) : this.onHourKeyPress(n, keyEvent, (EditText)view);
        this.keyListenerRunning = false;
        return bl;
    }
}

