/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import com.google.android.material.R;
import com.google.android.material.button.MaterialButtonToggleGroup;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.TextWatcherAdapter;
import com.google.android.material.timepicker.ChipTextInputComboView;
import com.google.android.material.timepicker.ClickActionDelegate;
import com.google.android.material.timepicker.TimeModel;
import com.google.android.material.timepicker.TimePickerPresenter;
import com.google.android.material.timepicker.TimePickerTextInputKeyController;
import com.google.android.material.timepicker.TimePickerView;
import java.lang.reflect.Field;
import java.util.Locale;

class TimePickerTextInputPresenter
implements TimePickerView.OnSelectionChange,
TimePickerPresenter {
    private final TimePickerTextInputKeyController controller;
    private final EditText hourEditText;
    private final ChipTextInputComboView hourTextInput;
    private final TextWatcher hourTextWatcher;
    private final EditText minuteEditText;
    private final ChipTextInputComboView minuteTextInput;
    private final TextWatcher minuteTextWatcher = new TextWatcherAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void afterTextChanged(Editable editable) {
            try {
                if (TextUtils.isEmpty((CharSequence)editable)) {
                    TimePickerTextInputPresenter.this.time.setMinute(0);
                    return;
                }
                int n = Integer.parseInt(editable.toString());
                TimePickerTextInputPresenter.this.time.setMinute(n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
    };
    private final TimeModel time;
    private final LinearLayout timePickerView;
    private MaterialButtonToggleGroup toggle;

    public TimePickerTextInputPresenter(LinearLayout linearLayout, TimeModel timeModel) {
        ChipTextInputComboView chipTextInputComboView;
        ChipTextInputComboView chipTextInputComboView2;
        this.hourTextWatcher = new TextWatcherAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void afterTextChanged(Editable editable) {
                try {
                    if (TextUtils.isEmpty((CharSequence)editable)) {
                        TimePickerTextInputPresenter.this.time.setHour(0);
                        return;
                    }
                    int n = Integer.parseInt(editable.toString());
                    TimePickerTextInputPresenter.this.time.setHour(n);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
            }
        };
        this.timePickerView = linearLayout;
        this.time = timeModel;
        Object object = linearLayout.getResources();
        this.minuteTextInput = chipTextInputComboView2 = (ChipTextInputComboView)linearLayout.findViewById(R.id.material_minute_text_input);
        this.hourTextInput = chipTextInputComboView = (ChipTextInputComboView)linearLayout.findViewById(R.id.material_hour_text_input);
        TextView textView = (TextView)chipTextInputComboView2.findViewById(R.id.material_label);
        TextView textView2 = (TextView)chipTextInputComboView.findViewById(R.id.material_label);
        textView.setText((CharSequence)object.getString(R.string.material_timepicker_minute));
        textView2.setText((CharSequence)object.getString(R.string.material_timepicker_hour));
        chipTextInputComboView2.setTag(R.id.selection_type, 12);
        chipTextInputComboView.setTag(R.id.selection_type, 10);
        if (timeModel.format == 0) {
            this.setupPeriodToggle();
        }
        object = new View.OnClickListener(){

            public void onClick(View view) {
                TimePickerTextInputPresenter.this.onSelectionChanged((Integer)view.getTag(R.id.selection_type));
            }
        };
        chipTextInputComboView.setOnClickListener((View.OnClickListener)object);
        chipTextInputComboView2.setOnClickListener((View.OnClickListener)object);
        chipTextInputComboView.addInputFilter(timeModel.getHourInputValidator());
        chipTextInputComboView2.addInputFilter(timeModel.getMinuteInputValidator());
        textView2 = chipTextInputComboView.getTextInput().getEditText();
        this.hourEditText = textView2;
        object = chipTextInputComboView2.getTextInput().getEditText();
        this.minuteEditText = object;
        if (Build.VERSION.SDK_INT < 21) {
            int n = MaterialColors.getColor((View)linearLayout, R.attr.colorPrimary);
            TimePickerTextInputPresenter.setCursorDrawableColor((EditText)textView2, n);
            TimePickerTextInputPresenter.setCursorDrawableColor((EditText)object, n);
        }
        this.controller = new TimePickerTextInputKeyController(chipTextInputComboView, chipTextInputComboView2, timeModel);
        chipTextInputComboView.setChipDelegate(new ClickActionDelegate(linearLayout.getContext(), R.string.material_hour_selection));
        chipTextInputComboView2.setChipDelegate(new ClickActionDelegate(linearLayout.getContext(), R.string.material_minute_selection));
        this.initialize();
    }

    private void addTextWatchers() {
        this.hourEditText.addTextChangedListener(this.hourTextWatcher);
        this.minuteEditText.addTextChangedListener(this.minuteTextWatcher);
    }

    private void removeTextWatchers() {
        this.hourEditText.removeTextChangedListener(this.hourTextWatcher);
        this.minuteEditText.removeTextChangedListener(this.minuteTextWatcher);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setCursorDrawableColor(EditText object, int n) {
        try {
            Context context = object.getContext();
            Object object2 = TextView.class.getDeclaredField("mCursorDrawableRes");
            ((Field)object2).setAccessible(true);
            int n2 = ((Field)object2).getInt(object);
            object2 = TextView.class.getDeclaredField("mEditor");
            ((Field)object2).setAccessible(true);
            object2 = ((Field)object2).get(object);
            object = object2.getClass().getDeclaredField("mCursorDrawable");
            ((Field)object).setAccessible(true);
            context = AppCompatResources.getDrawable((Context)context, (int)n2);
            context.setColorFilter(n, PorterDuff.Mode.SRC_IN);
            ((Field)object).set(object2, new Drawable[]{context, context});
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private void setTime(TimeModel object) {
        this.removeTextWatchers();
        Locale locale = this.timePickerView.getResources().getConfiguration().locale;
        String string2 = String.format(locale, "%02d", ((TimeModel)object).minute);
        object = String.format(locale, "%02d", ((TimeModel)object).getHourForDisplay());
        this.minuteTextInput.setText(string2);
        this.hourTextInput.setText((CharSequence)object);
        this.addTextWatchers();
        this.updateSelection();
    }

    private void setupPeriodToggle() {
        MaterialButtonToggleGroup materialButtonToggleGroup;
        this.toggle = materialButtonToggleGroup = (MaterialButtonToggleGroup)this.timePickerView.findViewById(R.id.material_clock_period_toggle);
        materialButtonToggleGroup.addOnButtonCheckedListener(new MaterialButtonToggleGroup.OnButtonCheckedListener(){

            @Override
            public void onButtonChecked(MaterialButtonToggleGroup materialButtonToggleGroup, int n, boolean bl) {
                n = n == R.id.material_clock_period_pm_button ? 1 : 0;
                TimePickerTextInputPresenter.this.time.setPeriod(n);
            }
        });
        this.toggle.setVisibility(0);
        this.updateSelection();
    }

    private void updateSelection() {
        MaterialButtonToggleGroup materialButtonToggleGroup = this.toggle;
        if (materialButtonToggleGroup == null) {
            return;
        }
        int n = this.time.period == 0 ? R.id.material_clock_period_am_button : R.id.material_clock_period_pm_button;
        materialButtonToggleGroup.check(n);
    }

    public void clearCheck() {
        this.minuteTextInput.setChecked(false);
        this.hourTextInput.setChecked(false);
    }

    @Override
    public void hide() {
        View view = this.timePickerView.getFocusedChild();
        if (view == null) {
            this.timePickerView.setVisibility(8);
            return;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)ContextCompat.getSystemService((Context)this.timePickerView.getContext(), InputMethodManager.class);
        if (inputMethodManager != null) {
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        this.timePickerView.setVisibility(8);
    }

    @Override
    public void initialize() {
        this.addTextWatchers();
        this.setTime(this.time);
        this.controller.bind();
    }

    @Override
    public void invalidate() {
        this.setTime(this.time);
    }

    @Override
    public void onSelectionChanged(int n) {
        this.time.selection = n;
        ChipTextInputComboView chipTextInputComboView = this.minuteTextInput;
        boolean bl = true;
        boolean bl2 = n == 12;
        chipTextInputComboView.setChecked(bl2);
        chipTextInputComboView = this.hourTextInput;
        bl2 = n == 10 ? bl : false;
        chipTextInputComboView.setChecked(bl2);
        this.updateSelection();
    }

    public void resetChecked() {
        ChipTextInputComboView chipTextInputComboView = this.minuteTextInput;
        int n = this.time.selection;
        boolean bl = true;
        boolean bl2 = n == 12;
        chipTextInputComboView.setChecked(bl2);
        chipTextInputComboView = this.hourTextInput;
        bl2 = this.time.selection == 10 ? bl : false;
        chipTextInputComboView.setChecked(bl2);
    }

    @Override
    public void show() {
        this.timePickerView.setVisibility(0);
    }
}

