/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.material.transition.TransitionUtils;
import com.google.android.material.transition.VisibilityAnimatorProvider;

public final class FadeProvider
implements VisibilityAnimatorProvider {
    private float incomingEndThreshold = 1.0f;

    private static Animator createFadeAnimator(final View view, final float f, final float f2, final float f3, final float f4, final float f5) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float f5 = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                view.setAlpha(TransitionUtils.lerp(f, f2, f3, f4, f5));
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator2) {
                view.setAlpha(f5);
            }
        });
        return valueAnimator;
    }

    @Override
    public Animator createAppear(ViewGroup viewGroup, View view) {
        float f = view.getAlpha() == 0.0f ? 1.0f : view.getAlpha();
        return FadeProvider.createFadeAnimator(view, 0.0f, f, 0.0f, this.incomingEndThreshold, f);
    }

    @Override
    public Animator createDisappear(ViewGroup viewGroup, View view) {
        float f = view.getAlpha() == 0.0f ? 1.0f : view.getAlpha();
        return FadeProvider.createFadeAnimator(view, f, 0.0f, 0.0f, 1.0f, f);
    }

    public float getIncomingEndThreshold() {
        return this.incomingEndThreshold;
    }

    public void setIncomingEndThreshold(float f) {
        this.incomingEndThreshold = f;
    }
}

