/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.material.transition.TransitionUtils;
import com.google.android.material.transition.VisibilityAnimatorProvider;

public final class FadeThroughProvider
implements VisibilityAnimatorProvider {
    static final float FADE_THROUGH_THRESHOLD = 0.35f;
    private float progressThreshold = 0.35f;

    private static Animator createFadeThroughAnimator(final View view, final float f, final float f2, final float f3, final float f4, final float f5) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float f5 = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                view.setAlpha(TransitionUtils.lerp(f, f2, f3, f4, f5));
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator2) {
                view.setAlpha(f5);
            }
        });
        return valueAnimator;
    }

    @Override
    public Animator createAppear(ViewGroup viewGroup, View view) {
        float f = view.getAlpha() == 0.0f ? 1.0f : view.getAlpha();
        return FadeThroughProvider.createFadeThroughAnimator(view, 0.0f, f, this.progressThreshold, 1.0f, f);
    }

    @Override
    public Animator createDisappear(ViewGroup viewGroup, View view) {
        float f = view.getAlpha() == 0.0f ? 1.0f : view.getAlpha();
        return FadeThroughProvider.createFadeThroughAnimator(view, f, 0.0f, 0.0f, this.progressThreshold, f);
    }

    public float getProgressThreshold() {
        return this.progressThreshold;
    }

    public void setProgressThreshold(float f) {
        this.progressThreshold = f;
    }
}

