/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition;

import com.google.android.material.R;
import com.google.android.material.transition.FadeThroughProvider;
import com.google.android.material.transition.MaterialVisibility;
import com.google.android.material.transition.ScaleProvider;
import com.google.android.material.transition.SlideDistanceProvider;
import com.google.android.material.transition.VisibilityAnimatorProvider;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class MaterialSharedAxis
extends MaterialVisibility<VisibilityAnimatorProvider> {
    private static final int DEFAULT_THEMED_DURATION_ATTR = R.attr.motionDurationLong1;
    private static final int DEFAULT_THEMED_EASING_ATTR = R.attr.motionEasingStandard;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    private final int axis;
    private final boolean forward;

    public MaterialSharedAxis(int n, boolean bl) {
        super(MaterialSharedAxis.createPrimaryAnimatorProvider(n, bl), MaterialSharedAxis.createSecondaryAnimatorProvider());
        this.axis = n;
        this.forward = bl;
    }

    private static VisibilityAnimatorProvider createPrimaryAnimatorProvider(int n, boolean bl) {
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    return new ScaleProvider(bl);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Invalid axis: ");
                stringBuilder.append(n);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            n = bl ? 80 : 48;
            return new SlideDistanceProvider(n);
        }
        n = bl ? 0x800005 : 0x800003;
        return new SlideDistanceProvider(n);
    }

    private static VisibilityAnimatorProvider createSecondaryAnimatorProvider() {
        return new FadeThroughProvider();
    }

    public int getAxis() {
        return this.axis;
    }

    @Override
    int getDurationThemeAttrResId(boolean bl) {
        return DEFAULT_THEMED_DURATION_ATTR;
    }

    @Override
    int getEasingThemeAttrResId(boolean bl) {
        return DEFAULT_THEMED_EASING_ATTR;
    }

    public boolean isForward() {
        return this.forward;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Axis {
    }
}

