/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition.platform;

import com.google.android.material.transition.platform.FadeModeEvaluator;
import com.google.android.material.transition.platform.FadeModeResult;
import com.google.android.material.transition.platform.TransitionUtils;

class FadeModeEvaluators {
    private static final FadeModeEvaluator CROSS;
    private static final FadeModeEvaluator IN;
    private static final FadeModeEvaluator OUT;
    private static final FadeModeEvaluator THROUGH;

    static {
        IN = new FadeModeEvaluator(){

            @Override
            public FadeModeResult evaluate(float f, float f2, float f3, float f4) {
                return FadeModeResult.endOnTop(255, TransitionUtils.lerp(0, 255, f2, f3, f));
            }
        };
        OUT = new FadeModeEvaluator(){

            @Override
            public FadeModeResult evaluate(float f, float f2, float f3, float f4) {
                return FadeModeResult.startOnTop(TransitionUtils.lerp(255, 0, f2, f3, f), 255);
            }
        };
        CROSS = new FadeModeEvaluator(){

            @Override
            public FadeModeResult evaluate(float f, float f2, float f3, float f4) {
                return FadeModeResult.startOnTop(TransitionUtils.lerp(255, 0, f2, f3, f), TransitionUtils.lerp(0, 255, f2, f3, f));
            }
        };
        THROUGH = new FadeModeEvaluator(){

            @Override
            public FadeModeResult evaluate(float f, float f2, float f3, float f4) {
                f4 = (f3 - f2) * f4 + f2;
                return FadeModeResult.startOnTop(TransitionUtils.lerp(255, 0, f2, f4, f), TransitionUtils.lerp(0, 255, f4, f3, f));
            }
        };
    }

    private FadeModeEvaluators() {
    }

    static FadeModeEvaluator get(int n, boolean bl) {
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n == 3) {
                        return THROUGH;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Invalid fade mode: ");
                    stringBuilder.append(n);
                    throw new IllegalArgumentException(stringBuilder.toString());
                }
                return CROSS;
            }
            FadeModeEvaluator fadeModeEvaluator = bl ? OUT : IN;
            return fadeModeEvaluator;
        }
        FadeModeEvaluator fadeModeEvaluator = bl ? IN : OUT;
        return fadeModeEvaluator;
    }
}

