/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics.connector;

import android.content.Context;
import android.os.Bundle;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.analytics.connector.internal.zzc;
import com.google.firebase.analytics.connector.internal.zze;
import com.google.firebase.analytics.connector.internal.zzg;
import com.google.firebase.analytics.connector.zza;
import com.google.firebase.analytics.connector.zzb;
import com.google.firebase.events.Event;
import com.google.firebase.events.Subscriber;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AnalyticsConnectorImpl
implements AnalyticsConnector {
    private static volatile AnalyticsConnector zzc;
    final AppMeasurementSdk zza;
    final Map zzb;

    AnalyticsConnectorImpl(AppMeasurementSdk appMeasurementSdk) {
        Preconditions.checkNotNull(appMeasurementSdk);
        this.zza = appMeasurementSdk;
        this.zzb = new ConcurrentHashMap();
    }

    public static AnalyticsConnector getInstance() {
        return AnalyticsConnectorImpl.getInstance(FirebaseApp.getInstance());
    }

    public static AnalyticsConnector getInstance(FirebaseApp firebaseApp) {
        return firebaseApp.get(AnalyticsConnector.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AnalyticsConnector getInstance(FirebaseApp object, Context context, Subscriber subscriber) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(subscriber);
        Preconditions.checkNotNull(context.getApplicationContext());
        if (zzc != null) return zzc;
        synchronized (AnalyticsConnectorImpl.class) {
            if (zzc != null) return zzc;
            Bundle bundle = new Bundle(1);
            if (((FirebaseApp)object).isDefaultApp()) {
                subscriber.subscribe(DataCollectionDefaultChange.class, com.google.firebase.analytics.connector.zza.zza, com.google.firebase.analytics.connector.zzb.zza);
                bundle.putBoolean("dataCollectionDefaultEnabled", ((FirebaseApp)object).isDataCollectionDefaultEnabled());
            }
            zzc = object = new AnalyticsConnectorImpl(zzee.zzg(context, null, null, null, bundle).zzd());
            return zzc;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ void zza(Event event) {
        boolean bl = ((DataCollectionDefaultChange)event.getPayload()).enabled;
        synchronized (AnalyticsConnectorImpl.class) {
            ((AnalyticsConnectorImpl)Preconditions.checkNotNull(AnalyticsConnectorImpl.zzc)).zza.zza(bl);
            return;
        }
    }

    private final boolean zzc(String string2) {
        return !string2.isEmpty() && this.zzb.containsKey(string2) && this.zzb.get(string2) != null;
    }

    @Override
    public void clearConditionalUserProperty(String string2, String string3, Bundle bundle) {
        if (string3 != null && !com.google.firebase.analytics.connector.internal.zzc.zzj(string3, bundle)) {
            return;
        }
        this.zza.clearConditionalUserProperty(string2, string3, bundle);
    }

    @Override
    public List<AnalyticsConnector.ConditionalUserProperty> getConditionalUserProperties(String object, String string2) {
        ArrayList<AnalyticsConnector.ConditionalUserProperty> arrayList = new ArrayList<AnalyticsConnector.ConditionalUserProperty>();
        object = this.zza.getConditionalUserProperties((String)object, string2).iterator();
        while (object.hasNext()) {
            arrayList.add(com.google.firebase.analytics.connector.internal.zzc.zzb((Bundle)object.next()));
        }
        return arrayList;
    }

    @Override
    public int getMaxUserProperties(String string2) {
        return this.zza.getMaxUserProperties(string2);
    }

    @Override
    public Map<String, Object> getUserProperties(boolean bl) {
        return this.zza.getUserProperties(null, null, bl);
    }

    @Override
    public void logEvent(String string2, String string3, Bundle bundle) {
        Bundle bundle2 = bundle;
        if (bundle == null) {
            bundle2 = new Bundle();
        }
        if (!com.google.firebase.analytics.connector.internal.zzc.zzl(string2)) {
            return;
        }
        if (!com.google.firebase.analytics.connector.internal.zzc.zzj(string3, bundle2)) {
            return;
        }
        if (!com.google.firebase.analytics.connector.internal.zzc.zzh(string2, string3, bundle2)) {
            return;
        }
        com.google.firebase.analytics.connector.internal.zzc.zze(string2, string3, bundle2);
        this.zza.logEvent(string2, string3, bundle2);
    }

    @Override
    public AnalyticsConnector.AnalyticsConnectorHandle registerAnalyticsConnectorListener(final String string2, AnalyticsConnector.AnalyticsConnectorListener object) {
        Preconditions.checkNotNull(object);
        if (!com.google.firebase.analytics.connector.internal.zzc.zzl(string2)) {
            return null;
        }
        if (this.zzc(string2)) {
            return null;
        }
        AppMeasurementSdk appMeasurementSdk = this.zza;
        object = "fiam".equals(string2) ? new zze(appMeasurementSdk, (AnalyticsConnector.AnalyticsConnectorListener)object) : (!"crash".equals(string2) && !"clx".equals(string2) ? null : new zzg(appMeasurementSdk, (AnalyticsConnector.AnalyticsConnectorListener)object));
        if (object != null) {
            this.zzb.put(string2, object);
            return new AnalyticsConnector.AnalyticsConnectorHandle(){

                @Override
                public void registerEventNames(Set<String> set) {
                    if (AnalyticsConnectorImpl.this.zzc(string2) && string2.equals("fiam") && set != null && !set.isEmpty()) {
                        ((com.google.firebase.analytics.connector.internal.zza)AnalyticsConnectorImpl.this.zzb.get(string2)).zzb(set);
                    }
                }

                @Override
                public final void unregister() {
                    if (!AnalyticsConnectorImpl.this.zzc(string2)) {
                        return;
                    }
                    AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener = ((com.google.firebase.analytics.connector.internal.zza)AnalyticsConnectorImpl.this.zzb.get(string2)).zza();
                    if (analyticsConnectorListener != null) {
                        analyticsConnectorListener.onMessageTriggered(0, null);
                    }
                    AnalyticsConnectorImpl.this.zzb.remove(string2);
                }

                @Override
                public void unregisterEventNames() {
                    if (AnalyticsConnectorImpl.this.zzc(string2) && string2.equals("fiam")) {
                        ((com.google.firebase.analytics.connector.internal.zza)AnalyticsConnectorImpl.this.zzb.get(string2)).zzc();
                    }
                }
            };
        }
        return null;
    }

    @Override
    public void setConditionalUserProperty(AnalyticsConnector.ConditionalUserProperty conditionalUserProperty) {
        if (!com.google.firebase.analytics.connector.internal.zzc.zzi(conditionalUserProperty)) {
            return;
        }
        this.zza.setConditionalUserProperty(com.google.firebase.analytics.connector.internal.zzc.zza(conditionalUserProperty));
    }

    @Override
    public void setUserProperty(String string2, String string3, Object object) {
        if (!com.google.firebase.analytics.connector.internal.zzc.zzl(string2)) {
            return;
        }
        if (!com.google.firebase.analytics.connector.internal.zzc.zzm(string2, string3)) {
            return;
        }
        this.zza.setUserProperty(string2, string3, object);
    }
}

