/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics;

import android.content.Context;
import android.content.pm.PackageManager;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.crashlytics.AnalyticsDeferredProxy;
import com.google.firebase.crashlytics.CustomKeysAndValues;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponentDeferredProxy;
import com.google.firebase.crashlytics.internal.DevelopmentPlatformProvider;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.AppData;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.CrashlyticsCore;
import com.google.firebase.crashlytics.internal.common.DataCollectionArbiter;
import com.google.firebase.crashlytics.internal.common.ExecutorUtils;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.network.HttpRequestFactory;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import com.google.firebase.crashlytics.internal.settings.SettingsController;
import com.google.firebase.crashlytics.internal.settings.SettingsProvider;
import com.google.firebase.inject.Deferred;
import com.google.firebase.installations.FirebaseInstallationsApi;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class FirebaseCrashlytics {
    static final int APP_EXCEPTION_CALLBACK_TIMEOUT_MS = 500;
    static final String FIREBASE_CRASHLYTICS_ANALYTICS_ORIGIN = "clx";
    static final String LEGACY_CRASH_ANALYTICS_ORIGIN = "crash";
    final CrashlyticsCore core;

    private FirebaseCrashlytics(CrashlyticsCore crashlyticsCore) {
        this.core = crashlyticsCore;
    }

    public static FirebaseCrashlytics getInstance() {
        FirebaseCrashlytics firebaseCrashlytics = FirebaseApp.getInstance().get(FirebaseCrashlytics.class);
        Objects.requireNonNull(firebaseCrashlytics, "FirebaseCrashlytics component is not present.");
        return firebaseCrashlytics;
    }

    static FirebaseCrashlytics init(FirebaseApp object, FirebaseInstallationsApi object2, Deferred<CrashlyticsNativeComponent> object3, Deferred<AnalyticsConnector> object4) {
        Context context = ((FirebaseApp)object).getApplicationContext();
        Object object5 = context.getPackageName();
        Object object6 = Logger.getLogger();
        Object object7 = new StringBuilder();
        ((StringBuilder)object7).append("Initializing Firebase Crashlytics ");
        ((StringBuilder)object7).append(CrashlyticsCore.getVersion());
        ((StringBuilder)object7).append(" for ");
        ((StringBuilder)object7).append((String)object5);
        ((Logger)object6).i(((StringBuilder)object7).toString());
        object7 = new FileStore(context);
        object6 = new DataCollectionArbiter((FirebaseApp)object);
        object2 = new IdManager(context, (String)object5, (FirebaseInstallationsApi)object2, (DataCollectionArbiter)object6);
        object3 = new CrashlyticsNativeComponentDeferredProxy((Deferred<CrashlyticsNativeComponent>)object3);
        object5 = new AnalyticsDeferredProxy((Deferred<AnalyticsConnector>)object4);
        object4 = ExecutorUtils.buildSingleThreadExecutorService("Crashlytics Exception Handler");
        object3 = new CrashlyticsCore((FirebaseApp)object, (IdManager)object2, (CrashlyticsNativeComponent)object3, (DataCollectionArbiter)object6, ((AnalyticsDeferredProxy)object5).getDeferredBreadcrumbSource(), ((AnalyticsDeferredProxy)object5).getAnalyticsEventLogger(), (FileStore)object7, (ExecutorService)object4);
        object = ((FirebaseApp)object).getOptions().getApplicationId();
        object4 = CommonUtils.getMappingFileId(context);
        object5 = Logger.getLogger();
        Object object8 = new StringBuilder();
        ((StringBuilder)object8).append("Mapping file ID is: ");
        ((StringBuilder)object8).append((String)object4);
        ((Logger)object5).d(((StringBuilder)object8).toString());
        object5 = new DevelopmentPlatformProvider(context);
        try {
            object4 = AppData.create(context, (IdManager)object2, (String)object, (String)object4, (DevelopmentPlatformProvider)object5);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Logger.getLogger().e("Error retrieving app package info.", nameNotFoundException);
            return null;
        }
        object8 = Logger.getLogger();
        object5 = new StringBuilder();
        ((StringBuilder)object5).append("Installer package name is: ");
        ((StringBuilder)object5).append(((AppData)object4).installerPackageName);
        ((Logger)object8).v(((StringBuilder)object5).toString());
        object5 = ExecutorUtils.buildSingleThreadExecutorService("com.google.firebase.crashlytics.startup");
        object = SettingsController.create(context, (String)object, (IdManager)object2, new HttpRequestFactory(), ((AppData)object4).versionCode, ((AppData)object4).versionName, (FileStore)object7, (DataCollectionArbiter)object6);
        ((SettingsController)object).loadSettingsData((Executor)object5).continueWith((Executor)object5, new Continuation<Void, Object>(){

            @Override
            public Object then(Task<Void> task) throws Exception {
                if (!task.isSuccessful()) {
                    Logger.getLogger().e("Error fetching settings.", task.getException());
                }
                return null;
            }
        });
        Tasks.call((Executor)object5, new Callable<Void>(((CrashlyticsCore)object3).onPreExecute((AppData)object4, (SettingsProvider)object), (CrashlyticsCore)object3, (SettingsController)object){
            final /* synthetic */ CrashlyticsCore val$core;
            final /* synthetic */ boolean val$finishCoreInBackground;
            final /* synthetic */ SettingsController val$settingsController;
            {
                this.val$finishCoreInBackground = bl;
                this.val$core = crashlyticsCore;
                this.val$settingsController = settingsController;
            }

            @Override
            public Void call() throws Exception {
                if (this.val$finishCoreInBackground) {
                    this.val$core.doBackgroundInitializationAsync(this.val$settingsController);
                }
                return null;
            }
        });
        return new FirebaseCrashlytics((CrashlyticsCore)object3);
    }

    public Task<Boolean> checkForUnsentReports() {
        return this.core.checkForUnsentReports();
    }

    public void deleteUnsentReports() {
        this.core.deleteUnsentReports();
    }

    public boolean didCrashOnPreviousExecution() {
        return this.core.didCrashOnPreviousExecution();
    }

    public void log(String string2) {
        this.core.log(string2);
    }

    public void recordException(Throwable throwable) {
        if (throwable == null) {
            Logger.getLogger().w("A null value was passed to recordException. Ignoring.");
            return;
        }
        this.core.logException(throwable);
    }

    public void sendUnsentReports() {
        this.core.sendUnsentReports();
    }

    public void setCrashlyticsCollectionEnabled(Boolean bl) {
        this.core.setCrashlyticsCollectionEnabled(bl);
    }

    public void setCrashlyticsCollectionEnabled(boolean bl) {
        this.core.setCrashlyticsCollectionEnabled(bl);
    }

    public void setCustomKey(String string2, double d) {
        this.core.setCustomKey(string2, Double.toString(d));
    }

    public void setCustomKey(String string2, float f) {
        this.core.setCustomKey(string2, Float.toString(f));
    }

    public void setCustomKey(String string2, int n) {
        this.core.setCustomKey(string2, Integer.toString(n));
    }

    public void setCustomKey(String string2, long l) {
        this.core.setCustomKey(string2, Long.toString(l));
    }

    public void setCustomKey(String string2, String string3) {
        this.core.setCustomKey(string2, string3);
    }

    public void setCustomKey(String string2, boolean bl) {
        this.core.setCustomKey(string2, Boolean.toString(bl));
    }

    public void setCustomKeys(CustomKeysAndValues customKeysAndValues) {
        this.core.setCustomKeys(customKeysAndValues.keysAndValues);
    }

    public void setUserId(String string2) {
        this.core.setUserId(string2);
    }
}

