/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.analytics;

import android.os.Bundle;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventReceiver;
import com.google.firebase.crashlytics.internal.analytics.CrashlyticsOriginAnalyticsEventLogger;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class BlockingAnalyticsEventLogger
implements AnalyticsEventReceiver,
AnalyticsEventLogger {
    static final String APP_EXCEPTION_EVENT_NAME = "_ae";
    private final CrashlyticsOriginAnalyticsEventLogger baseAnalyticsEventLogger;
    private boolean callbackReceived = false;
    private CountDownLatch eventLatch;
    private final Object latchLock = new Object();
    private final TimeUnit timeUnit;
    private final int timeout;

    public BlockingAnalyticsEventLogger(CrashlyticsOriginAnalyticsEventLogger crashlyticsOriginAnalyticsEventLogger, int n, TimeUnit timeUnit) {
        this.baseAnalyticsEventLogger = crashlyticsOriginAnalyticsEventLogger;
        this.timeout = n;
        this.timeUnit = timeUnit;
    }

    boolean isCallbackReceived() {
        return this.callbackReceived;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void logEvent(String string2, Bundle bundle) {
        Object object = this.latchLock;
        synchronized (object) {
            Logger logger = Logger.getLogger();
            Object object2 = new StringBuilder();
            ((StringBuilder)object2).append("Logging event ");
            ((StringBuilder)object2).append(string2);
            ((StringBuilder)object2).append(" to Firebase Analytics with params ");
            ((StringBuilder)object2).append(bundle);
            logger.v(((StringBuilder)object2).toString());
            this.eventLatch = object2 = new CountDownLatch(1);
            this.callbackReceived = false;
            this.baseAnalyticsEventLogger.logEvent(string2, bundle);
            Logger.getLogger().v("Awaiting app exception callback from Analytics...");
            try {
                if (this.eventLatch.await(this.timeout, this.timeUnit)) {
                    this.callbackReceived = true;
                    Logger.getLogger().v("App exception callback received from Analytics listener.");
                } else {
                    Logger.getLogger().w("Timeout exceeded while awaiting app exception callback from Analytics listener.");
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger().e("Interrupted while awaiting app exception callback from Analytics listener.");
            }
            this.eventLatch = null;
            return;
        }
    }

    @Override
    public void onEvent(String string2, Bundle object) {
        object = this.eventLatch;
        if (object == null) {
            return;
        }
        if (APP_EXCEPTION_EVENT_NAME.equals(string2)) {
            ((CountDownLatch)object).countDown();
        }
    }
}

