/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.google.firebase.crashlytics.internal.Logger;

class BatteryState {
    static final int VELOCITY_CHARGING = 2;
    static final int VELOCITY_FULL = 3;
    static final int VELOCITY_UNPLUGGED = 1;
    private final Float level;
    private final boolean powerConnected;

    private BatteryState(Float f, boolean bl) {
        this.powerConnected = bl;
        this.level = f;
    }

    public static BatteryState get(Context object) {
        boolean bl;
        block6: {
            boolean bl2;
            Object var1_2 = null;
            boolean bl3 = false;
            bl = bl2 = false;
            bl = bl2;
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            bl = bl2;
            intentFilter = object.registerReceiver(null, intentFilter);
            object = var1_2;
            bl = bl3;
            if (intentFilter == null) break block6;
            bl = bl2;
            bl = bl2 = BatteryState.isPowerConnected((Intent)intentFilter);
            try {
                object = BatteryState.getLevel((Intent)intentFilter);
                bl = bl2;
            }
            catch (IllegalStateException illegalStateException) {
                Logger.getLogger().e("An error occurred getting battery state.", illegalStateException);
                object = var1_2;
            }
        }
        return new BatteryState((Float)object, bl);
    }

    private static Float getLevel(Intent intent) {
        int n = intent.getIntExtra("level", -1);
        int n2 = intent.getIntExtra("scale", -1);
        if (n != -1 && n2 != -1) {
            return Float.valueOf((float)n / (float)n2);
        }
        return null;
    }

    private static boolean isPowerConnected(Intent intent) {
        int n = intent.getIntExtra("status", -1);
        boolean bl = false;
        if (n == -1) {
            return false;
        }
        if (n == 2 || n == 5) {
            bl = true;
        }
        return bl;
    }

    public Float getBatteryLevel() {
        return this.level;
    }

    public int getBatteryVelocity() {
        Float f;
        if (this.powerConnected && (f = this.level) != null) {
            if ((double)f.floatValue() < 0.99) {
                return 2;
            }
            return 3;
        }
        return 1;
    }

    boolean isPowerConnected() {
        return this.powerConnected;
    }
}

