/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.os.Process;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.IdManager;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;

class CLSUUID {
    private static String _clsId;
    private static final AtomicLong _sequenceNumber;

    static {
        _sequenceNumber = new AtomicLong(0L);
    }

    CLSUUID(IdManager object) {
        Object object2 = new byte[10];
        this.populateTime((byte[])object2);
        this.populateSequenceNumber((byte[])object2);
        this.populatePID((byte[])object2);
        object = CommonUtils.sha1(((IdManager)object).getCrashlyticsInstallId());
        object2 = CommonUtils.hexify((byte[])object2);
        _clsId = String.format(Locale.US, "%s%s%s%s", ((String)object2).substring(0, 12), ((String)object2).substring(12, 16), ((String)object2).subSequence(16, 20), ((String)object).substring(0, 12)).toUpperCase(Locale.US);
    }

    private static byte[] convertLongToFourByteBuffer(long l) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt((int)l);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.position(0);
        return byteBuffer.array();
    }

    private static byte[] convertLongToTwoByteBuffer(long l) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.putShort((short)l);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.position(0);
        return byteBuffer.array();
    }

    private void populatePID(byte[] byArray) {
        byte[] byArray2 = CLSUUID.convertLongToTwoByteBuffer(Integer.valueOf(Process.myPid()).shortValue());
        byArray[8] = byArray2[0];
        byArray[9] = byArray2[1];
    }

    private void populateSequenceNumber(byte[] byArray) {
        byte[] byArray2 = CLSUUID.convertLongToTwoByteBuffer(_sequenceNumber.incrementAndGet());
        byArray[6] = byArray2[0];
        byArray[7] = byArray2[1];
    }

    private void populateTime(byte[] byArray) {
        long l = new Date().getTime();
        byte[] byArray2 = CLSUUID.convertLongToFourByteBuffer(l / 1000L);
        byArray[0] = byArray2[0];
        byArray[1] = byArray2[1];
        byArray[2] = byArray2[2];
        byArray[3] = byArray2[3];
        byArray2 = CLSUUID.convertLongToTwoByteBuffer(l % 1000L);
        byArray[4] = byArray2[0];
        byArray[5] = byArray2[1];
    }

    public String toString() {
        return _clsId;
    }
}

