/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.hardware.SensorManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Debug;
import android.os.StatFs;
import android.provider.Settings;
import android.text.TextUtils;
import com.google.firebase.crashlytics.internal.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;

public class CommonUtils {
    static final int BYTES_IN_A_GIGABYTE = 0x40000000;
    static final int BYTES_IN_A_KILOBYTE = 1024;
    static final int BYTES_IN_A_MEGABYTE = 0x100000;
    public static final int DEVICE_STATE_BETAOS = 8;
    public static final int DEVICE_STATE_COMPROMISEDLIBRARIES = 32;
    public static final int DEVICE_STATE_DEBUGGERATTACHED = 4;
    public static final int DEVICE_STATE_ISSIMULATOR = 1;
    public static final int DEVICE_STATE_JAILBROKEN = 2;
    public static final int DEVICE_STATE_VENDORINTERNAL = 16;
    private static final String GOLDFISH = "goldfish";
    private static final char[] HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final String LEGACY_MAPPING_FILE_ID_RESOURCE_NAME = "com.crashlytics.android.build_id";
    public static final String LEGACY_SHARED_PREFS_NAME = "com.crashlytics.prefs";
    static final String MAPPING_FILE_ID_RESOURCE_NAME = "com.google.firebase.crashlytics.mapping_file_id";
    private static final String RANCHU = "ranchu";
    private static final String SDK = "sdk";
    private static final String SHA1_INSTANCE = "SHA-1";
    public static final String SHARED_PREFS_NAME = "com.google.firebase.crashlytics";
    private static final long UNCALCULATED_TOTAL_RAM = -1L;
    private static long totalRamInBytes = -1L;

    public static long calculateFreeRamInBytes(Context context) {
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo(memoryInfo);
        return memoryInfo.availMem;
    }

    public static long calculateUsedDiskSpaceInBytes(String string2) {
        string2 = new StatFs(string2);
        long l = string2.getBlockSize();
        return (long)string2.getBlockCount() * l - l * (long)string2.getAvailableBlocks();
    }

    public static boolean canTryConnection(Context context) {
        boolean bl;
        boolean bl2 = CommonUtils.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE");
        boolean bl3 = bl = true;
        if (bl2) {
            bl3 = (context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && context.isConnectedOrConnecting() ? bl : false;
        }
        return bl3;
    }

    public static boolean checkPermission(Context context, String string2) {
        boolean bl = context.checkCallingOrSelfPermission(string2) == 0;
        return bl;
    }

    public static void closeOrLog(Closeable closeable, String string2) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                Logger.getLogger().e(string2, iOException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            return;
        }
    }

    static long convertMemInfoToBytes(String string2, String string3, int n) {
        return Long.parseLong(string2.split(string3)[0].trim()) * (long)n;
    }

    public static String createInstanceIdFrom(String ... object) {
        ArrayList<String> arrayList = null;
        Object object2 = arrayList;
        if (object != null) {
            if (((String[])object).length == 0) {
                object2 = arrayList;
            } else {
                object2 = new ArrayList<String>();
                for (String string2 : object) {
                    if (string2 == null) continue;
                    object2.add(string2.replace("-", "").toLowerCase(Locale.US));
                }
                Collections.sort(object2);
                object = new StringBuilder();
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    ((StringBuilder)object).append((String)object2.next());
                }
                object = ((StringBuilder)object).toString();
                object2 = arrayList;
                if (((String)object).length() > 0) {
                    object2 = CommonUtils.sha1((String)object);
                }
            }
        }
        return object2;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String extractFieldFromSystemFile(File file, String object) {
        void var0_3;
        Object object2;
        block8: {
            void var3_11;
            block10: {
                Object object3;
                Object object4;
                Object var5_16;
                block9: {
                    String[] stringArray;
                    boolean bl = file.exists();
                    Object var3_6 = null;
                    object2 = null;
                    var5_16 = null;
                    if (!bl) return object2;
                    try {
                        object2 = new FileReader(file);
                        object4 = new BufferedReader((Reader)object2, 1024);
                    }
                    catch (Throwable throwable) {
                        object2 = var3_6;
                        break block8;
                    }
                    catch (Exception exception) {
                        object = null;
                        break block9;
                    }
                    while (true) {
                        object2 = object4;
                        object3 = ((BufferedReader)object4).readLine();
                        BufferedReader bufferedReader = object4;
                        object2 = var5_16;
                        if (object3 == null) break block10;
                        object2 = object4;
                        stringArray = Pattern.compile("\\s*:\\s*").split((CharSequence)object3, 2);
                        object2 = object4;
                        if (stringArray.length <= 1) continue;
                        object2 = object4;
                        if (stringArray[0].equals(object)) break;
                        continue;
                        break;
                    }
                    object2 = stringArray[1];
                    Object object5 = object4;
                    break block10;
                    catch (Exception exception) {
                        object = object4;
                        object4 = exception;
                    }
                }
                object2 = object;
                try {
                    object3 = Logger.getLogger();
                    object2 = object;
                    object2 = object;
                    StringBuilder stringBuilder = new StringBuilder();
                    object2 = object;
                    stringBuilder.append("Error parsing ");
                    object2 = object;
                    stringBuilder.append(file);
                    object2 = object;
                    ((Logger)object3).e(stringBuilder.toString(), (Throwable)object4);
                    Object object6 = object;
                    object2 = var5_16;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            CommonUtils.closeOrLog((Closeable)var3_11, "Failed to close system file reader.");
            return object2;
        }
        CommonUtils.closeOrLog((Closeable)object2, "Failed to close system file reader.");
        throw var0_3;
    }

    public static ActivityManager.RunningAppProcessInfo getAppProcessInfo(String object, Context object2) {
        if ((object2 = ((ActivityManager)object2.getSystemService("activity")).getRunningAppProcesses()) != null) {
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                object2 = (ActivityManager.RunningAppProcessInfo)iterator2.next();
                if (!((ActivityManager.RunningAppProcessInfo)object2).processName.equals(object)) continue;
                object = object2;
                break;
            }
        } else {
            object = null;
        }
        return object;
    }

    public static boolean getBooleanResourceValue(Context context, String string2, boolean bl) {
        Resources resources;
        if (context != null && (resources = context.getResources()) != null) {
            int n = CommonUtils.getResourcesIdentifier(context, string2, "bool");
            if (n > 0) {
                return resources.getBoolean(n);
            }
            n = CommonUtils.getResourcesIdentifier(context, string2, "string");
            if (n > 0) {
                return Boolean.parseBoolean(context.getString(n));
            }
        }
        return bl;
    }

    public static int getCpuArchitectureInt() {
        return Architecture.getValue().ordinal();
    }

    public static int getDeviceState(Context context) {
        int n;
        int n2 = n = CommonUtils.isEmulator(context);
        if (CommonUtils.isRooted(context)) {
            n2 = n | 2;
        }
        n = n2;
        if (CommonUtils.isDebuggerAttached()) {
            n = n2 | 4;
        }
        return n;
    }

    public static SharedPreferences getLegacySharedPrefs(Context context) {
        return context.getSharedPreferences(LEGACY_SHARED_PREFS_NAME, 0);
    }

    public static String getMappingFileId(Context object) {
        int n;
        int n2 = n = CommonUtils.getResourcesIdentifier(object, MAPPING_FILE_ID_RESOURCE_NAME, "string");
        if (n == 0) {
            n2 = CommonUtils.getResourcesIdentifier(object, LEGACY_MAPPING_FILE_ID_RESOURCE_NAME, "string");
        }
        object = n2 != 0 ? object.getResources().getString(n2) : null;
        return object;
    }

    public static boolean getProximitySensorEnabled(Context context) {
        boolean bl = CommonUtils.isEmulator(context);
        boolean bl2 = false;
        if (bl) {
            return false;
        }
        if (((SensorManager)context.getSystemService("sensor")).getDefaultSensor(8) != null) {
            bl2 = true;
        }
        return bl2;
    }

    public static String getResourcePackageName(Context context) {
        String string2;
        int n = context.getApplicationContext().getApplicationInfo().icon;
        if (n > 0) {
            String string3;
            string2 = string3 = context.getResources().getResourcePackageName(n);
            try {
                if ("android".equals(string3)) {
                    string2 = context.getPackageName();
                }
            }
            catch (Resources.NotFoundException notFoundException) {
                string2 = context.getPackageName();
            }
        } else {
            string2 = context.getPackageName();
        }
        return string2;
    }

    public static int getResourcesIdentifier(Context context, String string2, String string3) {
        return context.getResources().getIdentifier(string2, string3, CommonUtils.getResourcePackageName(context));
    }

    public static SharedPreferences getSharedPrefs(Context context) {
        return context.getSharedPreferences(SHARED_PREFS_NAME, 0);
    }

    public static String getStringsFileValue(Context context, String string2) {
        int n = CommonUtils.getResourcesIdentifier(context, string2, "string");
        if (n > 0) {
            return context.getString(n);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getTotalRamInBytes() {
        synchronized (CommonUtils.class) {
            long l;
            block9: {
                if (totalRamInBytes != -1L) return totalRamInBytes;
                long l2 = 0L;
                Object object = new File("/proc/meminfo");
                object = CommonUtils.extractFieldFromSystemFile((File)object, "MemTotal");
                l = l2;
                if (!TextUtils.isEmpty((CharSequence)object)) {
                    object = ((String)object).toUpperCase(Locale.US);
                    try {
                        if (((String)object).endsWith("KB")) {
                            l = CommonUtils.convertMemInfoToBytes((String)object, "KB", 1024);
                            break block9;
                        }
                        if (((String)object).endsWith("MB")) {
                            l = CommonUtils.convertMemInfoToBytes((String)object, "MB", 0x100000);
                            break block9;
                        }
                        if (((String)object).endsWith("GB")) {
                            l = CommonUtils.convertMemInfoToBytes((String)object, "GB", 0x40000000);
                        } else {
                            Logger logger = Logger.getLogger();
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Unexpected meminfo format while computing RAM: ");
                            stringBuilder.append((String)object);
                            logger.w(stringBuilder.toString());
                            l = l2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        Logger logger = Logger.getLogger();
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Unexpected meminfo format while computing RAM: ");
                        stringBuilder.append((String)object);
                        logger.e(stringBuilder.toString(), numberFormatException);
                        l = l2;
                    }
                }
            }
            totalRamInBytes = l;
            return totalRamInBytes;
        }
    }

    private static String hash(String string2, String string3) {
        return CommonUtils.hash(string2.getBytes(), string3);
    }

    private static String hash(byte[] byArray, String string2) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(string2);
            messageDigest.update(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger logger = Logger.getLogger();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Could not create hashing algorithm: ");
            stringBuilder.append(string2);
            stringBuilder.append(", returning empty string.");
            logger.e(stringBuilder.toString(), noSuchAlgorithmException);
            return "";
        }
        return CommonUtils.hexify(messageDigest.digest());
    }

    public static String hexify(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            int n2 = i * 2;
            char[] cArray2 = HEX_VALUES;
            cArray[n2] = cArray2[n >>> 4];
            cArray[n2 + 1] = cArray2[n & 0xF];
        }
        return new String(cArray);
    }

    public static boolean isAppDebuggable(Context context) {
        boolean bl = (context.getApplicationInfo().flags & 2) != 0;
        return bl;
    }

    public static boolean isDebuggerAttached() {
        boolean bl = Debug.isDebuggerConnected() || Debug.waitingForDebugger();
        return bl;
    }

    public static boolean isEmulator(Context object) {
        object = Settings.Secure.getString((ContentResolver)object.getContentResolver(), (String)"android_id");
        boolean bl = Build.PRODUCT.contains(SDK) || Build.HARDWARE.contains(GOLDFISH) || Build.HARDWARE.contains(RANCHU) || object == null;
        return bl;
    }

    @Deprecated
    public static boolean isLoggingEnabled(Context context) {
        return false;
    }

    public static boolean isRooted(Context object) {
        boolean bl = CommonUtils.isEmulator((Context)object);
        object = Build.TAGS;
        if (!bl && object != null && ((String)object).contains("test-keys")) {
            return true;
        }
        if (new File("/system/app/Superuser.apk").exists()) {
            return true;
        }
        object = new File("/system/xbin/su");
        return !bl && ((File)object).exists();
    }

    public static boolean nullSafeEquals(String string2, String string3) {
        if (string2 == null) {
            boolean bl = string3 == null;
            return bl;
        }
        return string2.equals(string3);
    }

    public static String padWithZerosToMaxIntWidth(int n) {
        if (n >= 0) {
            return String.format(Locale.US, "%1$10s", n).replace(' ', '0');
        }
        throw new IllegalArgumentException("value must be zero or greater");
    }

    public static String sha1(String string2) {
        return CommonUtils.hash(string2, SHA1_INSTANCE);
    }

    public static String streamToString(InputStream object) {
        object = ((Scanner)(object = new Scanner((InputStream)object).useDelimiter("\\A"))).hasNext() ? ((Scanner)object).next() : "";
        return object;
    }

    static final class Architecture
    extends Enum<Architecture> {
        private static final /* synthetic */ Architecture[] $VALUES;
        public static final /* enum */ Architecture ARM64;
        public static final /* enum */ Architecture ARMV6;
        public static final /* enum */ Architecture ARMV7;
        public static final /* enum */ Architecture ARMV7S;
        public static final /* enum */ Architecture ARM_UNKNOWN;
        public static final /* enum */ Architecture PPC;
        public static final /* enum */ Architecture PPC64;
        public static final /* enum */ Architecture UNKNOWN;
        public static final /* enum */ Architecture X86_32;
        public static final /* enum */ Architecture X86_64;
        private static final Map<String, Architecture> matcher;

        static {
            Architecture architecture;
            Architecture architecture2;
            Architecture architecture3;
            Architecture architecture4;
            Architecture architecture5;
            Architecture architecture6;
            Architecture architecture7;
            Architecture architecture8;
            Architecture architecture9;
            X86_32 = architecture9 = new Architecture();
            X86_64 = architecture8 = new Architecture();
            ARM_UNKNOWN = architecture7 = new Architecture();
            PPC = architecture6 = new Architecture();
            PPC64 = architecture5 = new Architecture();
            ARMV6 = architecture4 = new Architecture();
            ARMV7 = architecture3 = new Architecture();
            UNKNOWN = architecture2 = new Architecture();
            Object object = new Architecture();
            ARMV7S = object;
            ARM64 = architecture = new Architecture();
            $VALUES = new Architecture[]{architecture9, architecture8, architecture7, architecture6, architecture5, architecture4, architecture3, architecture2, object, architecture};
            object = new HashMap(4);
            matcher = object;
            object.put("armeabi-v7a", architecture3);
            object.put("armeabi", architecture4);
            object.put("arm64-v8a", architecture);
            object.put("x86", architecture9);
        }

        static Architecture getValue() {
            Object object = Build.CPU_ABI;
            if (TextUtils.isEmpty((CharSequence)object)) {
                Logger.getLogger().v("Architecture#getValue()::Build.CPU_ABI returned null or empty");
                return UNKNOWN;
            }
            object = object.toLowerCase(Locale.US);
            Architecture architecture = matcher.get(object);
            object = architecture;
            if (architecture == null) {
                object = UNKNOWN;
            }
            return object;
        }

        public static Architecture valueOf(String string2) {
            return Enum.valueOf(Architecture.class, string2);
        }

        public static Architecture[] values() {
            return (Architecture[])$VALUES.clone();
        }
    }
}

