/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.app.ActivityManager;
import android.app.ApplicationExitInfo;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.StatFs;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.NativeSessionFileProvider;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.common.AppData;
import com.google.firebase.crashlytics.internal.common.BytesBackedNativeSessionFile;
import com.google.firebase.crashlytics.internal.common.CLSUUID;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.CrashlyticsBackgroundWorker;
import com.google.firebase.crashlytics.internal.common.CrashlyticsController$$ExternalSyntheticLambda0;
import com.google.firebase.crashlytics.internal.common.CrashlyticsCore;
import com.google.firebase.crashlytics.internal.common.CrashlyticsFileMarker;
import com.google.firebase.crashlytics.internal.common.CrashlyticsUncaughtExceptionHandler;
import com.google.firebase.crashlytics.internal.common.DataCollectionArbiter;
import com.google.firebase.crashlytics.internal.common.DeliveryMechanism;
import com.google.firebase.crashlytics.internal.common.FileBackedNativeSessionFile;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.common.NativeSessionFile;
import com.google.firebase.crashlytics.internal.common.NativeSessionFileGzipper;
import com.google.firebase.crashlytics.internal.common.SessionReportingCoordinator;
import com.google.firebase.crashlytics.internal.common.Utils;
import com.google.firebase.crashlytics.internal.metadata.LogFileManager;
import com.google.firebase.crashlytics.internal.metadata.UserMetadata;
import com.google.firebase.crashlytics.internal.model.StaticSessionData;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import com.google.firebase.crashlytics.internal.settings.Settings;
import com.google.firebase.crashlytics.internal.settings.SettingsProvider;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

class CrashlyticsController {
    static final FilenameFilter APP_EXCEPTION_MARKER_FILTER = CrashlyticsController$$ExternalSyntheticLambda0.INSTANCE;
    static final String APP_EXCEPTION_MARKER_PREFIX = ".ae";
    static final String FIREBASE_APPLICATION_EXCEPTION = "_ae";
    static final String FIREBASE_CRASH_TYPE = "fatal";
    static final int FIREBASE_CRASH_TYPE_FATAL = 1;
    static final String FIREBASE_TIMESTAMP = "timestamp";
    private static final String GENERATOR_FORMAT = "Crashlytics Android SDK/%s";
    static final String NATIVE_SESSION_DIR = "native-sessions";
    private final AnalyticsEventLogger analyticsEventLogger;
    private final AppData appData;
    private final CrashlyticsBackgroundWorker backgroundWorker;
    final AtomicBoolean checkForUnsentReportsCalled;
    private final Context context;
    private CrashlyticsUncaughtExceptionHandler crashHandler;
    private final CrashlyticsFileMarker crashMarker;
    private final DataCollectionArbiter dataCollectionArbiter;
    private final FileStore fileStore;
    private final IdManager idManager;
    private final LogFileManager logFileManager;
    private final CrashlyticsNativeComponent nativeComponent;
    final TaskCompletionSource<Boolean> reportActionProvided;
    private final SessionReportingCoordinator reportingCoordinator;
    private SettingsProvider settingsProvider = null;
    final TaskCompletionSource<Boolean> unsentReportsAvailable = new TaskCompletionSource();
    final TaskCompletionSource<Void> unsentReportsHandled;
    private final UserMetadata userMetadata;

    CrashlyticsController(Context context, CrashlyticsBackgroundWorker crashlyticsBackgroundWorker, IdManager idManager, DataCollectionArbiter dataCollectionArbiter, FileStore fileStore, CrashlyticsFileMarker crashlyticsFileMarker, AppData appData, UserMetadata userMetadata, LogFileManager logFileManager, SessionReportingCoordinator sessionReportingCoordinator, CrashlyticsNativeComponent crashlyticsNativeComponent, AnalyticsEventLogger analyticsEventLogger) {
        this.reportActionProvided = new TaskCompletionSource();
        this.unsentReportsHandled = new TaskCompletionSource();
        this.checkForUnsentReportsCalled = new AtomicBoolean(false);
        this.context = context;
        this.backgroundWorker = crashlyticsBackgroundWorker;
        this.idManager = idManager;
        this.dataCollectionArbiter = dataCollectionArbiter;
        this.fileStore = fileStore;
        this.crashMarker = crashlyticsFileMarker;
        this.appData = appData;
        this.userMetadata = userMetadata;
        this.logFileManager = logFileManager;
        this.nativeComponent = crashlyticsNativeComponent;
        this.analyticsEventLogger = analyticsEventLogger;
        this.reportingCoordinator = sessionReportingCoordinator;
    }

    private static StaticSessionData.AppData createAppData(IdManager idManager, AppData appData) {
        return StaticSessionData.AppData.create(idManager.getAppIdentifier(), appData.versionCode, appData.versionName, idManager.getCrashlyticsInstallId(), DeliveryMechanism.determineFrom(appData.installerPackageName).getId(), appData.developmentPlatformProvider);
    }

    private static StaticSessionData.DeviceData createDeviceData(Context context) {
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        long l = statFs.getBlockCount();
        long l2 = statFs.getBlockSize();
        return StaticSessionData.DeviceData.create(CommonUtils.getCpuArchitectureInt(), Build.MODEL, Runtime.getRuntime().availableProcessors(), CommonUtils.getTotalRamInBytes(), l * l2, CommonUtils.isEmulator(context), CommonUtils.getDeviceState(context), Build.MANUFACTURER, Build.PRODUCT);
    }

    private static StaticSessionData.OsData createOsData(Context context) {
        return StaticSessionData.OsData.create(Build.VERSION.RELEASE, Build.VERSION.CODENAME, CommonUtils.isRooted(context));
    }

    private static void deleteFiles(List<File> object) {
        object = object.iterator();
        while (object.hasNext()) {
            ((File)object.next()).delete();
        }
    }

    private void doCloseSessions(boolean n, SettingsProvider object) {
        ArrayList<String> arrayList = new ArrayList<String>(this.reportingCoordinator.listSortedOpenSessionIds());
        if (arrayList.size() <= n) {
            Logger.getLogger().v("No open sessions to be closed.");
            return;
        }
        String string2 = (String)arrayList.get(n);
        if (object.getSettingsSync().featureFlagData.collectAnrs) {
            this.writeApplicationExitInfoEventIfRelevant(string2);
        } else {
            Logger.getLogger().v("ANR feature disabled.");
        }
        if (this.nativeComponent.hasCrashDataForSession(string2)) {
            this.finalizePreviousNativeSession(string2);
        }
        object = null;
        if (n != 0) {
            object = (String)arrayList.get(0);
        }
        this.reportingCoordinator.finalizeSessions(CrashlyticsController.getCurrentTimestampSeconds(), (String)object);
    }

    private void doOpenSession(String string2) {
        long l = CrashlyticsController.getCurrentTimestampSeconds();
        Object object = Logger.getLogger();
        Object object2 = new StringBuilder();
        ((StringBuilder)object2).append("Opening a new session with ID ");
        ((StringBuilder)object2).append(string2);
        ((Logger)object).d(((StringBuilder)object2).toString());
        String string3 = String.format(Locale.US, GENERATOR_FORMAT, CrashlyticsCore.getVersion());
        StaticSessionData.AppData appData = CrashlyticsController.createAppData(this.idManager, this.appData);
        object = CrashlyticsController.createOsData(this.getContext());
        object2 = CrashlyticsController.createDeviceData(this.getContext());
        this.nativeComponent.prepareNativeSession(string2, string3, l, StaticSessionData.create(appData, (StaticSessionData.OsData)object, (StaticSessionData.DeviceData)object2));
        this.logFileManager.setCurrentSession(string2);
        this.reportingCoordinator.onBeginSession(string2, l);
    }

    private void doWriteAppExceptionMarker(long l) {
        try {
            FileStore fileStore = this.fileStore;
            Serializable serializable = new StringBuilder();
            serializable.append(APP_EXCEPTION_MARKER_PREFIX);
            serializable.append(l);
            if (!fileStore.getCommonFile(serializable.toString()).createNewFile()) {
                serializable = new IOException("Create new file failed.");
                throw serializable;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger().w("Could not create app exception marker file.", iOException);
        }
    }

    private void finalizePreviousNativeSession(String string2) {
        Object object = Logger.getLogger();
        List<NativeSessionFile> list = new StringBuilder();
        ((StringBuilder)((Object)list)).append("Finalizing native report for session ");
        ((StringBuilder)((Object)list)).append(string2);
        ((Logger)object).v(((StringBuilder)((Object)list)).toString());
        list = this.nativeComponent.getSessionFileProvider(string2);
        object = list.getMinidumpFile();
        if (object != null && ((File)object).exists()) {
            long l = ((File)object).lastModified();
            LogFileManager logFileManager = new LogFileManager(this.fileStore, string2);
            object = this.fileStore.getNativeSessionDir(string2);
            if (!((File)object).isDirectory()) {
                Logger.getLogger().w("Couldn't create directory to store native session files, aborting.");
                return;
            }
            this.doWriteAppExceptionMarker(l);
            list = CrashlyticsController.getNativeSessionFiles((NativeSessionFileProvider)((Object)list), string2, this.fileStore, logFileManager.getBytesForLog());
            NativeSessionFileGzipper.processNativeSessions((File)object, list);
            Logger.getLogger().d("CrashlyticsController#finalizePreviousNativeSession");
            this.reportingCoordinator.finalizeSessionWithNativeEvent(string2, list);
            logFileManager.clearLog();
            return;
        }
        list = Logger.getLogger();
        object = new StringBuilder();
        ((StringBuilder)object).append("No minidump data found for session ");
        ((StringBuilder)object).append(string2);
        ((Logger)((Object)list)).w(((StringBuilder)object).toString());
    }

    private static boolean firebaseCrashExists() {
        try {
            Class.forName("com.google.firebase.crash.FirebaseCrash");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private Context getContext() {
        return this.context;
    }

    private String getCurrentSessionId() {
        SortedSet<String> sortedSet = this.reportingCoordinator.listSortedOpenSessionIds();
        sortedSet = !sortedSet.isEmpty() ? sortedSet.first() : null;
        return sortedSet;
    }

    private static long getCurrentTimestampSeconds() {
        return CrashlyticsController.getTimestampSeconds(System.currentTimeMillis());
    }

    static List<NativeSessionFile> getNativeSessionFiles(NativeSessionFileProvider nativeSessionFileProvider, String object, FileStore object2, byte[] byArray) {
        File file = ((FileStore)object2).getSessionFile((String)object, "user-data");
        object2 = ((FileStore)object2).getSessionFile((String)object, "keys");
        object = new ArrayList();
        object.add(new BytesBackedNativeSessionFile("logs_file", "logs", byArray));
        object.add(new FileBackedNativeSessionFile("crash_meta_file", "metadata", nativeSessionFileProvider.getMetadataFile()));
        object.add(new FileBackedNativeSessionFile("session_meta_file", "session", nativeSessionFileProvider.getSessionFile()));
        object.add(new FileBackedNativeSessionFile("app_meta_file", "app", nativeSessionFileProvider.getAppFile()));
        object.add(new FileBackedNativeSessionFile("device_meta_file", "device", nativeSessionFileProvider.getDeviceFile()));
        object.add(new FileBackedNativeSessionFile("os_meta_file", "os", nativeSessionFileProvider.getOsFile()));
        object.add(new FileBackedNativeSessionFile("minidump_file", "minidump", nativeSessionFileProvider.getMinidumpFile()));
        object.add(new FileBackedNativeSessionFile("user_meta_file", "user", file));
        object.add(new FileBackedNativeSessionFile("keys_file", "keys", (File)object2));
        return object;
    }

    private static long getTimestampSeconds(long l) {
        return l / 1000L;
    }

    static /* synthetic */ boolean lambda$static$0(File file, String string2) {
        return string2.startsWith(APP_EXCEPTION_MARKER_PREFIX);
    }

    private Task<Void> logAnalyticsAppExceptionEvent(final long l) {
        if (CrashlyticsController.firebaseCrashExists()) {
            Logger.getLogger().w("Skipping logging Crashlytics event to Firebase, FirebaseCrash exists");
            return Tasks.forResult(null);
        }
        Logger.getLogger().d("Logging app exception event to Firebase Analytics");
        return Tasks.call(new ScheduledThreadPoolExecutor(1), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Bundle bundle = new Bundle();
                bundle.putInt(CrashlyticsController.FIREBASE_CRASH_TYPE, 1);
                bundle.putLong(CrashlyticsController.FIREBASE_TIMESTAMP, l);
                CrashlyticsController.this.analyticsEventLogger.logEvent(CrashlyticsController.FIREBASE_APPLICATION_EXCEPTION, bundle);
                return null;
            }
        });
    }

    private Task<Void> logAnalyticsAppExceptionEvents() {
        ArrayList<Task<Void>> arrayList = new ArrayList<Task<Void>>();
        for (File file : this.listAppExceptionMarkerFiles()) {
            try {
                arrayList.add(this.logAnalyticsAppExceptionEvent(Long.parseLong(file.getName().substring(3))));
            }
            catch (NumberFormatException numberFormatException) {
                Logger logger = Logger.getLogger();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Could not parse app exception timestamp from file ");
                stringBuilder.append(file.getName());
                logger.w(stringBuilder.toString());
            }
            file.delete();
        }
        return Tasks.whenAll(arrayList);
    }

    private Task<Boolean> waitForReportAction() {
        boolean bl = this.dataCollectionArbiter.isAutomaticDataCollectionEnabled();
        Object object = true;
        if (bl) {
            Logger.getLogger().d("Automatic data collection is enabled. Allowing upload.");
            this.unsentReportsAvailable.trySetResult(false);
            return Tasks.forResult(object);
        }
        Logger.getLogger().d("Automatic data collection is disabled.");
        Logger.getLogger().v("Notifying that unsent reports are available.");
        this.unsentReportsAvailable.trySetResult((Boolean)object);
        object = this.dataCollectionArbiter.waitForAutomaticDataCollectionEnabled().onSuccessTask(new SuccessContinuation<Void, Boolean>(){

            @Override
            public Task<Boolean> then(Void void_) throws Exception {
                return Tasks.forResult(true);
            }
        });
        Logger.getLogger().d("Waiting for send/deleteUnsentReports to be called.");
        return Utils.race(object, this.reportActionProvided.getTask());
    }

    private void writeApplicationExitInfoEventIfRelevant(String charSequence) {
        if (Build.VERSION.SDK_INT >= 30) {
            Object object = ((ActivityManager)this.context.getSystemService("activity")).getHistoricalProcessExitReasons(null, 0, 0);
            if (object.size() != 0) {
                LogFileManager logFileManager = new LogFileManager(this.fileStore, (String)charSequence);
                UserMetadata userMetadata = UserMetadata.loadFromExistingSession((String)charSequence, this.fileStore, this.backgroundWorker);
                this.reportingCoordinator.persistRelevantAppExitInfoEvent((String)charSequence, (List<ApplicationExitInfo>)object, logFileManager, userMetadata);
            } else {
                object = Logger.getLogger();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("No ApplicationExitInfo available. Session: ");
                stringBuilder.append((String)charSequence);
                ((Logger)object).v(stringBuilder.toString());
            }
        } else {
            Logger logger = Logger.getLogger();
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("ANR feature enabled, but device is API ");
            ((StringBuilder)charSequence).append(Build.VERSION.SDK_INT);
            logger.v(((StringBuilder)charSequence).toString());
        }
    }

    Task<Boolean> checkForUnsentReports() {
        if (!this.checkForUnsentReportsCalled.compareAndSet(false, true)) {
            Logger.getLogger().w("checkForUnsentReports should only be called once per execution.");
            return Tasks.forResult(false);
        }
        return this.unsentReportsAvailable.getTask();
    }

    Task<Void> deleteUnsentReports() {
        this.reportActionProvided.trySetResult(false);
        return this.unsentReportsHandled.getTask();
    }

    boolean didCrashOnPreviousExecution() {
        boolean bl = this.crashMarker.isPresent();
        boolean bl2 = true;
        if (!bl) {
            String string2 = this.getCurrentSessionId();
            if (string2 == null || !this.nativeComponent.hasCrashDataForSession(string2)) {
                bl2 = false;
            }
            return bl2;
        }
        Logger.getLogger().v("Found previous crash marker.");
        this.crashMarker.remove();
        Boolean bl3 = Boolean.TRUE;
        return true;
    }

    void doCloseSessions(SettingsProvider settingsProvider) {
        this.doCloseSessions(false, settingsProvider);
    }

    void enableExceptionHandling(String object, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, SettingsProvider settingsProvider) {
        this.settingsProvider = settingsProvider;
        this.openSession((String)object);
        this.crashHandler = object = new CrashlyticsUncaughtExceptionHandler(new CrashlyticsUncaughtExceptionHandler.CrashListener(){

            @Override
            public void onUncaughtException(SettingsProvider settingsProvider, Thread thread2, Throwable throwable) {
                CrashlyticsController.this.handleUncaughtException(settingsProvider, thread2, throwable);
            }
        }, settingsProvider, uncaughtExceptionHandler, this.nativeComponent);
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)object);
    }

    boolean finalizeSessions(SettingsProvider object) {
        this.backgroundWorker.checkRunningOnThread();
        if (this.isHandlingException()) {
            Logger.getLogger().w("Skipping session finalization because a crash has already occurred.");
            object = Boolean.FALSE;
            return false;
        }
        Logger.getLogger().v("Finalizing previously open sessions.");
        try {
            this.doCloseSessions(true, (SettingsProvider)object);
            Logger.getLogger().v("Closed all previously open sessions.");
            return true;
        }
        catch (Exception exception) {
            Logger.getLogger().e("Unable to finalize previously open sessions.", exception);
            return false;
        }
    }

    UserMetadata getUserMetadata() {
        return this.userMetadata;
    }

    void handleUncaughtException(SettingsProvider settingsProvider, Thread thread2, Throwable throwable) {
        this.handleUncaughtException(settingsProvider, thread2, throwable, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleUncaughtException(SettingsProvider task, Thread thread2, Throwable throwable, boolean bl) {
        synchronized (this) {
            void var4_6;
            void var2_4;
            void var3_5;
            Callable<Task<Void>> callable = Logger.getLogger();
            Object object = new StringBuilder();
            ((StringBuilder)object).append("Handling uncaught exception \"");
            ((StringBuilder)object).append(var3_5);
            ((StringBuilder)object).append("\" from thread ");
            ((StringBuilder)object).append(var2_4.getName());
            ((Logger)((Object)callable)).d(((StringBuilder)object).toString());
            final long l = System.currentTimeMillis();
            object = this.backgroundWorker;
            callable = new Callable<Task<Void>>((Throwable)var3_5, (Thread)var2_4, task, (boolean)var4_6){
                final /* synthetic */ Throwable val$ex;
                final /* synthetic */ boolean val$isOnDemand;
                final /* synthetic */ SettingsProvider val$settingsProvider;
                final /* synthetic */ Thread val$thread;
                {
                    this.val$ex = throwable;
                    this.val$thread = thread2;
                    this.val$settingsProvider = settingsProvider;
                    this.val$isOnDemand = bl;
                }

                @Override
                public Task<Void> call() throws Exception {
                    long l2 = CrashlyticsController.getTimestampSeconds(l);
                    final String string2 = CrashlyticsController.this.getCurrentSessionId();
                    if (string2 == null) {
                        Logger.getLogger().e("Tried to write a fatal exception while no session was open.");
                        return Tasks.forResult(null);
                    }
                    CrashlyticsController.this.crashMarker.create();
                    CrashlyticsController.this.reportingCoordinator.persistFatalEvent(this.val$ex, this.val$thread, string2, l2);
                    CrashlyticsController.this.doWriteAppExceptionMarker(l);
                    CrashlyticsController.this.doCloseSessions(this.val$settingsProvider);
                    CrashlyticsController.this.doOpenSession(new CLSUUID(CrashlyticsController.this.idManager).toString());
                    if (!CrashlyticsController.this.dataCollectionArbiter.isAutomaticDataCollectionEnabled()) {
                        return Tasks.forResult(null);
                    }
                    final Executor executor = CrashlyticsController.this.backgroundWorker.getExecutor();
                    return this.val$settingsProvider.getSettingsAsync().onSuccessTask(executor, new SuccessContinuation<Settings, Void>(){

                        @Override
                        public Task<Void> then(Settings object) throws Exception {
                            Object var2_2 = null;
                            if (object == null) {
                                Logger.getLogger().w("Received null app settings, cannot send reports at crash time.");
                                return Tasks.forResult(null);
                            }
                            Task task = CrashlyticsController.this.logAnalyticsAppExceptionEvents();
                            SessionReportingCoordinator sessionReportingCoordinator = CrashlyticsController.this.reportingCoordinator;
                            Executor executor2 = executor;
                            object = var2_2;
                            if (val$isOnDemand) {
                                object = string2;
                            }
                            return Tasks.whenAll(task, sessionReportingCoordinator.sendReports(executor2, (String)object));
                        }
                    });
                }
            };
            task = ((CrashlyticsBackgroundWorker)object).submitTask(callable);
            try {
                Utils.awaitEvenIfOnMainThread(task);
            }
            catch (Exception exception) {
                Logger.getLogger().e("Error handling uncaught exception", exception);
            }
            catch (TimeoutException timeoutException) {
                Logger.getLogger().e("Cannot send reports. Timed out while fetching settings.");
            }
            return;
        }
    }

    boolean isHandlingException() {
        CrashlyticsUncaughtExceptionHandler crashlyticsUncaughtExceptionHandler = this.crashHandler;
        boolean bl = crashlyticsUncaughtExceptionHandler != null && crashlyticsUncaughtExceptionHandler.isHandlingException();
        return bl;
    }

    List<File> listAppExceptionMarkerFiles() {
        return this.fileStore.getCommonFiles(APP_EXCEPTION_MARKER_FILTER);
    }

    void logFatalException(Thread thread2, Throwable throwable) {
        SettingsProvider settingsProvider = this.settingsProvider;
        if (settingsProvider == null) {
            Logger.getLogger().w("settingsProvider not set");
            return;
        }
        this.handleUncaughtException(settingsProvider, thread2, throwable, true);
    }

    void openSession(final String string2) {
        this.backgroundWorker.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CrashlyticsController.this.doOpenSession(string2);
                return null;
            }
        });
    }

    Task<Void> sendUnsentReports() {
        this.reportActionProvided.trySetResult(true);
        return this.unsentReportsHandled.getTask();
    }

    void setCustomKey(String string2, String string3) {
        try {
            this.userMetadata.setCustomKey(string2, string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string3 = this.context;
            if (string3 != null && CommonUtils.isAppDebuggable((Context)string3)) {
                throw illegalArgumentException;
            }
            Logger.getLogger().e("Attempting to set custom attribute with null key, ignoring.");
        }
    }

    void setCustomKeys(Map<String, String> map) {
        this.userMetadata.setCustomKeys(map);
    }

    void setInternalKey(String string2, String string3) {
        try {
            this.userMetadata.setInternalKey(string2, string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = this.context;
            if (string2 != null && CommonUtils.isAppDebuggable((Context)string2)) {
                throw illegalArgumentException;
            }
            Logger.getLogger().e("Attempting to set custom attribute with null key, ignoring.");
        }
    }

    void setUserId(String string2) {
        this.userMetadata.setUserId(string2);
    }

    Task<Void> submitAllReports(final Task<Settings> task) {
        if (!this.reportingCoordinator.hasReportsToSend()) {
            Logger.getLogger().v("No crash reports are available to be sent.");
            this.unsentReportsAvailable.trySetResult(false);
            return Tasks.forResult(null);
        }
        Logger.getLogger().v("Crash reports are available to be sent.");
        return this.waitForReportAction().onSuccessTask(new SuccessContinuation<Boolean, Void>(){

            @Override
            public Task<Void> then(final Boolean bl) throws Exception {
                return CrashlyticsController.this.backgroundWorker.submitTask(new Callable<Task<Void>>(){

                    @Override
                    public Task<Void> call() throws Exception {
                        if (!bl.booleanValue()) {
                            Logger.getLogger().v("Deleting cached crash reports...");
                            CrashlyticsController.deleteFiles(CrashlyticsController.this.listAppExceptionMarkerFiles());
                            CrashlyticsController.this.reportingCoordinator.removeAllReports();
                            CrashlyticsController.this.unsentReportsHandled.trySetResult(null);
                            return Tasks.forResult(null);
                        }
                        Logger.getLogger().d("Sending cached crash reports...");
                        boolean bl2 = bl;
                        CrashlyticsController.this.dataCollectionArbiter.grantDataCollectionPermission(bl2);
                        final Executor executor = CrashlyticsController.this.backgroundWorker.getExecutor();
                        return task.onSuccessTask(executor, new SuccessContinuation<Settings, Void>(){

                            @Override
                            public Task<Void> then(Settings settings) throws Exception {
                                if (settings == null) {
                                    Logger.getLogger().w("Received null app settings at app startup. Cannot send cached reports");
                                    return Tasks.forResult(null);
                                }
                                CrashlyticsController.this.logAnalyticsAppExceptionEvents();
                                CrashlyticsController.this.reportingCoordinator.sendReports(executor);
                                CrashlyticsController.this.unsentReportsHandled.trySetResult(null);
                                return Tasks.forResult(null);
                            }
                        });
                    }
                });
            }
        });
    }

    void writeNonFatalException(final Thread thread2, final Throwable throwable) {
        final long l = System.currentTimeMillis();
        this.backgroundWorker.submit(new Runnable(){

            @Override
            public void run() {
                if (!CrashlyticsController.this.isHandlingException()) {
                    long l2 = CrashlyticsController.getTimestampSeconds(l);
                    String string2 = CrashlyticsController.this.getCurrentSessionId();
                    if (string2 == null) {
                        Logger.getLogger().w("Tried to write a non-fatal exception while no session was open.");
                        return;
                    }
                    CrashlyticsController.this.reportingCoordinator.persistNonFatalEvent(throwable, thread2, string2, l2);
                }
            }
        });
    }

    void writeToLog(final long l, final String string2) {
        this.backgroundWorker.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (!CrashlyticsController.this.isHandlingException()) {
                    CrashlyticsController.this.logFileManager.writeToLog(l, string2);
                }
                return null;
            }
        });
    }
}

