/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.breadcrumbs.BreadcrumbSource;
import com.google.firebase.crashlytics.internal.common.AppData;
import com.google.firebase.crashlytics.internal.common.CLSUUID;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.CrashlyticsBackgroundWorker;
import com.google.firebase.crashlytics.internal.common.CrashlyticsController;
import com.google.firebase.crashlytics.internal.common.CrashlyticsCore$$ExternalSyntheticLambda0;
import com.google.firebase.crashlytics.internal.common.CrashlyticsFileMarker;
import com.google.firebase.crashlytics.internal.common.DataCollectionArbiter;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.common.OnDemandCounter;
import com.google.firebase.crashlytics.internal.common.SessionReportingCoordinator;
import com.google.firebase.crashlytics.internal.common.Utils;
import com.google.firebase.crashlytics.internal.metadata.LogFileManager;
import com.google.firebase.crashlytics.internal.metadata.UserMetadata;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import com.google.firebase.crashlytics.internal.settings.SettingsProvider;
import com.google.firebase.crashlytics.internal.stacktrace.MiddleOutFallbackStrategy;
import com.google.firebase.crashlytics.internal.stacktrace.RemoveRepeatsStrategy;
import com.google.firebase.crashlytics.internal.stacktrace.StackTraceTrimmingStrategy;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CrashlyticsCore {
    static final String CRASHLYTICS_REQUIRE_BUILD_ID = "com.crashlytics.RequireBuildId";
    static final boolean CRASHLYTICS_REQUIRE_BUILD_ID_DEFAULT = true;
    static final String CRASH_MARKER_FILE_NAME = "crash_marker";
    static final int DEFAULT_MAIN_HANDLER_TIMEOUT_SEC = 4;
    private static final String INITIALIZATION_MARKER_FILE_NAME = "initialization_marker";
    static final int MAX_STACK_SIZE = 1024;
    private static final String MISSING_BUILD_ID_MSG = "The Crashlytics build ID is missing. This occurs when Crashlytics tooling is absent from your app's build configuration. Please review Crashlytics onboarding instructions and ensure you have a valid Crashlytics account.";
    static final int NUM_STACK_REPETITIONS_ALLOWED = 10;
    private static final String ON_DEMAND_DROPPED_KEY = "com.crashlytics.on-demand.dropped-exceptions";
    private static final String ON_DEMAND_RECORDED_KEY = "com.crashlytics.on-demand.recorded-exceptions";
    private final AnalyticsEventLogger analyticsEventLogger;
    private final FirebaseApp app;
    private final CrashlyticsBackgroundWorker backgroundWorker;
    public final BreadcrumbSource breadcrumbSource;
    private final Context context;
    private CrashlyticsController controller;
    private final ExecutorService crashHandlerExecutor;
    private CrashlyticsFileMarker crashMarker;
    private final DataCollectionArbiter dataCollectionArbiter;
    private boolean didCrashOnPreviousExecution;
    private final FileStore fileStore;
    private final IdManager idManager;
    private CrashlyticsFileMarker initializationMarker;
    private final CrashlyticsNativeComponent nativeComponent;
    private final OnDemandCounter onDemandCounter;
    private final long startTime;

    public CrashlyticsCore(FirebaseApp firebaseApp, IdManager idManager, CrashlyticsNativeComponent crashlyticsNativeComponent, DataCollectionArbiter dataCollectionArbiter, BreadcrumbSource breadcrumbSource, AnalyticsEventLogger analyticsEventLogger, FileStore fileStore, ExecutorService executorService) {
        this.app = firebaseApp;
        this.dataCollectionArbiter = dataCollectionArbiter;
        this.context = firebaseApp.getApplicationContext();
        this.idManager = idManager;
        this.nativeComponent = crashlyticsNativeComponent;
        this.breadcrumbSource = breadcrumbSource;
        this.analyticsEventLogger = analyticsEventLogger;
        this.crashHandlerExecutor = executorService;
        this.fileStore = fileStore;
        this.backgroundWorker = new CrashlyticsBackgroundWorker(executorService);
        this.startTime = System.currentTimeMillis();
        this.onDemandCounter = new OnDemandCounter();
    }

    private void checkForPreviousCrash() {
        Object object = this.backgroundWorker.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CrashlyticsCore.this.controller.didCrashOnPreviousExecution();
            }
        });
        try {
            object = Utils.awaitEvenIfOnMainThread(object);
            this.didCrashOnPreviousExecution = Boolean.TRUE.equals(object);
            return;
        }
        catch (Exception exception) {
            this.didCrashOnPreviousExecution = false;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Task<Void> doBackgroundInitialization(SettingsProvider task) {
        Throwable throwable2222222;
        block7: {
            this.markInitializationStarted();
            BreadcrumbSource breadcrumbSource = this.breadcrumbSource;
            CrashlyticsCore$$ExternalSyntheticLambda0 crashlyticsCore$$ExternalSyntheticLambda0 = new CrashlyticsCore$$ExternalSyntheticLambda0(this);
            breadcrumbSource.registerBreadcrumbHandler(crashlyticsCore$$ExternalSyntheticLambda0);
            if (!task.getSettingsSync().featureFlagData.collectReports) {
                Logger.getLogger().d("Collection of crash reports disabled in Crashlytics settings.");
                task = new Task<Void>("Collection of crash reports disabled in Crashlytics settings.");
                task = Tasks.forException((Exception)((Object)task));
                this.markInitializationComplete();
                return task;
            }
            {
                catch (Throwable throwable2222222) {
                    break block7;
                }
                catch (Exception exception) {}
                {
                    Logger.getLogger().e("Crashlytics encountered a problem during asynchronous initialization.", exception);
                    Task<Void> task2 = Tasks.forException(exception);
                    this.markInitializationComplete();
                    return task2;
                }
            }
            {
                if (!this.controller.finalizeSessions((SettingsProvider)((Object)task))) {
                    Logger.getLogger().w("Previous sessions could not be finalized.");
                }
                task = this.controller.submitAllReports(task.getSettingsAsync());
                this.markInitializationComplete();
                return task;
            }
        }
        this.markInitializationComplete();
        throw throwable2222222;
    }

    private void finishInitSynchronously(SettingsProvider future) {
        future = new Runnable((SettingsProvider)((Object)future)){
            final /* synthetic */ SettingsProvider val$settingsProvider;
            {
                this.val$settingsProvider = settingsProvider;
            }

            @Override
            public void run() {
                CrashlyticsCore.this.doBackgroundInitialization(this.val$settingsProvider);
            }
        };
        future = this.crashHandlerExecutor.submit((Runnable)((Object)future));
        Logger.getLogger().d("Crashlytics detected incomplete initialization on previous app launch. Will initialize synchronously.");
        try {
            future.get(4L, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            Logger.getLogger().e("Crashlytics timed out during initialization.", timeoutException);
        }
        catch (ExecutionException executionException) {
            Logger.getLogger().e("Crashlytics encountered a problem during initialization.", executionException);
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger().e("Crashlytics was interrupted during initialization.", interruptedException);
        }
    }

    public static String getVersion() {
        return "18.2.11";
    }

    static boolean isBuildIdValid(String string2, boolean bl) {
        if (!bl) {
            Logger.getLogger().v("Configured not to require a build ID.");
            return true;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return true;
        }
        Log.e((String)"FirebaseCrashlytics", (String)".");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  | ");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".   \\ |  | /");
        Log.e((String)"FirebaseCrashlytics", (String)".    \\    /");
        Log.e((String)"FirebaseCrashlytics", (String)".     \\  /");
        Log.e((String)"FirebaseCrashlytics", (String)".      \\/");
        Log.e((String)"FirebaseCrashlytics", (String)".");
        Log.e((String)"FirebaseCrashlytics", (String)MISSING_BUILD_ID_MSG);
        Log.e((String)"FirebaseCrashlytics", (String)".");
        Log.e((String)"FirebaseCrashlytics", (String)".      /\\");
        Log.e((String)"FirebaseCrashlytics", (String)".     /  \\");
        Log.e((String)"FirebaseCrashlytics", (String)".    /    \\");
        Log.e((String)"FirebaseCrashlytics", (String)".   / |  | \\");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".");
        return false;
    }

    public Task<Boolean> checkForUnsentReports() {
        return this.controller.checkForUnsentReports();
    }

    public Task<Void> deleteUnsentReports() {
        return this.controller.deleteUnsentReports();
    }

    public boolean didCrashOnPreviousExecution() {
        return this.didCrashOnPreviousExecution;
    }

    boolean didPreviousInitializationFail() {
        return this.initializationMarker.isPresent();
    }

    public Task<Void> doBackgroundInitializationAsync(final SettingsProvider settingsProvider) {
        return Utils.callTask(this.crashHandlerExecutor, new Callable<Task<Void>>(){

            @Override
            public Task<Void> call() throws Exception {
                return CrashlyticsCore.this.doBackgroundInitialization(settingsProvider);
            }
        });
    }

    CrashlyticsController getController() {
        return this.controller;
    }

    public void log(String string2) {
        long l = System.currentTimeMillis();
        long l2 = this.startTime;
        this.controller.writeToLog(l - l2, string2);
    }

    public void logException(Throwable throwable) {
        this.controller.writeNonFatalException(Thread.currentThread(), throwable);
    }

    public void logFatalException(Throwable throwable) {
        Object object = Logger.getLogger();
        Object object2 = new StringBuilder();
        ((StringBuilder)object2).append("Recorded on-demand fatal events: ");
        ((StringBuilder)object2).append(this.onDemandCounter.getRecordedOnDemandExceptions());
        ((Logger)object).d(((StringBuilder)object2).toString());
        object2 = Logger.getLogger();
        object = new StringBuilder();
        ((StringBuilder)object).append("Dropped on-demand fatal events: ");
        ((StringBuilder)object).append(this.onDemandCounter.getDroppedOnDemandExceptions());
        ((Logger)object2).d(((StringBuilder)object).toString());
        this.controller.setInternalKey(ON_DEMAND_RECORDED_KEY, Integer.toString(this.onDemandCounter.getRecordedOnDemandExceptions()));
        this.controller.setInternalKey(ON_DEMAND_DROPPED_KEY, Integer.toString(this.onDemandCounter.getDroppedOnDemandExceptions()));
        this.controller.logFatalException(Thread.currentThread(), throwable);
    }

    void markInitializationComplete() {
        this.backgroundWorker.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean bl;
                block3: {
                    try {
                        bl = CrashlyticsCore.this.initializationMarker.remove();
                        if (bl) break block3;
                    }
                    catch (Exception exception) {
                        Logger.getLogger().e("Problem encountered deleting Crashlytics initialization marker.", exception);
                        return false;
                    }
                    Logger.getLogger().w("Initialization marker file was not properly removed.");
                }
                return bl;
            }
        });
    }

    void markInitializationStarted() {
        this.backgroundWorker.checkRunningOnThread();
        this.initializationMarker.create();
        Logger.getLogger().v("Initialization marker file was created.");
    }

    public boolean onPreExecute(AppData appData, SettingsProvider settingsProvider) {
        boolean bl = CommonUtils.getBooleanResourceValue(this.context, CRASHLYTICS_REQUIRE_BUILD_ID, true);
        if (CrashlyticsCore.isBuildIdValid(appData.buildId, bl)) {
            block4: {
                String string2 = new CLSUUID(this.idManager).toString();
                try {
                    Object object = new CrashlyticsFileMarker(CRASH_MARKER_FILE_NAME, this.fileStore);
                    this.crashMarker = object;
                    object = new CrashlyticsFileMarker(INITIALIZATION_MARKER_FILE_NAME, this.fileStore);
                    this.initializationMarker = object;
                    object = new UserMetadata(string2, this.fileStore, this.backgroundWorker);
                    LogFileManager logFileManager = new LogFileManager(this.fileStore);
                    Object object2 = new RemoveRepeatsStrategy(10);
                    Object object3 = new MiddleOutFallbackStrategy(1024, new StackTraceTrimmingStrategy[]{object2});
                    object2 = SessionReportingCoordinator.create(this.context, this.idManager, this.fileStore, appData, logFileManager, (UserMetadata)object, (StackTraceTrimmingStrategy)object3, settingsProvider, this.onDemandCounter);
                    this.controller = object3 = new CrashlyticsController(this.context, this.backgroundWorker, this.idManager, this.dataCollectionArbiter, this.fileStore, this.crashMarker, appData, (UserMetadata)object, logFileManager, (SessionReportingCoordinator)object2, this.nativeComponent, this.analyticsEventLogger);
                    bl = this.didPreviousInitializationFail();
                    this.checkForPreviousCrash();
                    this.controller.enableExceptionHandling(string2, Thread.getDefaultUncaughtExceptionHandler(), settingsProvider);
                    if (!bl) break block4;
                }
                catch (Exception exception) {
                    Logger.getLogger().e("Crashlytics was not started due to an exception during initialization", exception);
                    this.controller = null;
                    return false;
                }
                if (!CommonUtils.canTryConnection(this.context)) break block4;
                Logger.getLogger().d("Crashlytics did not finish previous background initialization. Initializing synchronously.");
                this.finishInitSynchronously(settingsProvider);
                return false;
            }
            Logger.getLogger().d("Successfully configured exception handler.");
            return true;
        }
        throw new IllegalStateException(MISSING_BUILD_ID_MSG);
    }

    public Task<Void> sendUnsentReports() {
        return this.controller.sendUnsentReports();
    }

    public void setCrashlyticsCollectionEnabled(Boolean bl) {
        this.dataCollectionArbiter.setCrashlyticsDataCollectionEnabled(bl);
    }

    public void setCustomKey(String string2, String string3) {
        this.controller.setCustomKey(string2, string3);
    }

    public void setCustomKeys(Map<String, String> map) {
        this.controller.setCustomKeys(map);
    }

    public void setInternalKey(String string2, String string3) {
        this.controller.setInternalKey(string2, string3);
    }

    public void setUserId(String string2) {
        this.controller.setUserId(string2);
    }
}

