/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.settings.SettingsProvider;
import java.util.concurrent.atomic.AtomicBoolean;

class CrashlyticsUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final CrashListener crashListener;
    private final Thread.UncaughtExceptionHandler defaultHandler;
    private final AtomicBoolean isHandlingException;
    private final CrashlyticsNativeComponent nativeComponent;
    private final SettingsProvider settingsProvider;

    public CrashlyticsUncaughtExceptionHandler(CrashListener crashListener, SettingsProvider settingsProvider, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, CrashlyticsNativeComponent crashlyticsNativeComponent) {
        this.crashListener = crashListener;
        this.settingsProvider = settingsProvider;
        this.defaultHandler = uncaughtExceptionHandler;
        this.isHandlingException = new AtomicBoolean(false);
        this.nativeComponent = crashlyticsNativeComponent;
    }

    private boolean shouldRecordUncaughtException(Thread thread2, Throwable throwable) {
        if (thread2 == null) {
            Logger.getLogger().e("Crashlytics will not record uncaught exception; null thread");
            return false;
        }
        if (throwable == null) {
            Logger.getLogger().e("Crashlytics will not record uncaught exception; null throwable");
            return false;
        }
        if (this.nativeComponent.hasCrashDataForCurrentSession()) {
            Logger.getLogger().d("Crashlytics will not record uncaught exception; native crash exists for session.");
            return false;
        }
        return true;
    }

    boolean isHandlingException() {
        return this.isHandlingException.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void uncaughtException(Thread thread2, Throwable throwable) {
        Throwable throwable22;
        block6: {
            block5: {
                this.isHandlingException.set(true);
                try {
                    try {
                        if (this.shouldRecordUncaughtException(thread2, throwable)) {
                            this.crashListener.onUncaughtException(this.settingsProvider, thread2, throwable);
                            break block5;
                        }
                        Logger.getLogger().d("Uncaught exception will not be recorded by Crashlytics.");
                    }
                    catch (Exception exception) {
                        Logger.getLogger().e("An error occurred in the uncaught exception handler", exception);
                    }
                }
                catch (Throwable throwable22) {
                    break block6;
                }
            }
            Logger.getLogger().d("Completed exception processing. Invoking default exception handler.");
            this.defaultHandler.uncaughtException(thread2, throwable);
            this.isHandlingException.set(false);
            return;
        }
        Logger.getLogger().d("Completed exception processing. Invoking default exception handler.");
        this.defaultHandler.uncaughtException(thread2, throwable);
        this.isHandlingException.set(false);
        throw throwable22;
    }

    static interface CrashListener {
        public void onUncaughtException(SettingsProvider var1, Thread var2, Throwable var3);
    }
}

