/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.Utils;
import java.util.concurrent.Executor;

public class DataCollectionArbiter {
    private static final String FIREBASE_CRASHLYTICS_COLLECTION_ENABLED = "firebase_crashlytics_collection_enabled";
    private Boolean crashlyticsDataCollectionEnabled;
    TaskCompletionSource<Void> dataCollectionEnabledTask;
    private final TaskCompletionSource<Void> dataCollectionExplicitlyApproved;
    private final FirebaseApp firebaseApp;
    private boolean setInManifest;
    private final SharedPreferences sharedPreferences;
    private final Object taskLock;
    boolean taskResolved;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataCollectionArbiter(FirebaseApp object) {
        Object object2;
        this.taskLock = object2 = new Object();
        this.dataCollectionEnabledTask = new TaskCompletionSource();
        this.taskResolved = false;
        this.setInManifest = false;
        this.dataCollectionExplicitlyApproved = new TaskCompletionSource();
        Context context = ((FirebaseApp)object).getApplicationContext();
        this.firebaseApp = object;
        this.sharedPreferences = CommonUtils.getSharedPrefs(context);
        Boolean bl = this.getDataCollectionValueFromSharedPreferences();
        object = bl;
        if (bl == null) {
            object = this.getDataCollectionValueFromManifest(context);
        }
        this.crashlyticsDataCollectionEnabled = object;
        synchronized (object2) {
            if (this.isAutomaticDataCollectionEnabled()) {
                this.dataCollectionEnabledTask.trySetResult(null);
                this.taskResolved = true;
            }
            return;
        }
    }

    private Boolean getDataCollectionValueFromManifest(Context object) {
        if ((object = DataCollectionArbiter.readCrashlyticsDataCollectionEnabledFromManifest(object)) == null) {
            this.setInManifest = false;
            return null;
        }
        this.setInManifest = true;
        return Boolean.TRUE.equals(object);
    }

    private Boolean getDataCollectionValueFromSharedPreferences() {
        if (this.sharedPreferences.contains(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED)) {
            this.setInManifest = false;
            return this.sharedPreferences.getBoolean(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED, true);
        }
        return null;
    }

    private void logDataCollectionState(boolean bl) {
        String string2 = bl ? "ENABLED" : "DISABLED";
        String string3 = this.crashlyticsDataCollectionEnabled == null ? "global Firebase setting" : (this.setInManifest ? "firebase_crashlytics_collection_enabled manifest flag" : "API");
        Logger.getLogger().d(String.format("Crashlytics automatic data collection %s by %s.", string2, string3));
    }

    private static Boolean readCrashlyticsDataCollectionEnabledFromManifest(Context context) {
        block4: {
            boolean bl;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) break block4;
            context = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (context == null) break block4;
            try {
                if (context.metaData == null || !context.metaData.containsKey(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED)) break block4;
                bl = context.metaData.getBoolean(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Logger.getLogger().e("Could not read data collection permission from manifest", nameNotFoundException);
            }
            return bl;
        }
        return null;
    }

    private static void storeDataCollectionValueInSharedPreferences(SharedPreferences sharedPreferences, Boolean bl) {
        sharedPreferences = sharedPreferences.edit();
        if (bl != null) {
            sharedPreferences.putBoolean(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED, bl.booleanValue());
        } else {
            sharedPreferences.remove(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED);
        }
        sharedPreferences.apply();
    }

    public void grantDataCollectionPermission(boolean bl) {
        if (bl) {
            this.dataCollectionExplicitlyApproved.trySetResult(null);
            return;
        }
        throw new IllegalStateException("An invalid data collection token was used.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAutomaticDataCollectionEnabled() {
        synchronized (this) {
            Boolean bl = this.crashlyticsDataCollectionEnabled;
            boolean bl2 = bl != null ? bl.booleanValue() : this.firebaseApp.isDataCollectionDefaultEnabled();
            this.logDataCollectionState(bl2);
            return bl2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCrashlyticsDataCollectionEnabled(Boolean object) {
        synchronized (this) {
            Throwable throwable2;
            block11: {
                if (object != null) {
                    try {
                        this.setInManifest = false;
                    }
                    catch (Throwable throwable2) {
                        break block11;
                    }
                }
                Object object2 = object != null ? object : this.getDataCollectionValueFromManifest(this.firebaseApp.getApplicationContext());
                this.crashlyticsDataCollectionEnabled = object2;
                DataCollectionArbiter.storeDataCollectionValueInSharedPreferences(this.sharedPreferences, (Boolean)object);
                object = this.taskLock;
                synchronized (object) {
                    if (this.isAutomaticDataCollectionEnabled()) {
                        if (!this.taskResolved) {
                            this.dataCollectionEnabledTask.trySetResult(null);
                            this.taskResolved = true;
                        }
                    } else if (this.taskResolved) {
                        object2 = new Object();
                        this.dataCollectionEnabledTask = object2;
                        this.taskResolved = false;
                    }
                    return;
                }
            }
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Task<Void> waitForAutomaticDataCollectionEnabled() {
        Object object = this.taskLock;
        synchronized (object) {
            return this.dataCollectionEnabledTask.getTask();
        }
    }

    public Task<Void> waitForDataCollectionPermission(Executor executor) {
        return Utils.race(executor, this.dataCollectionExplicitlyApproved.getTask(), this.waitForAutomaticDataCollectionEnabled());
    }
}

