/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.BackgroundPriorityRunnable;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class ExecutorUtils {
    private static final long DEFAULT_TERMINATION_TIMEOUT = 2L;

    private ExecutorUtils() {
    }

    private static void addDelayedShutdownHook(String string2, ExecutorService executorService) {
        ExecutorUtils.addDelayedShutdownHook(string2, executorService, 2L, TimeUnit.SECONDS);
    }

    private static void addDelayedShutdownHook(final String string2, ExecutorService object, long l, TimeUnit object2) {
        Runtime runtime = Runtime.getRuntime();
        object = new BackgroundPriorityRunnable((ExecutorService)object, l, (TimeUnit)((Object)object2)){
            final /* synthetic */ ExecutorService val$service;
            final /* synthetic */ long val$terminationTimeout;
            final /* synthetic */ TimeUnit val$timeUnit;
            {
                this.val$service = executorService;
                this.val$terminationTimeout = l;
                this.val$timeUnit = timeUnit;
            }

            @Override
            public void onRun() {
                try {
                    Object object = Logger.getLogger();
                    Object object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Executing shutdown hook for ");
                    ((StringBuilder)object2).append(string2);
                    ((Logger)object).d(((StringBuilder)object2).toString());
                    this.val$service.shutdown();
                    if (!this.val$service.awaitTermination(this.val$terminationTimeout, this.val$timeUnit)) {
                        object2 = Logger.getLogger();
                        object = new StringBuilder();
                        ((StringBuilder)object).append(string2);
                        ((StringBuilder)object).append(" did not shut down in the allocated time. Requesting immediate shutdown.");
                        ((Logger)object2).d(((StringBuilder)object).toString());
                        this.val$service.shutdownNow();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger().d(String.format(Locale.US, "Interrupted while waiting for %s to shut down. Requesting immediate shutdown.", string2));
                    this.val$service.shutdownNow();
                }
            }
        };
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("Crashlytics Shutdown Hook for ");
        ((StringBuilder)object2).append(string2);
        runtime.addShutdownHook(new Thread((Runnable)object, ((StringBuilder)object2).toString()));
    }

    public static ExecutorService buildSingleThreadExecutorService(String string2) {
        ExecutorService executorService = ExecutorUtils.newSingleThreadExecutor(ExecutorUtils.getNamedThreadFactory(string2), new ThreadPoolExecutor.DiscardPolicy());
        ExecutorUtils.addDelayedShutdownHook(string2, executorService);
        return executorService;
    }

    public static ScheduledExecutorService buildSingleThreadScheduledExecutorService(String string2) {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(ExecutorUtils.getNamedThreadFactory(string2));
        ExecutorUtils.addDelayedShutdownHook(string2, scheduledExecutorService);
        return scheduledExecutorService;
    }

    public static ThreadFactory getNamedThreadFactory(final String string2) {
        return new ThreadFactory(new AtomicLong(1L)){
            final /* synthetic */ AtomicLong val$count;
            {
                this.val$count = atomicLong;
            }

            @Override
            public Thread newThread(Runnable object) {
                Thread thread2 = Executors.defaultThreadFactory().newThread(new BackgroundPriorityRunnable((Runnable)object){
                    final /* synthetic */ Runnable val$runnable;
                    {
                        this.val$runnable = runnable;
                    }

                    @Override
                    public void onRun() {
                        this.val$runnable.run();
                    }
                });
                object = new StringBuilder();
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(this.val$count.getAndIncrement());
                thread2.setName(((StringBuilder)object).toString());
                return thread2;
            }
        };
    }

    private static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        return Executors.unconfigurableExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, rejectedExecutionHandler));
    }
}

