/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.DataCollectionArbiter;
import com.google.firebase.crashlytics.internal.common.InstallIdProvider;
import com.google.firebase.crashlytics.internal.common.InstallerPackageNameProvider;
import com.google.firebase.crashlytics.internal.common.Utils;
import com.google.firebase.installations.FirebaseInstallationsApi;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Pattern;

public class IdManager
implements InstallIdProvider {
    public static final String DEFAULT_VERSION_NAME = "0.0";
    private static final String FORWARD_SLASH_REGEX;
    private static final Pattern ID_PATTERN;
    static final String PREFKEY_ADVERTISING_ID = "crashlytics.advertising.id";
    static final String PREFKEY_FIREBASE_IID = "firebase.installation.id";
    static final String PREFKEY_INSTALLATION_UUID = "crashlytics.installation.id";
    static final String PREFKEY_LEGACY_INSTALLATION_UUID = "crashlytics.installation.id";
    private static final String SYNTHETIC_FID_PREFIX = "SYN_";
    private final Context appContext;
    private final String appIdentifier;
    private String crashlyticsInstallId;
    private final DataCollectionArbiter dataCollectionArbiter;
    private final FirebaseInstallationsApi firebaseInstallationsApi;
    private final InstallerPackageNameProvider installerPackageNameProvider;

    static {
        ID_PATTERN = Pattern.compile("[^\\p{Alnum}]");
        FORWARD_SLASH_REGEX = Pattern.quote("/");
    }

    public IdManager(Context context, String string2, FirebaseInstallationsApi firebaseInstallationsApi, DataCollectionArbiter dataCollectionArbiter) {
        if (context != null) {
            if (string2 != null) {
                this.appContext = context;
                this.appIdentifier = string2;
                this.firebaseInstallationsApi = firebaseInstallationsApi;
                this.dataCollectionArbiter = dataCollectionArbiter;
                this.installerPackageNameProvider = new InstallerPackageNameProvider();
                return;
            }
            throw new IllegalArgumentException("appIdentifier must not be null");
        }
        throw new IllegalArgumentException("appContext must not be null");
    }

    private String createAndCacheCrashlyticsInstallId(String string2, SharedPreferences sharedPreferences) {
        synchronized (this) {
            String string3 = IdManager.formatId(UUID.randomUUID().toString());
            Logger logger = Logger.getLogger();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Created new Crashlytics installation ID: ");
            stringBuilder.append(string3);
            stringBuilder.append(" for FID: ");
            stringBuilder.append(string2);
            logger.v(stringBuilder.toString());
            sharedPreferences.edit().putString("crashlytics.installation.id", string3).putString(PREFKEY_FIREBASE_IID, string2).apply();
            return string3;
        }
    }

    static String createSyntheticFid() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SYNTHETIC_FID_PREFIX);
        stringBuilder.append(UUID.randomUUID().toString());
        return stringBuilder.toString();
    }

    private String fetchTrueFid() {
        Object object = this.firebaseInstallationsApi.getId();
        try {
            object = Utils.awaitEvenIfOnMainThread(object);
        }
        catch (Exception exception) {
            Logger.getLogger().w("Failed to retrieve Firebase Installations ID.", exception);
            object = null;
        }
        return object;
    }

    private static String formatId(String string2) {
        string2 = string2 == null ? null : ID_PATTERN.matcher(string2).replaceAll("").toLowerCase(Locale.US);
        return string2;
    }

    static boolean isSyntheticFid(String string2) {
        boolean bl = string2 != null && string2.startsWith(SYNTHETIC_FID_PREFIX);
        return bl;
    }

    private String readCachedCrashlyticsInstallId(SharedPreferences sharedPreferences) {
        return sharedPreferences.getString("crashlytics.installation.id", null);
    }

    private String removeForwardSlashesIn(String string2) {
        return string2.replaceAll(FORWARD_SLASH_REGEX, "");
    }

    public String getAppIdentifier() {
        return this.appIdentifier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getCrashlyticsInstallId() {
        synchronized (this) {
            Object object = this.crashlyticsInstallId;
            if (object != null) {
                return object;
            }
            Logger.getLogger().v("Determining Crashlytics installation ID...");
            SharedPreferences sharedPreferences = CommonUtils.getSharedPrefs(this.appContext);
            CharSequence charSequence = sharedPreferences.getString(PREFKEY_FIREBASE_IID, null);
            object = Logger.getLogger();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cached Firebase Installation ID: ");
            stringBuilder.append((String)charSequence);
            ((Logger)object).v(stringBuilder.toString());
            if (this.dataCollectionArbiter.isAutomaticDataCollectionEnabled()) {
                String string2 = this.fetchTrueFid();
                object = Logger.getLogger();
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append("Fetched Firebase Installation ID: ");
                stringBuilder2.append(string2);
                ((Logger)object).v(stringBuilder2.toString());
                object = string2;
                if (string2 == null) {
                    object = charSequence == null ? IdManager.createSyntheticFid() : charSequence;
                }
                this.crashlyticsInstallId = ((String)object).equals(charSequence) ? this.readCachedCrashlyticsInstallId(sharedPreferences) : this.createAndCacheCrashlyticsInstallId((String)object, sharedPreferences);
            } else {
                this.crashlyticsInstallId = IdManager.isSyntheticFid((String)charSequence) ? this.readCachedCrashlyticsInstallId(sharedPreferences) : this.createAndCacheCrashlyticsInstallId(IdManager.createSyntheticFid(), sharedPreferences);
            }
            if (this.crashlyticsInstallId == null) {
                Logger.getLogger().w("Unable to determine Crashlytics Install Id, creating a new one.");
                this.crashlyticsInstallId = this.createAndCacheCrashlyticsInstallId(IdManager.createSyntheticFid(), sharedPreferences);
            }
            object = Logger.getLogger();
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Crashlytics installation ID: ");
            ((StringBuilder)charSequence).append(this.crashlyticsInstallId);
            ((Logger)object).v(((StringBuilder)charSequence).toString());
            return this.crashlyticsInstallId;
        }
    }

    public String getInstallerPackageName() {
        return this.installerPackageNameProvider.getInstallerPackageName(this.appContext);
    }

    public String getModelName() {
        return String.format(Locale.US, "%s/%s", this.removeForwardSlashesIn(Build.MANUFACTURER), this.removeForwardSlashesIn(Build.MODEL));
    }

    public String getOsBuildVersionString() {
        return this.removeForwardSlashesIn(Build.VERSION.INCREMENTAL);
    }

    public String getOsDisplayVersionString() {
        return this.removeForwardSlashesIn(Build.VERSION.RELEASE);
    }
}

