/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.crashlytics.internal.common.ExecutorUtils;
import com.google.firebase.crashlytics.internal.common.Utils$$ExternalSyntheticLambda0;
import com.google.firebase.crashlytics.internal.common.Utils$$ExternalSyntheticLambda1;
import com.google.firebase.crashlytics.internal.common.Utils$$ExternalSyntheticLambda2;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Utils {
    private static final ExecutorService TASK_CONTINUATION_EXECUTOR_SERVICE = ExecutorUtils.buildSingleThreadExecutorService("awaitEvenIfOnMainThread task continuation executor");

    private Utils() {
    }

    public static <T> T awaitEvenIfOnMainThread(Task<T> task) throws InterruptedException, TimeoutException {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        task.continueWith(TASK_CONTINUATION_EXECUTOR_SERVICE, new Utils$$ExternalSyntheticLambda2(countDownLatch));
        countDownLatch.await(4L, TimeUnit.SECONDS);
        if (task.isSuccessful()) {
            return task.getResult();
        }
        if (!task.isCanceled()) {
            if (task.isComplete()) {
                throw new IllegalStateException(task.getException());
            }
            throw new TimeoutException();
        }
        throw new CancellationException("Task is already canceled");
    }

    public static <T> Task<T> callTask(Executor executor, final Callable<Task<T>> callable) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Task task = (Task)callable.call();
                    Continuation continuation = new Continuation<T, Void>(){

                        @Override
                        public Void then(Task<T> task) throws Exception {
                            if (task.isSuccessful()) {
                                taskCompletionSource.setResult(task.getResult());
                            } else {
                                taskCompletionSource.setException(task.getException());
                            }
                            return null;
                        }
                    };
                    task.continueWith(continuation);
                }
                catch (Exception exception) {
                    taskCompletionSource.setException(exception);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    static /* synthetic */ Object lambda$awaitEvenIfOnMainThread$2(CountDownLatch countDownLatch, Task task) throws Exception {
        countDownLatch.countDown();
        return null;
    }

    static /* synthetic */ Void lambda$race$0(TaskCompletionSource taskCompletionSource, Task object) throws Exception {
        if (((Task)object).isSuccessful()) {
            taskCompletionSource.trySetResult(((Task)object).getResult());
        } else {
            object = ((Task)object).getException();
            Objects.requireNonNull(object);
            Exception exception = (Exception)object;
            taskCompletionSource.trySetException((Exception)object);
        }
        return null;
    }

    static /* synthetic */ Void lambda$race$1(TaskCompletionSource taskCompletionSource, Task object) throws Exception {
        if (((Task)object).isSuccessful()) {
            taskCompletionSource.trySetResult(((Task)object).getResult());
        } else {
            object = ((Task)object).getException();
            Objects.requireNonNull(object);
            Exception exception = (Exception)object;
            taskCompletionSource.trySetException((Exception)object);
        }
        return null;
    }

    public static <T> Task<T> race(Task<T> task, Task<T> task2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Utils$$ExternalSyntheticLambda0 utils$$ExternalSyntheticLambda0 = new Utils$$ExternalSyntheticLambda0(taskCompletionSource);
        task.continueWith(utils$$ExternalSyntheticLambda0);
        task2.continueWith(utils$$ExternalSyntheticLambda0);
        return taskCompletionSource.getTask();
    }

    public static <T> Task<T> race(Executor executor, Task<T> task, Task<T> task2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Utils$$ExternalSyntheticLambda1 utils$$ExternalSyntheticLambda1 = new Utils$$ExternalSyntheticLambda1(taskCompletionSource);
        task.continueWith(executor, utils$$ExternalSyntheticLambda1);
        task2.continueWith(executor, utils$$ExternalSyntheticLambda1);
        return taskCompletionSource.getTask();
    }
}

