/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.metadata;

import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class KeysMap {
    private final Map<String, String> keys = new HashMap<String, String>();
    private final int maxEntries;
    private final int maxEntryLength;

    public KeysMap(int n, int n2) {
        this.maxEntries = n;
        this.maxEntryLength = n2;
    }

    private String sanitizeKey(String string2) {
        if (string2 != null) {
            return KeysMap.sanitizeString(string2, this.maxEntryLength);
        }
        throw new IllegalArgumentException("Custom attribute key must not be null.");
    }

    public static String sanitizeString(String string2, int n) {
        String string3 = string2;
        if (string2 != null) {
            string3 = string2 = string2.trim();
            if (string2.length() > n) {
                string3 = string2.substring(0, n);
            }
        }
        return string3;
    }

    public Map<String, String> getKeys() {
        synchronized (this) {
            Map<String, String> map = new Map<String, String>(this.keys);
            map = Collections.unmodifiableMap(map);
            return map;
        }
    }

    public boolean setKey(String string2, String charSequence) {
        synchronized (this) {
            Map<String, String> map;
            Object object;
            block8: {
                block7: {
                    block6: {
                        object = this.sanitizeKey(string2);
                        if (this.keys.size() < this.maxEntries || this.keys.containsKey(object)) break block6;
                        object = Logger.getLogger();
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append("Ignored entry \"");
                        ((StringBuilder)charSequence).append(string2);
                        ((StringBuilder)charSequence).append("\" when adding custom keys. Maximum allowable: ");
                        ((StringBuilder)charSequence).append(this.maxEntries);
                        ((Logger)object).w(((StringBuilder)charSequence).toString());
                        return false;
                    }
                    string2 = KeysMap.sanitizeString((String)charSequence, this.maxEntryLength);
                    boolean bl = CommonUtils.nullSafeEquals(this.keys.get(object), string2);
                    if (!bl) break block7;
                    return false;
                }
                map = this.keys;
                if (charSequence != null) break block8;
                string2 = "";
            }
            map.put((String)object, string2);
            return true;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setKeys(Map<String, String> object) {
        synchronized (this) {
            int n = 0;
            for (Map.Entry entry : object.entrySet()) {
                void var1_7;
                String string2 = this.sanitizeKey((String)entry.getKey());
                if (this.keys.size() >= this.maxEntries && !this.keys.containsKey(string2)) {
                    ++n;
                    continue;
                }
                String string3 = (String)entry.getValue();
                Map<String, String> map = this.keys;
                if (string3 == null) {
                    String string4 = "";
                } else {
                    String string5 = KeysMap.sanitizeString(string3, this.maxEntryLength);
                }
                map.put(string2, (String)var1_7);
            }
            if (n > 0) {
                Logger logger = Logger.getLogger();
                Object object2 = new StringBuilder();
                ((StringBuilder)object2).append("Ignored ");
                ((StringBuilder)object2).append(n);
                ((StringBuilder)object2).append(" entries when adding custom keys. Maximum allowable: ");
                ((StringBuilder)object2).append(this.maxEntries);
                logger.w(((StringBuilder)object2).toString());
            }
            return;
        }
    }
}

