/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.metadata;

import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class MetaDataStore {
    private static final String KEY_USER_ID = "userId";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final FileStore fileStore;

    public MetaDataStore(FileStore fileStore) {
        this.fileStore = fileStore;
    }

    private static Map<String, String> jsonToKeysData(String object) throws JSONException {
        JSONObject jSONObject = new JSONObject((String)object);
        object = new HashMap();
        Iterator iterator2 = jSONObject.keys();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator2.next();
            object.put(string2, MetaDataStore.valueOrNull(jSONObject, string2));
        }
        return object;
    }

    private String jsonToUserId(String string2) throws JSONException {
        return MetaDataStore.valueOrNull(new JSONObject(string2), KEY_USER_ID);
    }

    private static String keysDataToJson(Map<String, String> map) {
        return new JSONObject(map).toString();
    }

    private static void safeDeleteCorruptFile(File file) {
        if (file.exists() && file.delete()) {
            Logger logger = Logger.getLogger();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Deleted corrupt file: ");
            stringBuilder.append(file.getAbsolutePath());
            logger.i(stringBuilder.toString());
        }
    }

    private static String userIdToJson(final String string2) throws JSONException {
        return new JSONObject(){
            {
                this.put(MetaDataStore.KEY_USER_ID, string22);
            }
        }.toString();
    }

    private static String valueOrNull(JSONObject jSONObject, String string2) {
        boolean bl = jSONObject.isNull(string2);
        String string3 = null;
        if (!bl) {
            string3 = jSONObject.optString(string2, null);
        }
        return string3;
    }

    public File getInternalKeysFileForSession(String string2) {
        return this.fileStore.getSessionFile(string2, "internal-keys");
    }

    public File getKeysFileForSession(String string2) {
        return this.fileStore.getSessionFile(string2, "keys");
    }

    public File getUserDataFileForSession(String string2) {
        return this.fileStore.getSessionFile(string2, "user-data");
    }

    public Map<String, String> readKeyData(String string2) {
        return this.readKeyData(string2, false);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    Map<String, String> readKeyData(String object, boolean bl) {
        File file = bl ? this.getInternalKeysFileForSession((String)object) : this.getKeysFileForSession((String)object);
        if (file.exists() && file.length() != 0L) {
            void var4_7;
            block10: {
                void var5_11;
                FileInputStream fileInputStream;
                block9: {
                    Map<String, String> map;
                    object = null;
                    fileInputStream = new FileInputStream(file);
                    object = fileInputStream;
                    try {
                        map = MetaDataStore.jsonToKeysData(CommonUtils.streamToString(fileInputStream));
                    }
                    catch (Exception exception) {
                        break block9;
                    }
                    CommonUtils.closeOrLog(fileInputStream, "Failed to close user metadata file.");
                    return map;
                    catch (Throwable throwable) {
                        break block10;
                    }
                    catch (Exception exception) {
                        fileInputStream = null;
                    }
                }
                object = fileInputStream;
                Logger.getLogger().w("Error deserializing user metadata.", (Throwable)var5_11);
                object = fileInputStream;
                try {
                    MetaDataStore.safeDeleteCorruptFile(file);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                CommonUtils.closeOrLog(fileInputStream, "Failed to close user metadata file.");
                return Collections.emptyMap();
            }
            CommonUtils.closeOrLog((Closeable)object, "Failed to close user metadata file.");
            throw var4_7;
        }
        MetaDataStore.safeDeleteCorruptFile(file);
        return Collections.emptyMap();
    }

    /*
     * Loose catch block
     */
    public String readUserId(String object) {
        File file = this.getUserDataFileForSession((String)object);
        boolean bl = file.exists();
        String string2 = null;
        if (bl && file.length() != 0L) {
            Object object2;
            block18: {
                Object object3;
                block17: {
                    object2 = object3 = new FileInputStream(file);
                    string2 = this.jsonToUserId(CommonUtils.streamToString((InputStream)object3));
                    object2 = object3;
                    Logger logger = Logger.getLogger();
                    object2 = object3;
                    object2 = object3;
                    StringBuilder stringBuilder = new StringBuilder();
                    object2 = object3;
                    stringBuilder.append("Loaded userId ");
                    object2 = object3;
                    stringBuilder.append(string2);
                    object2 = object3;
                    stringBuilder.append(" for session ");
                    object2 = object3;
                    stringBuilder.append((String)object);
                    object2 = object3;
                    try {
                        logger.d(stringBuilder.toString());
                    }
                    catch (Exception exception) {
                        object = object3;
                        object3 = exception;
                        break block17;
                    }
                    CommonUtils.closeOrLog((Closeable)object3, "Failed to close user metadata file.");
                    return string2;
                    catch (Throwable throwable) {
                        object = string2;
                        break block18;
                    }
                    catch (Exception exception) {
                        object = null;
                    }
                }
                object2 = object;
                Logger.getLogger().w("Error deserializing user metadata.", (Throwable)object3);
                object2 = object;
                try {
                    MetaDataStore.safeDeleteCorruptFile(file);
                }
                catch (Throwable throwable) {
                    object3 = object2;
                    object2 = throwable;
                    object = object3;
                }
                CommonUtils.closeOrLog((Closeable)object, "Failed to close user metadata file.");
                return null;
            }
            CommonUtils.closeOrLog((Closeable)object, "Failed to close user metadata file.");
            throw object2;
        }
        Logger logger = Logger.getLogger();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("No userId set for session ");
        stringBuilder.append((String)object);
        logger.d(stringBuilder.toString());
        MetaDataStore.safeDeleteCorruptFile(file);
        return null;
    }

    public void writeKeyData(String string2, Map<String, String> map) {
        this.writeKeyData(string2, map, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeKeyData(String object, Map<String, String> object2, boolean bl) {
        block7: {
            Object object3;
            block8: {
                String string2;
                object3 = bl ? this.getInternalKeysFileForSession((String)object) : this.getKeysFileForSession((String)object);
                Object var5_7 = null;
                Object var6_8 = null;
                object = var6_8;
                try {
                    string2 = MetaDataStore.keysDataToJson(object2);
                    object = var6_8;
                    object = var6_8;
                    object = var6_8;
                    object = var6_8;
                    FileOutputStream fileOutputStream = new FileOutputStream((File)object3);
                    object = var6_8;
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, UTF_8);
                    object = var6_8;
                    object2 = new BufferedWriter(outputStreamWriter);
                }
                catch (Throwable throwable) {
                    break block7;
                }
                catch (Exception exception) {
                    object2 = var5_7;
                    break block8;
                }
                try {
                    ((Writer)object2).write(string2);
                    ((Writer)object2).flush();
                }
                catch (Throwable throwable) {
                    object3 = object2;
                    object2 = throwable;
                    object = object3;
                    break block7;
                }
                catch (Exception exception) {
                    break block8;
                }
                CommonUtils.closeOrLog((Closeable)object2, "Failed to close key/value metadata file.");
                return;
            }
            object = object2;
            {
                void var6_11;
                Logger.getLogger().w("Error serializing key/value metadata.", (Throwable)var6_11);
                object = object2;
                MetaDataStore.safeDeleteCorruptFile((File)object3);
            }
            CommonUtils.closeOrLog((Closeable)object2, "Failed to close key/value metadata file.");
            return;
        }
        CommonUtils.closeOrLog((Closeable)object, "Failed to close key/value metadata file.");
        throw object2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeUserData(String object, String object2) {
        block7: {
            Exception exception;
            block8: {
                String string2;
                File file = this.getUserDataFileForSession((String)object);
                Object var4_6 = null;
                exception = null;
                object = exception;
                try {
                    string2 = MetaDataStore.userIdToJson((String)object2);
                    object = exception;
                    object = exception;
                    object = exception;
                    object = exception;
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    object = exception;
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, UTF_8);
                    object = exception;
                    object2 = new BufferedWriter(outputStreamWriter);
                }
                catch (Throwable throwable) {
                    break block7;
                }
                catch (Exception exception2) {
                    object2 = var4_6;
                    break block8;
                }
                try {
                    ((Writer)object2).write(string2);
                    ((Writer)object2).flush();
                }
                catch (Throwable throwable) {
                    object = object2;
                    object2 = throwable;
                    break block7;
                }
                catch (Exception exception3) {
                    exception = exception3;
                    break block8;
                }
                CommonUtils.closeOrLog((Closeable)object2, "Failed to close user metadata file.");
                return;
            }
            object = object2;
            {
                Logger.getLogger().w("Error serializing user metadata.", exception);
            }
            CommonUtils.closeOrLog((Closeable)object2, "Failed to close user metadata file.");
            return;
        }
        CommonUtils.closeOrLog((Closeable)object, "Failed to close user metadata file.");
        throw object2;
    }
}

