/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.metadata;

import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.CrashlyticsBackgroundWorker;
import com.google.firebase.crashlytics.internal.metadata.KeysMap;
import com.google.firebase.crashlytics.internal.metadata.MetaDataStore;
import com.google.firebase.crashlytics.internal.metadata.UserMetadata$$ExternalSyntheticLambda0;
import com.google.firebase.crashlytics.internal.metadata.UserMetadata$SerializeableKeysMap$$ExternalSyntheticLambda0;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UserMetadata {
    public static final String INTERNAL_KEYDATA_FILENAME = "internal-keys";
    public static final String KEYDATA_FILENAME = "keys";
    public static final int MAX_ATTRIBUTES = 64;
    public static final int MAX_ATTRIBUTE_SIZE = 1024;
    public static final int MAX_INTERNAL_KEY_SIZE = 8192;
    public static final String USERDATA_FILENAME = "user-data";
    private final CrashlyticsBackgroundWorker backgroundWorker;
    private final SerializeableKeysMap customKeys = new SerializeableKeysMap(false);
    private final SerializeableKeysMap internalKeys = new SerializeableKeysMap(true);
    private final MetaDataStore metaDataStore;
    private final String sessionIdentifier;
    private final AtomicMarkableReference<String> userId = new AtomicMarkableReference<Object>(null, false);

    public UserMetadata(String string2, FileStore fileStore, CrashlyticsBackgroundWorker crashlyticsBackgroundWorker) {
        this.sessionIdentifier = string2;
        this.metaDataStore = new MetaDataStore(fileStore);
        this.backgroundWorker = crashlyticsBackgroundWorker;
    }

    public static UserMetadata loadFromExistingSession(String string2, FileStore object, CrashlyticsBackgroundWorker crashlyticsBackgroundWorker) {
        MetaDataStore metaDataStore = new MetaDataStore((FileStore)object);
        object = new UserMetadata(string2, (FileStore)object, crashlyticsBackgroundWorker);
        ((UserMetadata)object).customKeys.map.getReference().setKeys(metaDataStore.readKeyData(string2, false));
        ((UserMetadata)object).internalKeys.map.getReference().setKeys(metaDataStore.readKeyData(string2, true));
        ((UserMetadata)object).userId.set(metaDataStore.readUserId(string2), false);
        return object;
    }

    public static String readUserId(String string2, FileStore fileStore) {
        return new MetaDataStore(fileStore).readUserId(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void serializeUserDataIfNeeded() {
        String string2;
        AtomicMarkableReference<String> atomicMarkableReference = this.userId;
        // MONITORENTER : atomicMarkableReference
        boolean bl = this.userId.isMarked();
        boolean bl2 = false;
        if (bl) {
            string2 = this.getUserId();
            this.userId.set(string2, false);
            bl2 = true;
        } else {
            string2 = null;
        }
        // MONITOREXIT : atomicMarkableReference
        if (!bl2) return;
        this.metaDataStore.writeUserData(this.sessionIdentifier, string2);
    }

    public Map<String, String> getCustomKeys() {
        return this.customKeys.getKeys();
    }

    public Map<String, String> getInternalKeys() {
        return this.internalKeys.getKeys();
    }

    public String getUserId() {
        return this.userId.getReference();
    }

    public /* synthetic */ Object lambda$setUserId$0$com-google-firebase-crashlytics-internal-metadata-UserMetadata() throws Exception {
        this.serializeUserDataIfNeeded();
        return null;
    }

    public boolean setCustomKey(String string2, String string3) {
        return this.customKeys.setKey(string2, string3);
    }

    public void setCustomKeys(Map<String, String> map) {
        this.customKeys.setKeys(map);
    }

    public boolean setInternalKey(String string2, String string3) {
        return this.internalKeys.setKey(string2, string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUserId(String object) {
        String string2 = KeysMap.sanitizeString((String)object, 1024);
        object = this.userId;
        synchronized (object) {
            if (CommonUtils.nullSafeEquals(string2, this.userId.getReference())) {
                return;
            }
            this.userId.set(string2, true);
        }
        this.backgroundWorker.submit(new UserMetadata$$ExternalSyntheticLambda0(this));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SerializeableKeysMap {
        private final boolean isInternal;
        final AtomicMarkableReference<KeysMap> map;
        private final AtomicReference<Callable<Void>> queuedSerializer = new AtomicReference<Object>(null);

        public SerializeableKeysMap(boolean bl) {
            this.isInternal = bl;
            int n = bl ? 8192 : 1024;
            this.map = new AtomicMarkableReference<KeysMap>(new KeysMap(64, n), false);
        }

        private void scheduleSerializationTaskIfNeeded() {
            UserMetadata$SerializeableKeysMap$$ExternalSyntheticLambda0 userMetadata$SerializeableKeysMap$$ExternalSyntheticLambda0 = new UserMetadata$SerializeableKeysMap$$ExternalSyntheticLambda0(this);
            if (this.queuedSerializer.compareAndSet(null, userMetadata$SerializeableKeysMap$$ExternalSyntheticLambda0)) {
                UserMetadata.this.backgroundWorker.submit(userMetadata$SerializeableKeysMap$$ExternalSyntheticLambda0);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void serializeIfMarked() {
            Map<String, String> map;
            synchronized (this) {
                if (!this.map.isMarked()) return;
                map = this.map.getReference().getKeys();
                AtomicMarkableReference<KeysMap> atomicMarkableReference = this.map;
                atomicMarkableReference.set(atomicMarkableReference.getReference(), false);
            }
            if (map == null) return;
            UserMetadata.this.metaDataStore.writeKeyData(UserMetadata.this.sessionIdentifier, map, this.isInternal);
        }

        public Map<String, String> getKeys() {
            return this.map.getReference().getKeys();
        }

        public /* synthetic */ Void lambda$scheduleSerializationTaskIfNeeded$0$com-google-firebase-crashlytics-internal-metadata-UserMetadata$SerializeableKeysMap() throws Exception {
            this.queuedSerializer.set(null);
            this.serializeIfMarked();
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean setKey(String object, String string2) {
            synchronized (this) {
                if (!this.map.getReference().setKey((String)object, string2)) {
                    return false;
                }
                object = this.map;
                ((AtomicMarkableReference)object).set((KeysMap)((AtomicMarkableReference)object).getReference(), true);
            }
            this.scheduleSerializationTaskIfNeeded();
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setKeys(Map<String, String> object) {
            synchronized (this) {
                this.map.getReference().setKeys((Map<String, String>)object);
                object = this.map;
                ((AtomicMarkableReference)object).set((KeysMap)((AtomicMarkableReference)object).getReference(), true);
            }
            this.scheduleSerializationTaskIfNeeded();
        }
    }
}

