/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.model;

import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_ApplicationExitInfo;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_CustomAttribute;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_FilesPayload;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_FilesPayload_File;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Application;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Application_Organization;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Device;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution_BinaryImage;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Exception;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Signal;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Thread;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Thread_Frame;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Device;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Log;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_OperatingSystem;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_User;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.encoders.FieldDescriptor;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.encoders.config.Configurator;
import com.google.firebase.encoders.config.EncoderConfig;
import java.io.IOException;

public final class AutoCrashlyticsReportEncoder
implements Configurator {
    public static final int CODEGEN_VERSION = 2;
    public static final Configurator CONFIG = new AutoCrashlyticsReportEncoder();

    private AutoCrashlyticsReportEncoder() {
    }

    @Override
    public void configure(EncoderConfig<?> encoderConfig) {
        encoderConfig.registerEncoder(CrashlyticsReport.class, CrashlyticsReportEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport.class, CrashlyticsReportEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.class, CrashlyticsReportSessionEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session.class, CrashlyticsReportSessionEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.Application.class, CrashlyticsReportSessionApplicationEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session_Application.class, CrashlyticsReportSessionApplicationEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.Application.Organization.class, CrashlyticsReportSessionApplicationOrganizationEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session_Application_Organization.class, CrashlyticsReportSessionApplicationOrganizationEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.User.class, CrashlyticsReportSessionUserEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session_User.class, CrashlyticsReportSessionUserEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.OperatingSystem.class, CrashlyticsReportSessionOperatingSystemEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session_OperatingSystem.class, CrashlyticsReportSessionOperatingSystemEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.Device.class, CrashlyticsReportSessionDeviceEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session_Device.class, CrashlyticsReportSessionDeviceEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.Event.class, CrashlyticsReportSessionEventEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session_Event.class, CrashlyticsReportSessionEventEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.Event.Application.class, CrashlyticsReportSessionEventApplicationEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session_Event_Application.class, CrashlyticsReportSessionEventApplicationEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.Event.Application.Execution.class, CrashlyticsReportSessionEventApplicationExecutionEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session_Event_Application_Execution.class, CrashlyticsReportSessionEventApplicationExecutionEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.Event.Application.Execution.Thread.class, CrashlyticsReportSessionEventApplicationExecutionThreadEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Thread.class, CrashlyticsReportSessionEventApplicationExecutionThreadEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame.class, CrashlyticsReportSessionEventApplicationExecutionThreadFrameEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Thread_Frame.class, CrashlyticsReportSessionEventApplicationExecutionThreadFrameEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.Event.Application.Execution.Exception.class, CrashlyticsReportSessionEventApplicationExecutionExceptionEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Exception.class, CrashlyticsReportSessionEventApplicationExecutionExceptionEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.ApplicationExitInfo.class, CrashlyticsReportApplicationExitInfoEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_ApplicationExitInfo.class, CrashlyticsReportApplicationExitInfoEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.Event.Application.Execution.Signal.class, CrashlyticsReportSessionEventApplicationExecutionSignalEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Signal.class, CrashlyticsReportSessionEventApplicationExecutionSignalEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.Event.Application.Execution.BinaryImage.class, CrashlyticsReportSessionEventApplicationExecutionBinaryImageEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session_Event_Application_Execution_BinaryImage.class, CrashlyticsReportSessionEventApplicationExecutionBinaryImageEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.CustomAttribute.class, CrashlyticsReportCustomAttributeEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_CustomAttribute.class, CrashlyticsReportCustomAttributeEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.Event.Device.class, CrashlyticsReportSessionEventDeviceEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session_Event_Device.class, CrashlyticsReportSessionEventDeviceEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.Session.Event.Log.class, CrashlyticsReportSessionEventLogEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_Session_Event_Log.class, CrashlyticsReportSessionEventLogEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.FilesPayload.class, CrashlyticsReportFilesPayloadEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_FilesPayload.class, CrashlyticsReportFilesPayloadEncoder.INSTANCE);
        encoderConfig.registerEncoder(CrashlyticsReport.FilesPayload.File.class, CrashlyticsReportFilesPayloadFileEncoder.INSTANCE);
        encoderConfig.registerEncoder(AutoValue_CrashlyticsReport_FilesPayload_File.class, CrashlyticsReportFilesPayloadFileEncoder.INSTANCE);
    }

    private static final class CrashlyticsReportApplicationExitInfoEncoder
    implements ObjectEncoder<CrashlyticsReport.ApplicationExitInfo> {
        private static final FieldDescriptor IMPORTANCE_DESCRIPTOR;
        static final CrashlyticsReportApplicationExitInfoEncoder INSTANCE;
        private static final FieldDescriptor PID_DESCRIPTOR;
        private static final FieldDescriptor PROCESSNAME_DESCRIPTOR;
        private static final FieldDescriptor PSS_DESCRIPTOR;
        private static final FieldDescriptor REASONCODE_DESCRIPTOR;
        private static final FieldDescriptor RSS_DESCRIPTOR;
        private static final FieldDescriptor TIMESTAMP_DESCRIPTOR;
        private static final FieldDescriptor TRACEFILE_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportApplicationExitInfoEncoder();
            PID_DESCRIPTOR = FieldDescriptor.of("pid");
            PROCESSNAME_DESCRIPTOR = FieldDescriptor.of("processName");
            REASONCODE_DESCRIPTOR = FieldDescriptor.of("reasonCode");
            IMPORTANCE_DESCRIPTOR = FieldDescriptor.of("importance");
            PSS_DESCRIPTOR = FieldDescriptor.of("pss");
            RSS_DESCRIPTOR = FieldDescriptor.of("rss");
            TIMESTAMP_DESCRIPTOR = FieldDescriptor.of("timestamp");
            TRACEFILE_DESCRIPTOR = FieldDescriptor.of("traceFile");
        }

        private CrashlyticsReportApplicationExitInfoEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.ApplicationExitInfo applicationExitInfo, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(PID_DESCRIPTOR, applicationExitInfo.getPid());
            objectEncoderContext.add(PROCESSNAME_DESCRIPTOR, (Object)applicationExitInfo.getProcessName());
            objectEncoderContext.add(REASONCODE_DESCRIPTOR, applicationExitInfo.getReasonCode());
            objectEncoderContext.add(IMPORTANCE_DESCRIPTOR, applicationExitInfo.getImportance());
            objectEncoderContext.add(PSS_DESCRIPTOR, applicationExitInfo.getPss());
            objectEncoderContext.add(RSS_DESCRIPTOR, applicationExitInfo.getRss());
            objectEncoderContext.add(TIMESTAMP_DESCRIPTOR, applicationExitInfo.getTimestamp());
            objectEncoderContext.add(TRACEFILE_DESCRIPTOR, (Object)applicationExitInfo.getTraceFile());
        }
    }

    private static final class CrashlyticsReportCustomAttributeEncoder
    implements ObjectEncoder<CrashlyticsReport.CustomAttribute> {
        static final CrashlyticsReportCustomAttributeEncoder INSTANCE = new CrashlyticsReportCustomAttributeEncoder();
        private static final FieldDescriptor KEY_DESCRIPTOR = FieldDescriptor.of("key");
        private static final FieldDescriptor VALUE_DESCRIPTOR = FieldDescriptor.of("value");

        private CrashlyticsReportCustomAttributeEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.CustomAttribute customAttribute, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(KEY_DESCRIPTOR, (Object)customAttribute.getKey());
            objectEncoderContext.add(VALUE_DESCRIPTOR, (Object)customAttribute.getValue());
        }
    }

    private static final class CrashlyticsReportEncoder
    implements ObjectEncoder<CrashlyticsReport> {
        private static final FieldDescriptor BUILDVERSION_DESCRIPTOR;
        private static final FieldDescriptor DISPLAYVERSION_DESCRIPTOR;
        private static final FieldDescriptor GMPAPPID_DESCRIPTOR;
        private static final FieldDescriptor INSTALLATIONUUID_DESCRIPTOR;
        static final CrashlyticsReportEncoder INSTANCE;
        private static final FieldDescriptor NDKPAYLOAD_DESCRIPTOR;
        private static final FieldDescriptor PLATFORM_DESCRIPTOR;
        private static final FieldDescriptor SDKVERSION_DESCRIPTOR;
        private static final FieldDescriptor SESSION_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportEncoder();
            SDKVERSION_DESCRIPTOR = FieldDescriptor.of("sdkVersion");
            GMPAPPID_DESCRIPTOR = FieldDescriptor.of("gmpAppId");
            PLATFORM_DESCRIPTOR = FieldDescriptor.of("platform");
            INSTALLATIONUUID_DESCRIPTOR = FieldDescriptor.of("installationUuid");
            BUILDVERSION_DESCRIPTOR = FieldDescriptor.of("buildVersion");
            DISPLAYVERSION_DESCRIPTOR = FieldDescriptor.of("displayVersion");
            SESSION_DESCRIPTOR = FieldDescriptor.of("session");
            NDKPAYLOAD_DESCRIPTOR = FieldDescriptor.of("ndkPayload");
        }

        private CrashlyticsReportEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport crashlyticsReport, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(SDKVERSION_DESCRIPTOR, (Object)crashlyticsReport.getSdkVersion());
            objectEncoderContext.add(GMPAPPID_DESCRIPTOR, (Object)crashlyticsReport.getGmpAppId());
            objectEncoderContext.add(PLATFORM_DESCRIPTOR, crashlyticsReport.getPlatform());
            objectEncoderContext.add(INSTALLATIONUUID_DESCRIPTOR, (Object)crashlyticsReport.getInstallationUuid());
            objectEncoderContext.add(BUILDVERSION_DESCRIPTOR, (Object)crashlyticsReport.getBuildVersion());
            objectEncoderContext.add(DISPLAYVERSION_DESCRIPTOR, (Object)crashlyticsReport.getDisplayVersion());
            objectEncoderContext.add(SESSION_DESCRIPTOR, (Object)crashlyticsReport.getSession());
            objectEncoderContext.add(NDKPAYLOAD_DESCRIPTOR, (Object)crashlyticsReport.getNdkPayload());
        }
    }

    private static final class CrashlyticsReportFilesPayloadEncoder
    implements ObjectEncoder<CrashlyticsReport.FilesPayload> {
        private static final FieldDescriptor FILES_DESCRIPTOR;
        static final CrashlyticsReportFilesPayloadEncoder INSTANCE;
        private static final FieldDescriptor ORGID_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportFilesPayloadEncoder();
            FILES_DESCRIPTOR = FieldDescriptor.of("files");
            ORGID_DESCRIPTOR = FieldDescriptor.of("orgId");
        }

        private CrashlyticsReportFilesPayloadEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.FilesPayload filesPayload, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(FILES_DESCRIPTOR, filesPayload.getFiles());
            objectEncoderContext.add(ORGID_DESCRIPTOR, (Object)filesPayload.getOrgId());
        }
    }

    private static final class CrashlyticsReportFilesPayloadFileEncoder
    implements ObjectEncoder<CrashlyticsReport.FilesPayload.File> {
        private static final FieldDescriptor CONTENTS_DESCRIPTOR;
        private static final FieldDescriptor FILENAME_DESCRIPTOR;
        static final CrashlyticsReportFilesPayloadFileEncoder INSTANCE;

        static {
            INSTANCE = new CrashlyticsReportFilesPayloadFileEncoder();
            FILENAME_DESCRIPTOR = FieldDescriptor.of("filename");
            CONTENTS_DESCRIPTOR = FieldDescriptor.of("contents");
        }

        private CrashlyticsReportFilesPayloadFileEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.FilesPayload.File file, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(FILENAME_DESCRIPTOR, (Object)file.getFilename());
            objectEncoderContext.add(CONTENTS_DESCRIPTOR, (Object)file.getContents());
        }
    }

    private static final class CrashlyticsReportSessionApplicationEncoder
    implements ObjectEncoder<CrashlyticsReport.Session.Application> {
        private static final FieldDescriptor DEVELOPMENTPLATFORMVERSION_DESCRIPTOR;
        private static final FieldDescriptor DEVELOPMENTPLATFORM_DESCRIPTOR;
        private static final FieldDescriptor DISPLAYVERSION_DESCRIPTOR;
        private static final FieldDescriptor IDENTIFIER_DESCRIPTOR;
        private static final FieldDescriptor INSTALLATIONUUID_DESCRIPTOR;
        static final CrashlyticsReportSessionApplicationEncoder INSTANCE;
        private static final FieldDescriptor ORGANIZATION_DESCRIPTOR;
        private static final FieldDescriptor VERSION_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportSessionApplicationEncoder();
            IDENTIFIER_DESCRIPTOR = FieldDescriptor.of("identifier");
            VERSION_DESCRIPTOR = FieldDescriptor.of("version");
            DISPLAYVERSION_DESCRIPTOR = FieldDescriptor.of("displayVersion");
            ORGANIZATION_DESCRIPTOR = FieldDescriptor.of("organization");
            INSTALLATIONUUID_DESCRIPTOR = FieldDescriptor.of("installationUuid");
            DEVELOPMENTPLATFORM_DESCRIPTOR = FieldDescriptor.of("developmentPlatform");
            DEVELOPMENTPLATFORMVERSION_DESCRIPTOR = FieldDescriptor.of("developmentPlatformVersion");
        }

        private CrashlyticsReportSessionApplicationEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session.Application application, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(IDENTIFIER_DESCRIPTOR, (Object)application.getIdentifier());
            objectEncoderContext.add(VERSION_DESCRIPTOR, (Object)application.getVersion());
            objectEncoderContext.add(DISPLAYVERSION_DESCRIPTOR, (Object)application.getDisplayVersion());
            objectEncoderContext.add(ORGANIZATION_DESCRIPTOR, (Object)application.getOrganization());
            objectEncoderContext.add(INSTALLATIONUUID_DESCRIPTOR, (Object)application.getInstallationUuid());
            objectEncoderContext.add(DEVELOPMENTPLATFORM_DESCRIPTOR, (Object)application.getDevelopmentPlatform());
            objectEncoderContext.add(DEVELOPMENTPLATFORMVERSION_DESCRIPTOR, (Object)application.getDevelopmentPlatformVersion());
        }
    }

    private static final class CrashlyticsReportSessionApplicationOrganizationEncoder
    implements ObjectEncoder<CrashlyticsReport.Session.Application.Organization> {
        private static final FieldDescriptor CLSID_DESCRIPTOR;
        static final CrashlyticsReportSessionApplicationOrganizationEncoder INSTANCE;

        static {
            INSTANCE = new CrashlyticsReportSessionApplicationOrganizationEncoder();
            CLSID_DESCRIPTOR = FieldDescriptor.of("clsId");
        }

        private CrashlyticsReportSessionApplicationOrganizationEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session.Application.Organization organization, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(CLSID_DESCRIPTOR, (Object)organization.getClsId());
        }
    }

    private static final class CrashlyticsReportSessionDeviceEncoder
    implements ObjectEncoder<CrashlyticsReport.Session.Device> {
        private static final FieldDescriptor ARCH_DESCRIPTOR;
        private static final FieldDescriptor CORES_DESCRIPTOR;
        private static final FieldDescriptor DISKSPACE_DESCRIPTOR;
        static final CrashlyticsReportSessionDeviceEncoder INSTANCE;
        private static final FieldDescriptor MANUFACTURER_DESCRIPTOR;
        private static final FieldDescriptor MODELCLASS_DESCRIPTOR;
        private static final FieldDescriptor MODEL_DESCRIPTOR;
        private static final FieldDescriptor RAM_DESCRIPTOR;
        private static final FieldDescriptor SIMULATOR_DESCRIPTOR;
        private static final FieldDescriptor STATE_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportSessionDeviceEncoder();
            ARCH_DESCRIPTOR = FieldDescriptor.of("arch");
            MODEL_DESCRIPTOR = FieldDescriptor.of("model");
            CORES_DESCRIPTOR = FieldDescriptor.of("cores");
            RAM_DESCRIPTOR = FieldDescriptor.of("ram");
            DISKSPACE_DESCRIPTOR = FieldDescriptor.of("diskSpace");
            SIMULATOR_DESCRIPTOR = FieldDescriptor.of("simulator");
            STATE_DESCRIPTOR = FieldDescriptor.of("state");
            MANUFACTURER_DESCRIPTOR = FieldDescriptor.of("manufacturer");
            MODELCLASS_DESCRIPTOR = FieldDescriptor.of("modelClass");
        }

        private CrashlyticsReportSessionDeviceEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session.Device device, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(ARCH_DESCRIPTOR, device.getArch());
            objectEncoderContext.add(MODEL_DESCRIPTOR, (Object)device.getModel());
            objectEncoderContext.add(CORES_DESCRIPTOR, device.getCores());
            objectEncoderContext.add(RAM_DESCRIPTOR, device.getRam());
            objectEncoderContext.add(DISKSPACE_DESCRIPTOR, device.getDiskSpace());
            objectEncoderContext.add(SIMULATOR_DESCRIPTOR, device.isSimulator());
            objectEncoderContext.add(STATE_DESCRIPTOR, device.getState());
            objectEncoderContext.add(MANUFACTURER_DESCRIPTOR, (Object)device.getManufacturer());
            objectEncoderContext.add(MODELCLASS_DESCRIPTOR, (Object)device.getModelClass());
        }
    }

    private static final class CrashlyticsReportSessionEncoder
    implements ObjectEncoder<CrashlyticsReport.Session> {
        private static final FieldDescriptor APP_DESCRIPTOR;
        private static final FieldDescriptor CRASHED_DESCRIPTOR;
        private static final FieldDescriptor DEVICE_DESCRIPTOR;
        private static final FieldDescriptor ENDEDAT_DESCRIPTOR;
        private static final FieldDescriptor EVENTS_DESCRIPTOR;
        private static final FieldDescriptor GENERATORTYPE_DESCRIPTOR;
        private static final FieldDescriptor GENERATOR_DESCRIPTOR;
        private static final FieldDescriptor IDENTIFIER_DESCRIPTOR;
        static final CrashlyticsReportSessionEncoder INSTANCE;
        private static final FieldDescriptor OS_DESCRIPTOR;
        private static final FieldDescriptor STARTEDAT_DESCRIPTOR;
        private static final FieldDescriptor USER_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportSessionEncoder();
            GENERATOR_DESCRIPTOR = FieldDescriptor.of("generator");
            IDENTIFIER_DESCRIPTOR = FieldDescriptor.of("identifier");
            STARTEDAT_DESCRIPTOR = FieldDescriptor.of("startedAt");
            ENDEDAT_DESCRIPTOR = FieldDescriptor.of("endedAt");
            CRASHED_DESCRIPTOR = FieldDescriptor.of("crashed");
            APP_DESCRIPTOR = FieldDescriptor.of("app");
            USER_DESCRIPTOR = FieldDescriptor.of("user");
            OS_DESCRIPTOR = FieldDescriptor.of("os");
            DEVICE_DESCRIPTOR = FieldDescriptor.of("device");
            EVENTS_DESCRIPTOR = FieldDescriptor.of("events");
            GENERATORTYPE_DESCRIPTOR = FieldDescriptor.of("generatorType");
        }

        private CrashlyticsReportSessionEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session session, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(GENERATOR_DESCRIPTOR, (Object)session.getGenerator());
            objectEncoderContext.add(IDENTIFIER_DESCRIPTOR, (Object)session.getIdentifierUtf8Bytes());
            objectEncoderContext.add(STARTEDAT_DESCRIPTOR, session.getStartedAt());
            objectEncoderContext.add(ENDEDAT_DESCRIPTOR, (Object)session.getEndedAt());
            objectEncoderContext.add(CRASHED_DESCRIPTOR, session.isCrashed());
            objectEncoderContext.add(APP_DESCRIPTOR, (Object)session.getApp());
            objectEncoderContext.add(USER_DESCRIPTOR, (Object)session.getUser());
            objectEncoderContext.add(OS_DESCRIPTOR, (Object)session.getOs());
            objectEncoderContext.add(DEVICE_DESCRIPTOR, (Object)session.getDevice());
            objectEncoderContext.add(EVENTS_DESCRIPTOR, session.getEvents());
            objectEncoderContext.add(GENERATORTYPE_DESCRIPTOR, session.getGeneratorType());
        }
    }

    private static final class CrashlyticsReportSessionEventApplicationEncoder
    implements ObjectEncoder<CrashlyticsReport.Session.Event.Application> {
        private static final FieldDescriptor BACKGROUND_DESCRIPTOR;
        private static final FieldDescriptor CUSTOMATTRIBUTES_DESCRIPTOR;
        private static final FieldDescriptor EXECUTION_DESCRIPTOR;
        static final CrashlyticsReportSessionEventApplicationEncoder INSTANCE;
        private static final FieldDescriptor INTERNALKEYS_DESCRIPTOR;
        private static final FieldDescriptor UIORIENTATION_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportSessionEventApplicationEncoder();
            EXECUTION_DESCRIPTOR = FieldDescriptor.of("execution");
            CUSTOMATTRIBUTES_DESCRIPTOR = FieldDescriptor.of("customAttributes");
            INTERNALKEYS_DESCRIPTOR = FieldDescriptor.of("internalKeys");
            BACKGROUND_DESCRIPTOR = FieldDescriptor.of("background");
            UIORIENTATION_DESCRIPTOR = FieldDescriptor.of("uiOrientation");
        }

        private CrashlyticsReportSessionEventApplicationEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session.Event.Application application, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(EXECUTION_DESCRIPTOR, (Object)application.getExecution());
            objectEncoderContext.add(CUSTOMATTRIBUTES_DESCRIPTOR, application.getCustomAttributes());
            objectEncoderContext.add(INTERNALKEYS_DESCRIPTOR, application.getInternalKeys());
            objectEncoderContext.add(BACKGROUND_DESCRIPTOR, (Object)application.getBackground());
            objectEncoderContext.add(UIORIENTATION_DESCRIPTOR, application.getUiOrientation());
        }
    }

    private static final class CrashlyticsReportSessionEventApplicationExecutionBinaryImageEncoder
    implements ObjectEncoder<CrashlyticsReport.Session.Event.Application.Execution.BinaryImage> {
        private static final FieldDescriptor BASEADDRESS_DESCRIPTOR;
        static final CrashlyticsReportSessionEventApplicationExecutionBinaryImageEncoder INSTANCE;
        private static final FieldDescriptor NAME_DESCRIPTOR;
        private static final FieldDescriptor SIZE_DESCRIPTOR;
        private static final FieldDescriptor UUID_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportSessionEventApplicationExecutionBinaryImageEncoder();
            BASEADDRESS_DESCRIPTOR = FieldDescriptor.of("baseAddress");
            SIZE_DESCRIPTOR = FieldDescriptor.of("size");
            NAME_DESCRIPTOR = FieldDescriptor.of("name");
            UUID_DESCRIPTOR = FieldDescriptor.of("uuid");
        }

        private CrashlyticsReportSessionEventApplicationExecutionBinaryImageEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session.Event.Application.Execution.BinaryImage binaryImage, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(BASEADDRESS_DESCRIPTOR, binaryImage.getBaseAddress());
            objectEncoderContext.add(SIZE_DESCRIPTOR, binaryImage.getSize());
            objectEncoderContext.add(NAME_DESCRIPTOR, (Object)binaryImage.getName());
            objectEncoderContext.add(UUID_DESCRIPTOR, (Object)binaryImage.getUuidUtf8Bytes());
        }
    }

    private static final class CrashlyticsReportSessionEventApplicationExecutionEncoder
    implements ObjectEncoder<CrashlyticsReport.Session.Event.Application.Execution> {
        private static final FieldDescriptor APPEXITINFO_DESCRIPTOR;
        private static final FieldDescriptor BINARIES_DESCRIPTOR;
        private static final FieldDescriptor EXCEPTION_DESCRIPTOR;
        static final CrashlyticsReportSessionEventApplicationExecutionEncoder INSTANCE;
        private static final FieldDescriptor SIGNAL_DESCRIPTOR;
        private static final FieldDescriptor THREADS_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportSessionEventApplicationExecutionEncoder();
            THREADS_DESCRIPTOR = FieldDescriptor.of("threads");
            EXCEPTION_DESCRIPTOR = FieldDescriptor.of("exception");
            APPEXITINFO_DESCRIPTOR = FieldDescriptor.of("appExitInfo");
            SIGNAL_DESCRIPTOR = FieldDescriptor.of("signal");
            BINARIES_DESCRIPTOR = FieldDescriptor.of("binaries");
        }

        private CrashlyticsReportSessionEventApplicationExecutionEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session.Event.Application.Execution execution, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(THREADS_DESCRIPTOR, execution.getThreads());
            objectEncoderContext.add(EXCEPTION_DESCRIPTOR, (Object)execution.getException());
            objectEncoderContext.add(APPEXITINFO_DESCRIPTOR, (Object)execution.getAppExitInfo());
            objectEncoderContext.add(SIGNAL_DESCRIPTOR, (Object)execution.getSignal());
            objectEncoderContext.add(BINARIES_DESCRIPTOR, execution.getBinaries());
        }
    }

    private static final class CrashlyticsReportSessionEventApplicationExecutionExceptionEncoder
    implements ObjectEncoder<CrashlyticsReport.Session.Event.Application.Execution.Exception> {
        private static final FieldDescriptor CAUSEDBY_DESCRIPTOR;
        private static final FieldDescriptor FRAMES_DESCRIPTOR;
        static final CrashlyticsReportSessionEventApplicationExecutionExceptionEncoder INSTANCE;
        private static final FieldDescriptor OVERFLOWCOUNT_DESCRIPTOR;
        private static final FieldDescriptor REASON_DESCRIPTOR;
        private static final FieldDescriptor TYPE_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportSessionEventApplicationExecutionExceptionEncoder();
            TYPE_DESCRIPTOR = FieldDescriptor.of("type");
            REASON_DESCRIPTOR = FieldDescriptor.of("reason");
            FRAMES_DESCRIPTOR = FieldDescriptor.of("frames");
            CAUSEDBY_DESCRIPTOR = FieldDescriptor.of("causedBy");
            OVERFLOWCOUNT_DESCRIPTOR = FieldDescriptor.of("overflowCount");
        }

        private CrashlyticsReportSessionEventApplicationExecutionExceptionEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session.Event.Application.Execution.Exception exception, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(TYPE_DESCRIPTOR, (Object)exception.getType());
            objectEncoderContext.add(REASON_DESCRIPTOR, (Object)exception.getReason());
            objectEncoderContext.add(FRAMES_DESCRIPTOR, exception.getFrames());
            objectEncoderContext.add(CAUSEDBY_DESCRIPTOR, (Object)exception.getCausedBy());
            objectEncoderContext.add(OVERFLOWCOUNT_DESCRIPTOR, exception.getOverflowCount());
        }
    }

    private static final class CrashlyticsReportSessionEventApplicationExecutionSignalEncoder
    implements ObjectEncoder<CrashlyticsReport.Session.Event.Application.Execution.Signal> {
        private static final FieldDescriptor ADDRESS_DESCRIPTOR;
        private static final FieldDescriptor CODE_DESCRIPTOR;
        static final CrashlyticsReportSessionEventApplicationExecutionSignalEncoder INSTANCE;
        private static final FieldDescriptor NAME_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportSessionEventApplicationExecutionSignalEncoder();
            NAME_DESCRIPTOR = FieldDescriptor.of("name");
            CODE_DESCRIPTOR = FieldDescriptor.of("code");
            ADDRESS_DESCRIPTOR = FieldDescriptor.of("address");
        }

        private CrashlyticsReportSessionEventApplicationExecutionSignalEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session.Event.Application.Execution.Signal signal, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(NAME_DESCRIPTOR, (Object)signal.getName());
            objectEncoderContext.add(CODE_DESCRIPTOR, (Object)signal.getCode());
            objectEncoderContext.add(ADDRESS_DESCRIPTOR, signal.getAddress());
        }
    }

    private static final class CrashlyticsReportSessionEventApplicationExecutionThreadEncoder
    implements ObjectEncoder<CrashlyticsReport.Session.Event.Application.Execution.Thread> {
        private static final FieldDescriptor FRAMES_DESCRIPTOR;
        private static final FieldDescriptor IMPORTANCE_DESCRIPTOR;
        static final CrashlyticsReportSessionEventApplicationExecutionThreadEncoder INSTANCE;
        private static final FieldDescriptor NAME_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportSessionEventApplicationExecutionThreadEncoder();
            NAME_DESCRIPTOR = FieldDescriptor.of("name");
            IMPORTANCE_DESCRIPTOR = FieldDescriptor.of("importance");
            FRAMES_DESCRIPTOR = FieldDescriptor.of("frames");
        }

        private CrashlyticsReportSessionEventApplicationExecutionThreadEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session.Event.Application.Execution.Thread thread2, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(NAME_DESCRIPTOR, (Object)thread2.getName());
            objectEncoderContext.add(IMPORTANCE_DESCRIPTOR, thread2.getImportance());
            objectEncoderContext.add(FRAMES_DESCRIPTOR, thread2.getFrames());
        }
    }

    private static final class CrashlyticsReportSessionEventApplicationExecutionThreadFrameEncoder
    implements ObjectEncoder<CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame> {
        private static final FieldDescriptor FILE_DESCRIPTOR;
        private static final FieldDescriptor IMPORTANCE_DESCRIPTOR;
        static final CrashlyticsReportSessionEventApplicationExecutionThreadFrameEncoder INSTANCE;
        private static final FieldDescriptor OFFSET_DESCRIPTOR;
        private static final FieldDescriptor PC_DESCRIPTOR;
        private static final FieldDescriptor SYMBOL_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportSessionEventApplicationExecutionThreadFrameEncoder();
            PC_DESCRIPTOR = FieldDescriptor.of("pc");
            SYMBOL_DESCRIPTOR = FieldDescriptor.of("symbol");
            FILE_DESCRIPTOR = FieldDescriptor.of("file");
            OFFSET_DESCRIPTOR = FieldDescriptor.of("offset");
            IMPORTANCE_DESCRIPTOR = FieldDescriptor.of("importance");
        }

        private CrashlyticsReportSessionEventApplicationExecutionThreadFrameEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame frame, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(PC_DESCRIPTOR, frame.getPc());
            objectEncoderContext.add(SYMBOL_DESCRIPTOR, (Object)frame.getSymbol());
            objectEncoderContext.add(FILE_DESCRIPTOR, (Object)frame.getFile());
            objectEncoderContext.add(OFFSET_DESCRIPTOR, frame.getOffset());
            objectEncoderContext.add(IMPORTANCE_DESCRIPTOR, frame.getImportance());
        }
    }

    private static final class CrashlyticsReportSessionEventDeviceEncoder
    implements ObjectEncoder<CrashlyticsReport.Session.Event.Device> {
        private static final FieldDescriptor BATTERYLEVEL_DESCRIPTOR;
        private static final FieldDescriptor BATTERYVELOCITY_DESCRIPTOR;
        private static final FieldDescriptor DISKUSED_DESCRIPTOR;
        static final CrashlyticsReportSessionEventDeviceEncoder INSTANCE;
        private static final FieldDescriptor ORIENTATION_DESCRIPTOR;
        private static final FieldDescriptor PROXIMITYON_DESCRIPTOR;
        private static final FieldDescriptor RAMUSED_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportSessionEventDeviceEncoder();
            BATTERYLEVEL_DESCRIPTOR = FieldDescriptor.of("batteryLevel");
            BATTERYVELOCITY_DESCRIPTOR = FieldDescriptor.of("batteryVelocity");
            PROXIMITYON_DESCRIPTOR = FieldDescriptor.of("proximityOn");
            ORIENTATION_DESCRIPTOR = FieldDescriptor.of("orientation");
            RAMUSED_DESCRIPTOR = FieldDescriptor.of("ramUsed");
            DISKUSED_DESCRIPTOR = FieldDescriptor.of("diskUsed");
        }

        private CrashlyticsReportSessionEventDeviceEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session.Event.Device device, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(BATTERYLEVEL_DESCRIPTOR, (Object)device.getBatteryLevel());
            objectEncoderContext.add(BATTERYVELOCITY_DESCRIPTOR, device.getBatteryVelocity());
            objectEncoderContext.add(PROXIMITYON_DESCRIPTOR, device.isProximityOn());
            objectEncoderContext.add(ORIENTATION_DESCRIPTOR, device.getOrientation());
            objectEncoderContext.add(RAMUSED_DESCRIPTOR, device.getRamUsed());
            objectEncoderContext.add(DISKUSED_DESCRIPTOR, device.getDiskUsed());
        }
    }

    private static final class CrashlyticsReportSessionEventEncoder
    implements ObjectEncoder<CrashlyticsReport.Session.Event> {
        private static final FieldDescriptor APP_DESCRIPTOR;
        private static final FieldDescriptor DEVICE_DESCRIPTOR;
        static final CrashlyticsReportSessionEventEncoder INSTANCE;
        private static final FieldDescriptor LOG_DESCRIPTOR;
        private static final FieldDescriptor TIMESTAMP_DESCRIPTOR;
        private static final FieldDescriptor TYPE_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportSessionEventEncoder();
            TIMESTAMP_DESCRIPTOR = FieldDescriptor.of("timestamp");
            TYPE_DESCRIPTOR = FieldDescriptor.of("type");
            APP_DESCRIPTOR = FieldDescriptor.of("app");
            DEVICE_DESCRIPTOR = FieldDescriptor.of("device");
            LOG_DESCRIPTOR = FieldDescriptor.of("log");
        }

        private CrashlyticsReportSessionEventEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session.Event event, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(TIMESTAMP_DESCRIPTOR, event.getTimestamp());
            objectEncoderContext.add(TYPE_DESCRIPTOR, (Object)event.getType());
            objectEncoderContext.add(APP_DESCRIPTOR, (Object)event.getApp());
            objectEncoderContext.add(DEVICE_DESCRIPTOR, (Object)event.getDevice());
            objectEncoderContext.add(LOG_DESCRIPTOR, (Object)event.getLog());
        }
    }

    private static final class CrashlyticsReportSessionEventLogEncoder
    implements ObjectEncoder<CrashlyticsReport.Session.Event.Log> {
        private static final FieldDescriptor CONTENT_DESCRIPTOR;
        static final CrashlyticsReportSessionEventLogEncoder INSTANCE;

        static {
            INSTANCE = new CrashlyticsReportSessionEventLogEncoder();
            CONTENT_DESCRIPTOR = FieldDescriptor.of("content");
        }

        private CrashlyticsReportSessionEventLogEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session.Event.Log log, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(CONTENT_DESCRIPTOR, (Object)log.getContent());
        }
    }

    private static final class CrashlyticsReportSessionOperatingSystemEncoder
    implements ObjectEncoder<CrashlyticsReport.Session.OperatingSystem> {
        private static final FieldDescriptor BUILDVERSION_DESCRIPTOR;
        static final CrashlyticsReportSessionOperatingSystemEncoder INSTANCE;
        private static final FieldDescriptor JAILBROKEN_DESCRIPTOR;
        private static final FieldDescriptor PLATFORM_DESCRIPTOR;
        private static final FieldDescriptor VERSION_DESCRIPTOR;

        static {
            INSTANCE = new CrashlyticsReportSessionOperatingSystemEncoder();
            PLATFORM_DESCRIPTOR = FieldDescriptor.of("platform");
            VERSION_DESCRIPTOR = FieldDescriptor.of("version");
            BUILDVERSION_DESCRIPTOR = FieldDescriptor.of("buildVersion");
            JAILBROKEN_DESCRIPTOR = FieldDescriptor.of("jailbroken");
        }

        private CrashlyticsReportSessionOperatingSystemEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session.OperatingSystem operatingSystem, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(PLATFORM_DESCRIPTOR, operatingSystem.getPlatform());
            objectEncoderContext.add(VERSION_DESCRIPTOR, (Object)operatingSystem.getVersion());
            objectEncoderContext.add(BUILDVERSION_DESCRIPTOR, (Object)operatingSystem.getBuildVersion());
            objectEncoderContext.add(JAILBROKEN_DESCRIPTOR, operatingSystem.isJailbroken());
        }
    }

    private static final class CrashlyticsReportSessionUserEncoder
    implements ObjectEncoder<CrashlyticsReport.Session.User> {
        private static final FieldDescriptor IDENTIFIER_DESCRIPTOR;
        static final CrashlyticsReportSessionUserEncoder INSTANCE;

        static {
            INSTANCE = new CrashlyticsReportSessionUserEncoder();
            IDENTIFIER_DESCRIPTOR = FieldDescriptor.of("identifier");
        }

        private CrashlyticsReportSessionUserEncoder() {
        }

        @Override
        public void encode(CrashlyticsReport.Session.User user, ObjectEncoderContext objectEncoderContext) throws IOException {
            objectEncoderContext.add(IDENTIFIER_DESCRIPTOR, (Object)user.getIdentifier());
        }
    }
}

