/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.model;

import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_ApplicationExitInfo;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_CustomAttribute;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_FilesPayload;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_FilesPayload_File;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Application;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Application_Organization;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Device;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution_BinaryImage;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Exception;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Signal;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Thread;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Thread_Frame;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Device;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_Event_Log;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_OperatingSystem;
import com.google.firebase.crashlytics.internal.model.AutoValue_CrashlyticsReport_Session_User;
import com.google.firebase.crashlytics.internal.model.ImmutableList;
import com.google.firebase.encoders.annotations.Encodable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.Charset;

@Encodable
public abstract class CrashlyticsReport {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static Builder builder() {
        return new AutoValue_CrashlyticsReport.Builder();
    }

    public abstract String getBuildVersion();

    public abstract String getDisplayVersion();

    public abstract String getGmpAppId();

    public abstract String getInstallationUuid();

    public abstract FilesPayload getNdkPayload();

    public abstract int getPlatform();

    public abstract String getSdkVersion();

    public abstract Session getSession();

    @Encodable.Ignore
    public Type getType() {
        if (this.getSession() != null) {
            return Type.JAVA;
        }
        if (this.getNdkPayload() != null) {
            return Type.NATIVE;
        }
        return Type.INCOMPLETE;
    }

    protected abstract Builder toBuilder();

    public CrashlyticsReport withEvents(ImmutableList<Session.Event> immutableList) {
        if (this.getSession() != null) {
            return this.toBuilder().setSession(this.getSession().withEvents(immutableList)).build();
        }
        throw new IllegalStateException("Reports without sessions cannot have events added to them.");
    }

    public CrashlyticsReport withNdkPayload(FilesPayload filesPayload) {
        return this.toBuilder().setSession(null).setNdkPayload(filesPayload).build();
    }

    public CrashlyticsReport withOrganizationId(String string2) {
        Builder builder = this.toBuilder();
        Object object = this.getNdkPayload();
        if (object != null) {
            builder.setNdkPayload(((FilesPayload)object).toBuilder().setOrgId(string2).build());
        }
        if ((object = this.getSession()) != null) {
            builder.setSession(((Session)object).withOrganizationId(string2));
        }
        return builder.build();
    }

    public CrashlyticsReport withSessionEndFields(long l, boolean bl, String string2) {
        Builder builder = this.toBuilder();
        if (this.getSession() != null) {
            builder.setSession(this.getSession().withSessionEndFields(l, bl, string2));
        }
        return builder.build();
    }

    public static abstract class ApplicationExitInfo {
        public static Builder builder() {
            return new AutoValue_CrashlyticsReport_ApplicationExitInfo.Builder();
        }

        public abstract int getImportance();

        public abstract int getPid();

        public abstract String getProcessName();

        public abstract long getPss();

        public abstract int getReasonCode();

        public abstract long getRss();

        public abstract long getTimestamp();

        public abstract String getTraceFile();

        public static abstract class Builder {
            public abstract ApplicationExitInfo build();

            public abstract Builder setImportance(int var1);

            public abstract Builder setPid(int var1);

            public abstract Builder setProcessName(String var1);

            public abstract Builder setPss(long var1);

            public abstract Builder setReasonCode(int var1);

            public abstract Builder setRss(long var1);

            public abstract Builder setTimestamp(long var1);

            public abstract Builder setTraceFile(String var1);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Architecture {
        public static final int ARM64 = 9;
        public static final int ARMV6 = 5;
        public static final int ARMV7 = 6;
        public static final int UNKNOWN = 7;
        public static final int X86_32 = 0;
        public static final int X86_64 = 1;
    }

    public static abstract class Builder {
        public abstract CrashlyticsReport build();

        public abstract Builder setBuildVersion(String var1);

        public abstract Builder setDisplayVersion(String var1);

        public abstract Builder setGmpAppId(String var1);

        public abstract Builder setInstallationUuid(String var1);

        public abstract Builder setNdkPayload(FilesPayload var1);

        public abstract Builder setPlatform(int var1);

        public abstract Builder setSdkVersion(String var1);

        public abstract Builder setSession(Session var1);
    }

    public static abstract class CustomAttribute {
        public static Builder builder() {
            return new AutoValue_CrashlyticsReport_CustomAttribute.Builder();
        }

        public abstract String getKey();

        public abstract String getValue();

        public static abstract class Builder {
            public abstract CustomAttribute build();

            public abstract Builder setKey(String var1);

            public abstract Builder setValue(String var1);
        }
    }

    public static abstract class FilesPayload {
        public static Builder builder() {
            return new AutoValue_CrashlyticsReport_FilesPayload.Builder();
        }

        public abstract ImmutableList<File> getFiles();

        public abstract String getOrgId();

        abstract Builder toBuilder();

        public static abstract class Builder {
            public abstract FilesPayload build();

            public abstract Builder setFiles(ImmutableList<File> var1);

            public abstract Builder setOrgId(String var1);
        }

        public static abstract class File {
            public static Builder builder() {
                return new AutoValue_CrashlyticsReport_FilesPayload_File.Builder();
            }

            public abstract byte[] getContents();

            public abstract String getFilename();

            public static abstract class Builder {
                public abstract File build();

                public abstract Builder setContents(byte[] var1);

                public abstract Builder setFilename(String var1);
            }
        }
    }

    public static abstract class Session {
        public static Builder builder() {
            return new AutoValue_CrashlyticsReport_Session.Builder().setCrashed(false);
        }

        public abstract Application getApp();

        public abstract Device getDevice();

        public abstract Long getEndedAt();

        public abstract ImmutableList<Event> getEvents();

        public abstract String getGenerator();

        public abstract int getGeneratorType();

        @Encodable.Ignore
        public abstract String getIdentifier();

        @Encodable.Field(name="identifier")
        public byte[] getIdentifierUtf8Bytes() {
            return this.getIdentifier().getBytes(UTF_8);
        }

        public abstract OperatingSystem getOs();

        public abstract long getStartedAt();

        public abstract User getUser();

        public abstract boolean isCrashed();

        public abstract Builder toBuilder();

        Session withEvents(ImmutableList<Event> immutableList) {
            return this.toBuilder().setEvents(immutableList).build();
        }

        Session withOrganizationId(String object) {
            object = this.getApp().withOrganizationId((String)object);
            return this.toBuilder().setApp((Application)object).build();
        }

        Session withSessionEndFields(long l, boolean bl, String string2) {
            Builder builder = this.toBuilder();
            builder.setEndedAt(l);
            builder.setCrashed(bl);
            if (string2 != null) {
                builder.setUser(User.builder().setIdentifier(string2).build());
            }
            return builder.build();
        }

        public static abstract class Application {
            public static Builder builder() {
                return new AutoValue_CrashlyticsReport_Session_Application.Builder();
            }

            public abstract String getDevelopmentPlatform();

            public abstract String getDevelopmentPlatformVersion();

            public abstract String getDisplayVersion();

            public abstract String getIdentifier();

            public abstract String getInstallationUuid();

            public abstract Organization getOrganization();

            public abstract String getVersion();

            protected abstract Builder toBuilder();

            Application withOrganizationId(String string2) {
                Object object = this.getOrganization();
                object = object != null ? ((Organization)object).toBuilder() : Organization.builder();
                return this.toBuilder().setOrganization(((Organization.Builder)object).setClsId(string2).build()).build();
            }

            public static abstract class Builder {
                public abstract Application build();

                public abstract Builder setDevelopmentPlatform(String var1);

                public abstract Builder setDevelopmentPlatformVersion(String var1);

                public abstract Builder setDisplayVersion(String var1);

                public abstract Builder setIdentifier(String var1);

                public abstract Builder setInstallationUuid(String var1);

                public abstract Builder setOrganization(Organization var1);

                public abstract Builder setVersion(String var1);
            }

            public static abstract class Organization {
                public static Builder builder() {
                    return new AutoValue_CrashlyticsReport_Session_Application_Organization.Builder();
                }

                public abstract String getClsId();

                protected abstract Builder toBuilder();

                public static abstract class Builder {
                    public abstract Organization build();

                    public abstract Builder setClsId(String var1);
                }
            }
        }

        public static abstract class Builder {
            public abstract Session build();

            public abstract Builder setApp(Application var1);

            public abstract Builder setCrashed(boolean var1);

            public abstract Builder setDevice(Device var1);

            public abstract Builder setEndedAt(Long var1);

            public abstract Builder setEvents(ImmutableList<Event> var1);

            public abstract Builder setGenerator(String var1);

            public abstract Builder setGeneratorType(int var1);

            public abstract Builder setIdentifier(String var1);

            public Builder setIdentifierFromUtf8Bytes(byte[] byArray) {
                return this.setIdentifier(new String(byArray, UTF_8));
            }

            public abstract Builder setOs(OperatingSystem var1);

            public abstract Builder setStartedAt(long var1);

            public abstract Builder setUser(User var1);
        }

        public static abstract class Device {
            public static Builder builder() {
                return new AutoValue_CrashlyticsReport_Session_Device.Builder();
            }

            public abstract int getArch();

            public abstract int getCores();

            public abstract long getDiskSpace();

            public abstract String getManufacturer();

            public abstract String getModel();

            public abstract String getModelClass();

            public abstract long getRam();

            public abstract int getState();

            public abstract boolean isSimulator();

            public static abstract class Builder {
                public abstract Device build();

                public abstract Builder setArch(int var1);

                public abstract Builder setCores(int var1);

                public abstract Builder setDiskSpace(long var1);

                public abstract Builder setManufacturer(String var1);

                public abstract Builder setModel(String var1);

                public abstract Builder setModelClass(String var1);

                public abstract Builder setRam(long var1);

                public abstract Builder setSimulator(boolean var1);

                public abstract Builder setState(int var1);
            }
        }

        public static abstract class Event {
            public static Builder builder() {
                return new AutoValue_CrashlyticsReport_Session_Event.Builder();
            }

            public abstract Application getApp();

            public abstract Device getDevice();

            public abstract Log getLog();

            public abstract long getTimestamp();

            public abstract String getType();

            public abstract Builder toBuilder();

            public static abstract class Application {
                public static Builder builder() {
                    return new AutoValue_CrashlyticsReport_Session_Event_Application.Builder();
                }

                public abstract Boolean getBackground();

                public abstract ImmutableList<CustomAttribute> getCustomAttributes();

                public abstract Execution getExecution();

                public abstract ImmutableList<CustomAttribute> getInternalKeys();

                public abstract int getUiOrientation();

                public abstract Builder toBuilder();

                public static abstract class Builder {
                    public abstract Application build();

                    public abstract Builder setBackground(Boolean var1);

                    public abstract Builder setCustomAttributes(ImmutableList<CustomAttribute> var1);

                    public abstract Builder setExecution(Execution var1);

                    public abstract Builder setInternalKeys(ImmutableList<CustomAttribute> var1);

                    public abstract Builder setUiOrientation(int var1);
                }

                public static abstract class Execution {
                    public static Builder builder() {
                        return new AutoValue_CrashlyticsReport_Session_Event_Application_Execution.Builder();
                    }

                    public abstract ApplicationExitInfo getAppExitInfo();

                    public abstract ImmutableList<BinaryImage> getBinaries();

                    public abstract Exception getException();

                    public abstract Signal getSignal();

                    public abstract ImmutableList<Thread> getThreads();

                    public static abstract class BinaryImage {
                        public static Builder builder() {
                            return new AutoValue_CrashlyticsReport_Session_Event_Application_Execution_BinaryImage.Builder();
                        }

                        public abstract long getBaseAddress();

                        public abstract String getName();

                        public abstract long getSize();

                        @Encodable.Ignore
                        public abstract String getUuid();

                        @Encodable.Field(name="uuid")
                        public byte[] getUuidUtf8Bytes() {
                            Object object = this.getUuid();
                            object = object != null ? (Object)((String)object).getBytes(UTF_8) : null;
                            return object;
                        }

                        public static abstract class Builder {
                            public abstract BinaryImage build();

                            public abstract Builder setBaseAddress(long var1);

                            public abstract Builder setName(String var1);

                            public abstract Builder setSize(long var1);

                            public abstract Builder setUuid(String var1);

                            public Builder setUuidFromUtf8Bytes(byte[] byArray) {
                                return this.setUuid(new String(byArray, UTF_8));
                            }
                        }
                    }

                    public static abstract class Builder {
                        public abstract Execution build();

                        public abstract Builder setAppExitInfo(ApplicationExitInfo var1);

                        public abstract Builder setBinaries(ImmutableList<BinaryImage> var1);

                        public abstract Builder setException(Exception var1);

                        public abstract Builder setSignal(Signal var1);

                        public abstract Builder setThreads(ImmutableList<Thread> var1);
                    }

                    public static abstract class Exception {
                        public static Builder builder() {
                            return new AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Exception.Builder();
                        }

                        public abstract Exception getCausedBy();

                        public abstract ImmutableList<Thread.Frame> getFrames();

                        public abstract int getOverflowCount();

                        public abstract String getReason();

                        public abstract String getType();

                        public static abstract class Builder {
                            public abstract Exception build();

                            public abstract Builder setCausedBy(Exception var1);

                            public abstract Builder setFrames(ImmutableList<Thread.Frame> var1);

                            public abstract Builder setOverflowCount(int var1);

                            public abstract Builder setReason(String var1);

                            public abstract Builder setType(String var1);
                        }
                    }

                    public static abstract class Signal {
                        public static Builder builder() {
                            return new AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Signal.Builder();
                        }

                        public abstract long getAddress();

                        public abstract String getCode();

                        public abstract String getName();

                        public static abstract class Builder {
                            public abstract Signal build();

                            public abstract Builder setAddress(long var1);

                            public abstract Builder setCode(String var1);

                            public abstract Builder setName(String var1);
                        }
                    }

                    public static abstract class Thread {
                        public static Builder builder() {
                            return new AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Thread.Builder();
                        }

                        public abstract ImmutableList<Frame> getFrames();

                        public abstract int getImportance();

                        public abstract String getName();

                        public static abstract class Builder {
                            public abstract Thread build();

                            public abstract Builder setFrames(ImmutableList<Frame> var1);

                            public abstract Builder setImportance(int var1);

                            public abstract Builder setName(String var1);
                        }

                        public static abstract class Frame {
                            public static Builder builder() {
                                return new AutoValue_CrashlyticsReport_Session_Event_Application_Execution_Thread_Frame.Builder();
                            }

                            public abstract String getFile();

                            public abstract int getImportance();

                            public abstract long getOffset();

                            public abstract long getPc();

                            public abstract String getSymbol();

                            public static abstract class Builder {
                                public abstract Frame build();

                                public abstract Builder setFile(String var1);

                                public abstract Builder setImportance(int var1);

                                public abstract Builder setOffset(long var1);

                                public abstract Builder setPc(long var1);

                                public abstract Builder setSymbol(String var1);
                            }
                        }
                    }
                }
            }

            public static abstract class Builder {
                public abstract Event build();

                public abstract Builder setApp(Application var1);

                public abstract Builder setDevice(Device var1);

                public abstract Builder setLog(Log var1);

                public abstract Builder setTimestamp(long var1);

                public abstract Builder setType(String var1);
            }

            public static abstract class Device {
                public static Builder builder() {
                    return new AutoValue_CrashlyticsReport_Session_Event_Device.Builder();
                }

                public abstract Double getBatteryLevel();

                public abstract int getBatteryVelocity();

                public abstract long getDiskUsed();

                public abstract int getOrientation();

                public abstract long getRamUsed();

                public abstract boolean isProximityOn();

                public static abstract class Builder {
                    public abstract Device build();

                    public abstract Builder setBatteryLevel(Double var1);

                    public abstract Builder setBatteryVelocity(int var1);

                    public abstract Builder setDiskUsed(long var1);

                    public abstract Builder setOrientation(int var1);

                    public abstract Builder setProximityOn(boolean var1);

                    public abstract Builder setRamUsed(long var1);
                }
            }

            public static abstract class Log {
                public static Builder builder() {
                    return new AutoValue_CrashlyticsReport_Session_Event_Log.Builder();
                }

                public abstract String getContent();

                public static abstract class Builder {
                    public abstract Log build();

                    public abstract Builder setContent(String var1);
                }
            }
        }

        public static abstract class OperatingSystem {
            public static Builder builder() {
                return new AutoValue_CrashlyticsReport_Session_OperatingSystem.Builder();
            }

            public abstract String getBuildVersion();

            public abstract int getPlatform();

            public abstract String getVersion();

            public abstract boolean isJailbroken();

            public static abstract class Builder {
                public abstract OperatingSystem build();

                public abstract Builder setBuildVersion(String var1);

                public abstract Builder setJailbroken(boolean var1);

                public abstract Builder setPlatform(int var1);

                public abstract Builder setVersion(String var1);
            }
        }

        public static abstract class User {
            public static Builder builder() {
                return new AutoValue_CrashlyticsReport_Session_User.Builder();
            }

            public abstract String getIdentifier();

            public static abstract class Builder {
                public abstract User build();

                public abstract Builder setIdentifier(String var1);
            }
        }
    }

    public static final class Type
    extends Enum<Type> {
        private static final /* synthetic */ Type[] $VALUES;
        public static final /* enum */ Type INCOMPLETE;
        public static final /* enum */ Type JAVA;
        public static final /* enum */ Type NATIVE;

        static {
            Type type;
            Type type2;
            Type type3;
            INCOMPLETE = type3 = new Type();
            JAVA = type2 = new Type();
            NATIVE = type = new Type();
            $VALUES = new Type[]{type3, type2, type};
        }

        public static Type valueOf(String string2) {
            return Enum.valueOf(Type.class, string2);
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }
    }
}

