/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.persistence;

import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CrashlyticsReportWithSessionId;
import com.google.firebase.crashlytics.internal.metadata.UserMetadata;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.ImmutableList;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$ExternalSyntheticLambda0;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$ExternalSyntheticLambda1;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$ExternalSyntheticLambda2;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$ExternalSyntheticLambda3;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import com.google.firebase.crashlytics.internal.settings.SettingsProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CrashlyticsReportPersistence {
    private static final String EVENT_COUNTER_FORMAT = "%010d";
    private static final int EVENT_COUNTER_WIDTH = 10;
    private static final FilenameFilter EVENT_FILE_FILTER;
    private static final String EVENT_FILE_NAME_PREFIX = "event";
    private static final int EVENT_NAME_LENGTH;
    private static final Comparator<? super File> LATEST_SESSION_ID_FIRST_COMPARATOR;
    private static final int MAX_OPEN_SESSIONS = 8;
    private static final String NORMAL_EVENT_SUFFIX = "";
    private static final String PRIORITY_EVENT_SUFFIX = "_";
    private static final String REPORT_FILE_NAME = "report";
    private static final String SESSION_START_TIMESTAMP_FILE_NAME = "start-time";
    private static final CrashlyticsReportJsonTransform TRANSFORM;
    private static final Charset UTF_8;
    private final AtomicInteger eventCounter = new AtomicInteger(0);
    private final FileStore fileStore;
    private final SettingsProvider settingsProvider;

    public static /* synthetic */ boolean $r8$lambda$JFU0vij0Pn952vNT34mb4Hr_UXo(File file, String string2) {
        return CrashlyticsReportPersistence.isNormalPriorityEventFile(file, string2);
    }

    public static /* synthetic */ int $r8$lambda$n3pLmsPsV-a9XZY5T7lAH7PN0HQ(File file, File file2) {
        return CrashlyticsReportPersistence.oldestEventFileFirst(file, file2);
    }

    static {
        UTF_8 = Charset.forName("UTF-8");
        EVENT_NAME_LENGTH = 15;
        TRANSFORM = new CrashlyticsReportJsonTransform();
        LATEST_SESSION_ID_FIRST_COMPARATOR = CrashlyticsReportPersistence$$ExternalSyntheticLambda3.INSTANCE;
        EVENT_FILE_FILTER = CrashlyticsReportPersistence$$ExternalSyntheticLambda1.INSTANCE;
    }

    public CrashlyticsReportPersistence(FileStore fileStore, SettingsProvider settingsProvider) {
        this.fileStore = fileStore;
        this.settingsProvider = settingsProvider;
    }

    private SortedSet<String> capAndGetOpenSessions(String charSequence) {
        this.fileStore.cleanupPreviousFileSystems();
        SortedSet<String> sortedSet = this.getOpenSessionIds();
        if (charSequence != null) {
            sortedSet.remove(charSequence);
        }
        if (sortedSet.size() <= 8) {
            return sortedSet;
        }
        while (sortedSet.size() > 8) {
            String string2 = sortedSet.last();
            Logger logger = Logger.getLogger();
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Removing session over cap: ");
            ((StringBuilder)charSequence).append(string2);
            logger.d(((StringBuilder)charSequence).toString());
            this.fileStore.deleteSessionFiles(string2);
            sortedSet.remove(string2);
        }
        return sortedSet;
    }

    private static int capFilesCount(List<File> object, int n) {
        int n2 = object.size();
        Iterator<File> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            if (n2 <= n) {
                return n2;
            }
            FileStore.recursiveDelete((File)object);
            --n2;
        }
        return n2;
    }

    private void capFinalizedReports() {
        int n = this.settingsProvider.getSettingsSync().sessionData.maxCompleteSessionsCount;
        List<File> list = this.getAllFinalizedReportFiles();
        int n2 = list.size();
        if (n2 <= n) {
            return;
        }
        list = list.subList(n, n2).iterator();
        while (list.hasNext()) {
            ((File)list.next()).delete();
        }
    }

    private static long convertTimestampFromSecondsToMs(long l) {
        return l * 1000L;
    }

    private void deleteFiles(List<File> object) {
        object = object.iterator();
        while (object.hasNext()) {
            ((File)object.next()).delete();
        }
    }

    private static String generateEventFilename(int n, boolean bl) {
        String string2 = String.format(Locale.US, EVENT_COUNTER_FORMAT, n);
        String string3 = bl ? PRIORITY_EVENT_SUFFIX : NORMAL_EVENT_SUFFIX;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(EVENT_FILE_NAME_PREFIX);
        stringBuilder.append(string2);
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    private List<File> getAllFinalizedReportFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.addAll(this.fileStore.getPriorityReports());
        arrayList.addAll(this.fileStore.getNativeReports());
        Comparator<? super File> comparator = LATEST_SESSION_ID_FIRST_COMPARATOR;
        Collections.sort(arrayList, comparator);
        List<File> list = this.fileStore.getReports();
        Collections.sort(list, comparator);
        arrayList.addAll(list);
        return arrayList;
    }

    private static String getEventNameWithoutPriority(String string2) {
        return string2.substring(0, EVENT_NAME_LENGTH);
    }

    private static boolean isHighPriorityEventFile(String string2) {
        boolean bl = string2.startsWith(EVENT_FILE_NAME_PREFIX) && string2.endsWith(PRIORITY_EVENT_SUFFIX);
        return bl;
    }

    private static boolean isNormalPriorityEventFile(File file, String string2) {
        boolean bl = string2.startsWith(EVENT_FILE_NAME_PREFIX) && !string2.endsWith(PRIORITY_EVENT_SUFFIX);
        return bl;
    }

    static /* synthetic */ int lambda$static$0(File file, File file2) {
        return file2.getName().compareTo(file.getName());
    }

    static /* synthetic */ boolean lambda$static$1(File file, String string2) {
        return string2.startsWith(EVENT_FILE_NAME_PREFIX);
    }

    private static int oldestEventFileFirst(File file, File file2) {
        return CrashlyticsReportPersistence.getEventNameWithoutPriority(file.getName()).compareTo(CrashlyticsReportPersistence.getEventNameWithoutPriority(file2.getName()));
    }

    private static String readTextFile(File object) throws IOException {
        byte[] byArray = new byte[8192];
        Object object2 = new ByteArrayOutputStream();
        object = new FileInputStream((File)object);
        try {
            int n;
            while ((n = ((FileInputStream)object).read(byArray)) > 0) {
                ((ByteArrayOutputStream)object2).write(byArray, 0, n);
            }
            object2 = new String(((ByteArrayOutputStream)object2).toByteArray(), UTF_8);
            return object2;
        }
        finally {
            try {
                ((FileInputStream)object).close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    private void synthesizeNativeReportFile(File file, CrashlyticsReport.FilesPayload object, String string2) {
        try {
            CrashlyticsReportJsonTransform crashlyticsReportJsonTransform = TRANSFORM;
            object = crashlyticsReportJsonTransform.reportFromJson(CrashlyticsReportPersistence.readTextFile(file)).withNdkPayload((CrashlyticsReport.FilesPayload)object);
            CrashlyticsReportPersistence.writeTextFile(this.fileStore.getNativeReport(string2), crashlyticsReportJsonTransform.reportToJson((CrashlyticsReport)object));
        }
        catch (IOException iOException) {
            Logger logger = Logger.getLogger();
            object = new StringBuilder();
            ((StringBuilder)object).append("Could not synthesize final native report file for ");
            ((StringBuilder)object).append(file);
            logger.w(((StringBuilder)object).toString(), iOException);
        }
    }

    private void synthesizeReport(String string2, long l) {
        boolean bl;
        List<File> list = this.fileStore.getSessionFiles(string2, EVENT_FILE_FILTER);
        if (list.isEmpty()) {
            list = Logger.getLogger();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Session ");
            stringBuilder.append(string2);
            stringBuilder.append(" has no events.");
            ((Logger)((Object)list)).v(stringBuilder.toString());
            return;
        }
        Collections.sort(list);
        Object object = new ArrayList();
        Iterator iterator2 = list.iterator();
        block3: while (true) {
            bl = false;
            while (iterator2.hasNext()) {
                block7: {
                    File file = (File)iterator2.next();
                    try {
                        object.add(TRANSFORM.eventFromJson(CrashlyticsReportPersistence.readTextFile(file)));
                        if (bl) break block7;
                    }
                    catch (IOException iOException) {
                        Logger logger = Logger.getLogger();
                        list = new StringBuilder();
                        ((StringBuilder)((Object)list)).append("Could not add event to report for ");
                        ((StringBuilder)((Object)list)).append(file);
                        logger.w(((StringBuilder)((Object)list)).toString(), iOException);
                        continue;
                    }
                    boolean bl2 = CrashlyticsReportPersistence.isHighPriorityEventFile(file.getName());
                    if (!bl2) continue block3;
                }
                bl = true;
            }
            break;
        }
        if (object.isEmpty()) {
            object = Logger.getLogger();
            list = new StringBuilder();
            ((StringBuilder)((Object)list)).append("Could not parse event files for session ");
            ((StringBuilder)((Object)list)).append(string2);
            ((Logger)object).w(((StringBuilder)((Object)list)).toString());
            return;
        }
        list = UserMetadata.readUserId(string2, this.fileStore);
        this.synthesizeReportFile(this.fileStore.getSessionFile(string2, REPORT_FILE_NAME), (List<CrashlyticsReport.Session.Event>)object, l, bl, (String)((Object)list));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void synthesizeReportFile(File file, List<CrashlyticsReport.Session.Event> object, long l, boolean bl, String object2) {
        try {
            CrashlyticsReportJsonTransform crashlyticsReportJsonTransform = TRANSFORM;
            object2 = crashlyticsReportJsonTransform.reportFromJson(CrashlyticsReportPersistence.readTextFile(file)).withSessionEndFields(l, bl, (String)object2).withEvents(ImmutableList.from(object));
            object = ((CrashlyticsReport)object2).getSession();
            if (object == null) {
                return;
            }
            object = bl ? this.fileStore.getPriorityReport(((CrashlyticsReport.Session)object).getIdentifier()) : this.fileStore.getReport(((CrashlyticsReport.Session)object).getIdentifier());
            CrashlyticsReportPersistence.writeTextFile((File)object, crashlyticsReportJsonTransform.reportToJson((CrashlyticsReport)object2));
            return;
        }
        catch (IOException iOException) {
            object2 = Logger.getLogger();
            object = new StringBuilder();
            ((StringBuilder)object).append("Could not synthesize final report file for ");
            ((StringBuilder)object).append(file);
            ((Logger)object2).w(((StringBuilder)object).toString(), iOException);
        }
    }

    private int trimEvents(String object, int n) {
        object = this.fileStore.getSessionFiles((String)object, CrashlyticsReportPersistence$$ExternalSyntheticLambda0.INSTANCE);
        Collections.sort(object, CrashlyticsReportPersistence$$ExternalSyntheticLambda2.INSTANCE);
        return CrashlyticsReportPersistence.capFilesCount((List<File>)object, n);
    }

    private static void writeTextFile(File object, String string2) throws IOException {
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), UTF_8);
        try {
            ((Writer)object).write(string2);
            return;
        }
        finally {
            ((OutputStreamWriter)object).close();
        }
    }

    private static void writeTextFile(File file, String string2, long l) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF_8);
        try {
            outputStreamWriter.write(string2);
            file.setLastModified(CrashlyticsReportPersistence.convertTimestampFromSecondsToMs(l));
            return;
        }
        finally {
            outputStreamWriter.close();
        }
    }

    public void deleteAllReports() {
        this.deleteFiles(this.fileStore.getReports());
        this.deleteFiles(this.fileStore.getPriorityReports());
        this.deleteFiles(this.fileStore.getNativeReports());
    }

    public void finalizeReports(String object, long l) {
        for (String string2 : this.capAndGetOpenSessions((String)object)) {
            Logger logger = Logger.getLogger();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Finalizing report for session ");
            stringBuilder.append(string2);
            logger.v(stringBuilder.toString());
            this.synthesizeReport(string2, l);
            this.fileStore.deleteSessionFiles(string2);
        }
        this.capFinalizedReports();
    }

    public void finalizeSessionWithNativeEvent(String string2, CrashlyticsReport.FilesPayload filesPayload) {
        File file = this.fileStore.getSessionFile(string2, REPORT_FILE_NAME);
        Logger logger = Logger.getLogger();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Writing native session report for ");
        stringBuilder.append(string2);
        stringBuilder.append(" to file: ");
        stringBuilder.append(file);
        logger.d(stringBuilder.toString());
        this.synthesizeNativeReportFile(file, filesPayload, string2);
    }

    public SortedSet<String> getOpenSessionIds() {
        return new TreeSet<String>(this.fileStore.getAllOpenSessionIds()).descendingSet();
    }

    public long getStartTimestampMillis(String string2) {
        return this.fileStore.getSessionFile(string2, SESSION_START_TIMESTAMP_FILE_NAME).lastModified();
    }

    public boolean hasFinalizedReports() {
        boolean bl = !(this.fileStore.getReports().isEmpty() && this.fileStore.getPriorityReports().isEmpty() && this.fileStore.getNativeReports().isEmpty());
        return bl;
    }

    public List<CrashlyticsReportWithSessionId> loadFinalizedReports() {
        List<File> list = this.getAllFinalizedReportFiles();
        ArrayList<CrashlyticsReportWithSessionId> arrayList = new ArrayList<CrashlyticsReportWithSessionId>();
        for (File file : list) {
            try {
                arrayList.add(CrashlyticsReportWithSessionId.create(TRANSFORM.reportFromJson(CrashlyticsReportPersistence.readTextFile(file)), file.getName(), file));
            }
            catch (IOException iOException) {
                Logger logger = Logger.getLogger();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Could not load report file ");
                stringBuilder.append(file);
                stringBuilder.append("; deleting");
                logger.w(stringBuilder.toString(), iOException);
                file.delete();
            }
        }
        return arrayList;
    }

    public void persistEvent(CrashlyticsReport.Session.Event event, String string2) {
        this.persistEvent(event, string2, false);
    }

    public void persistEvent(CrashlyticsReport.Session.Event object, String string2, boolean bl) {
        int n = this.settingsProvider.getSettingsSync().sessionData.maxCustomExceptionEvents;
        String string3 = TRANSFORM.eventToJson((CrashlyticsReport.Session.Event)object);
        object = CrashlyticsReportPersistence.generateEventFilename(this.eventCounter.getAndIncrement(), bl);
        try {
            CrashlyticsReportPersistence.writeTextFile(this.fileStore.getSessionFile(string2, (String)object), string3);
        }
        catch (IOException iOException) {
            object = Logger.getLogger();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Could not persist event for session ");
            stringBuilder.append(string2);
            ((Logger)object).w(stringBuilder.toString(), iOException);
        }
        this.trimEvents(string2, n);
    }

    public void persistReport(CrashlyticsReport object) {
        CrashlyticsReport.Session session = ((CrashlyticsReport)object).getSession();
        if (session == null) {
            Logger.getLogger().d("Could not get session for report");
            return;
        }
        String string2 = session.getIdentifier();
        try {
            object = TRANSFORM.reportToJson((CrashlyticsReport)object);
            CrashlyticsReportPersistence.writeTextFile(this.fileStore.getSessionFile(string2, REPORT_FILE_NAME), (String)object);
            CrashlyticsReportPersistence.writeTextFile(this.fileStore.getSessionFile(string2, SESSION_START_TIMESTAMP_FILE_NAME), NORMAL_EVENT_SUFFIX, session.getStartedAt());
        }
        catch (IOException iOException) {
            Logger logger = Logger.getLogger();
            object = new StringBuilder();
            ((StringBuilder)object).append("Could not persist report for session ");
            ((StringBuilder)object).append(string2);
            logger.d(((StringBuilder)object).toString(), iOException);
        }
    }
}

