/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.persistence;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import com.google.firebase.crashlytics.internal.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FileStore {
    private static final String CRASHLYTICS_PATH_V1 = ".com.google.firebase.crashlytics.files.v1";
    private static final String CRASHLYTICS_PATH_V2 = ".com.google.firebase.crashlytics.files.v2";
    private static final String NATIVE_REPORTS_PATH = "native-reports";
    private static final String NATIVE_SESSION_SUBDIR = "native";
    private static final String PRIORITY_REPORTS_PATH = "priority-reports";
    private static final String REPORTS_PATH = "reports";
    private static final String SESSIONS_PATH = "open-sessions";
    private final File crashlyticsDir;
    private final File filesDir;
    private final File nativeReportsDir;
    private final File priorityReportsDir;
    private final File reportsDir;
    private final File sessionsDir;

    public FileStore(Context object) {
        File file;
        this.filesDir = file = object.getFilesDir();
        if (FileStore.useV2FileSystem()) {
            object = new StringBuilder();
            ((StringBuilder)object).append(CRASHLYTICS_PATH_V2);
            ((StringBuilder)object).append(File.pathSeparator);
            ((StringBuilder)object).append(FileStore.sanitizeName(Application.getProcessName()));
            object = ((StringBuilder)object).toString();
        } else {
            object = CRASHLYTICS_PATH_V1;
        }
        this.crashlyticsDir = object = FileStore.prepareBaseDir(new File(file, (String)object));
        this.sessionsDir = FileStore.prepareBaseDir(new File((File)object, SESSIONS_PATH));
        this.reportsDir = FileStore.prepareBaseDir(new File((File)object, REPORTS_PATH));
        this.priorityReportsDir = FileStore.prepareBaseDir(new File((File)object, PRIORITY_REPORTS_PATH));
        this.nativeReportsDir = FileStore.prepareBaseDir(new File((File)object, NATIVE_REPORTS_PATH));
    }

    private void cleanupDir(File file) {
        if (file.exists() && FileStore.recursiveDelete(file)) {
            Logger logger = Logger.getLogger();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Deleted previous Crashlytics file system: ");
            stringBuilder.append(file.getPath());
            logger.d(stringBuilder.toString());
        }
    }

    private File getSessionDir(String string2) {
        return FileStore.prepareDir(new File(this.sessionsDir, string2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File prepareBaseDir(File file) {
        synchronized (FileStore.class) {
            Object object;
            Object object2;
            if (file.exists()) {
                boolean bl = file.isDirectory();
                if (bl) {
                    return file;
                }
                object2 = Logger.getLogger();
                object = new StringBuilder();
                ((StringBuilder)object).append("Unexpected non-directory file: ");
                ((StringBuilder)object).append(file);
                ((StringBuilder)object).append("; deleting file and creating new directory.");
                ((Logger)object2).d(((StringBuilder)object).toString());
                file.delete();
            }
            if (!file.mkdirs()) {
                object = Logger.getLogger();
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Could not create Crashlytics-specific directory: ");
                ((StringBuilder)object2).append(file);
                ((Logger)object).e(((StringBuilder)object2).toString());
            }
            return file;
        }
    }

    private static File prepareDir(File file) {
        file.mkdirs();
        return file;
    }

    static boolean recursiveDelete(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                FileStore.recursiveDelete(fileArray[i]);
            }
        }
        return file.delete();
    }

    private static <T> List<T> safeArrayToList(T[] object) {
        object = object == null ? Collections.emptyList() : Arrays.asList(object);
        return object;
    }

    static String sanitizeName(String string2) {
        return string2.replaceAll("[^a-zA-Z0-9.]", "_");
    }

    private static boolean useV2FileSystem() {
        boolean bl = Build.VERSION.SDK_INT >= 28;
        return bl;
    }

    public void cleanupPreviousFileSystems() {
        this.cleanupDir(new File(this.filesDir, ".com.google.firebase.crashlytics"));
        this.cleanupDir(new File(this.filesDir, ".com.google.firebase.crashlytics-ndk"));
        if (FileStore.useV2FileSystem()) {
            this.cleanupDir(new File(this.filesDir, CRASHLYTICS_PATH_V1));
        }
    }

    public void deleteAllCrashlyticsFiles() {
        FileStore.recursiveDelete(this.crashlyticsDir);
    }

    public boolean deleteSessionFiles(String string2) {
        return FileStore.recursiveDelete(new File(this.sessionsDir, string2));
    }

    public List<String> getAllOpenSessionIds() {
        return FileStore.safeArrayToList(this.sessionsDir.list());
    }

    public File getCommonFile(String string2) {
        return new File(this.crashlyticsDir, string2);
    }

    public List<File> getCommonFiles(FilenameFilter filenameFilter) {
        return FileStore.safeArrayToList(this.crashlyticsDir.listFiles(filenameFilter));
    }

    public File getNativeReport(String string2) {
        return new File(this.nativeReportsDir, string2);
    }

    public List<File> getNativeReports() {
        return FileStore.safeArrayToList(this.nativeReportsDir.listFiles());
    }

    public File getNativeSessionDir(String string2) {
        return FileStore.prepareDir(new File(this.getSessionDir(string2), NATIVE_SESSION_SUBDIR));
    }

    public File getPriorityReport(String string2) {
        return new File(this.priorityReportsDir, string2);
    }

    public List<File> getPriorityReports() {
        return FileStore.safeArrayToList(this.priorityReportsDir.listFiles());
    }

    public File getReport(String string2) {
        return new File(this.reportsDir, string2);
    }

    public List<File> getReports() {
        return FileStore.safeArrayToList(this.reportsDir.listFiles());
    }

    public File getSessionFile(String string2, String string3) {
        return new File(this.getSessionDir(string2), string3);
    }

    public List<File> getSessionFiles(String string2, FilenameFilter filenameFilter) {
        return FileStore.safeArrayToList(this.getSessionDir(string2).listFiles(filenameFilter));
    }
}

