/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.send;

import android.content.Context;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.Transformer;
import com.google.android.datatransport.cct.CCTDestination;
import com.google.android.datatransport.runtime.TransportRuntime;
import com.google.android.gms.tasks.Task;
import com.google.firebase.crashlytics.internal.common.CrashlyticsReportWithSessionId;
import com.google.firebase.crashlytics.internal.common.OnDemandCounter;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform;
import com.google.firebase.crashlytics.internal.send.DataTransportCrashlyticsReportSender$$ExternalSyntheticLambda0;
import com.google.firebase.crashlytics.internal.send.ReportQueue;
import com.google.firebase.crashlytics.internal.settings.SettingsProvider;
import java.nio.charset.Charset;

public class DataTransportCrashlyticsReportSender {
    private static final String CRASHLYTICS_API_KEY;
    private static final String CRASHLYTICS_ENDPOINT;
    private static final String CRASHLYTICS_TRANSPORT_NAME = "FIREBASE_CRASHLYTICS_REPORT";
    private static final Transformer<CrashlyticsReport, byte[]> DEFAULT_TRANSFORM;
    private static final CrashlyticsReportJsonTransform TRANSFORM;
    private final ReportQueue reportQueue;
    private final Transformer<CrashlyticsReport, byte[]> transportTransform;

    static {
        TRANSFORM = new CrashlyticsReportJsonTransform();
        CRASHLYTICS_ENDPOINT = DataTransportCrashlyticsReportSender.mergeStrings("hts/cahyiseot-agolai.o/1frlglgc/aclg", "tp:/rsltcrprsp.ogepscmv/ieo/eaybtho");
        CRASHLYTICS_API_KEY = DataTransportCrashlyticsReportSender.mergeStrings("AzSBpY4F0rHiHFdinTvM", "IayrSTFL9eJ69YeSUO2");
        DEFAULT_TRANSFORM = DataTransportCrashlyticsReportSender$$ExternalSyntheticLambda0.INSTANCE;
    }

    DataTransportCrashlyticsReportSender(ReportQueue reportQueue, Transformer<CrashlyticsReport, byte[]> transformer) {
        this.reportQueue = reportQueue;
        this.transportTransform = transformer;
    }

    public static DataTransportCrashlyticsReportSender create(Context object, SettingsProvider settingsProvider, OnDemandCounter onDemandCounter) {
        TransportRuntime.initialize((Context)object);
        object = TransportRuntime.getInstance().newFactory(new CCTDestination(CRASHLYTICS_ENDPOINT, CRASHLYTICS_API_KEY));
        Encoding encoding = Encoding.of("json");
        Transformer<CrashlyticsReport, byte[]> transformer = DEFAULT_TRANSFORM;
        return new DataTransportCrashlyticsReportSender(new ReportQueue(object.getTransport(CRASHLYTICS_TRANSPORT_NAME, CrashlyticsReport.class, encoding, transformer), settingsProvider.getSettingsSync(), onDemandCounter), transformer);
    }

    static /* synthetic */ byte[] lambda$static$0(CrashlyticsReport crashlyticsReport) {
        return TRANSFORM.reportToJson(crashlyticsReport).getBytes(Charset.forName("UTF-8"));
    }

    private static String mergeStrings(String string2, String string3) {
        int n = string2.length() - string3.length();
        if (n >= 0 && n <= 1) {
            StringBuilder stringBuilder = new StringBuilder(string2.length() + string3.length());
            for (n = 0; n < string2.length(); ++n) {
                stringBuilder.append(string2.charAt(n));
                if (string3.length() <= n) continue;
                stringBuilder.append(string3.charAt(n));
            }
            return stringBuilder.toString();
        }
        throw new IllegalArgumentException("Invalid input received");
    }

    public Task<CrashlyticsReportWithSessionId> enqueueReport(CrashlyticsReportWithSessionId crashlyticsReportWithSessionId, boolean bl) {
        return this.reportQueue.enqueueReport(crashlyticsReportWithSessionId, bl).getTask();
    }
}

