/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.send;

import com.google.android.datatransport.Event;
import com.google.android.datatransport.Transport;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CrashlyticsReportWithSessionId;
import com.google.firebase.crashlytics.internal.common.OnDemandCounter;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.send.ReportQueue$$ExternalSyntheticLambda0;
import com.google.firebase.crashlytics.internal.settings.Settings;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class ReportQueue {
    private static final int MAX_DELAY_MS = 3600000;
    private static final int MS_PER_MINUTE = 60000;
    private static final int MS_PER_SECOND = 1000;
    private final double base;
    private long lastUpdatedMs;
    private final OnDemandCounter onDemandCounter;
    private final BlockingQueue<Runnable> queue;
    private final int queueCapacity;
    private final double ratePerMinute;
    private final ThreadPoolExecutor singleThreadExecutor;
    private int step;
    private final long stepDurationMs;
    private final Transport<CrashlyticsReport> transport;

    ReportQueue(double d, double d2, long l, Transport<CrashlyticsReport> object, OnDemandCounter onDemandCounter) {
        int n;
        this.ratePerMinute = d;
        this.base = d2;
        this.stepDurationMs = l;
        this.transport = object;
        this.onDemandCounter = onDemandCounter;
        this.queueCapacity = n = (int)d;
        this.queue = object = new ArrayBlockingQueue(n);
        this.singleThreadExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)object);
        this.step = 0;
        this.lastUpdatedMs = 0L;
    }

    ReportQueue(Transport<CrashlyticsReport> transport, Settings settings, OnDemandCounter onDemandCounter) {
        this(settings.onDemandUploadRatePerMinute, settings.onDemandBackoffBase, (long)settings.onDemandBackoffStepDurationSeconds * 1000L, transport, onDemandCounter);
    }

    private double calcDelay() {
        return Math.min(3600000.0, 60000.0 / this.ratePerMinute * Math.pow(this.base, this.calcStep()));
    }

    private int calcStep() {
        if (this.lastUpdatedMs == 0L) {
            this.lastUpdatedMs = this.now();
        }
        int n = (int)((this.now() - this.lastUpdatedMs) / this.stepDurationMs);
        n = this.isQueueFull() ? Math.min(100, this.step + n) : Math.max(0, this.step - n);
        if (this.step != n) {
            this.step = n;
            this.lastUpdatedMs = this.now();
        }
        return n;
    }

    private boolean isQueueAvailable() {
        boolean bl = this.queue.size() < this.queueCapacity;
        return bl;
    }

    private boolean isQueueFull() {
        boolean bl = this.queue.size() == this.queueCapacity;
        return bl;
    }

    static /* synthetic */ void lambda$sendReport$0(TaskCompletionSource taskCompletionSource, CrashlyticsReportWithSessionId crashlyticsReportWithSessionId, Exception exception) {
        if (exception != null) {
            taskCompletionSource.trySetException(exception);
            return;
        }
        taskCompletionSource.trySetResult(crashlyticsReportWithSessionId);
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private void sendReport(CrashlyticsReportWithSessionId crashlyticsReportWithSessionId, TaskCompletionSource<CrashlyticsReportWithSessionId> taskCompletionSource) {
        Logger logger = Logger.getLogger();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Sending report through Google DataTransport: ");
        stringBuilder.append(crashlyticsReportWithSessionId.getSessionId());
        logger.d(stringBuilder.toString());
        this.transport.schedule(Event.ofUrgent(crashlyticsReportWithSessionId.getReport()), new ReportQueue$$ExternalSyntheticLambda0(taskCompletionSource, crashlyticsReportWithSessionId));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void sleep(double d) {
        long l = (long)d;
        try {
            Thread.sleep(l);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TaskCompletionSource<CrashlyticsReportWithSessionId> enqueueReport(CrashlyticsReportWithSessionId crashlyticsReportWithSessionId, boolean bl) {
        BlockingQueue<Runnable> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            TaskCompletionSource<CrashlyticsReportWithSessionId> taskCompletionSource = new TaskCompletionSource<CrashlyticsReportWithSessionId>();
            if (!bl) {
                this.sendReport(crashlyticsReportWithSessionId, taskCompletionSource);
                return taskCompletionSource;
            }
            this.onDemandCounter.incrementRecordedOnDemandExceptions();
            if (this.isQueueAvailable()) {
                Object object = Logger.getLogger();
                Object object2 = new StringBuilder();
                ((StringBuilder)object2).append("Enqueueing report: ");
                ((StringBuilder)object2).append(crashlyticsReportWithSessionId.getSessionId());
                ((Logger)object).d(((StringBuilder)object2).toString());
                object2 = Logger.getLogger();
                object = new StringBuilder();
                ((StringBuilder)object).append("Queue size: ");
                ((StringBuilder)object).append(this.queue.size());
                ((Logger)object2).d(((StringBuilder)object).toString());
                object = this.singleThreadExecutor;
                object2 = new ReportRunnable(crashlyticsReportWithSessionId, taskCompletionSource);
                ((ThreadPoolExecutor)object).execute((Runnable)object2);
                object2 = Logger.getLogger();
                object = new StringBuilder();
                ((StringBuilder)object).append("Closing task for report: ");
                ((StringBuilder)object).append(crashlyticsReportWithSessionId.getSessionId());
                ((Logger)object2).d(((StringBuilder)object).toString());
                taskCompletionSource.trySetResult(crashlyticsReportWithSessionId);
                return taskCompletionSource;
            }
            this.calcStep();
            Logger logger = Logger.getLogger();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Dropping report due to queue being full: ");
            stringBuilder.append(crashlyticsReportWithSessionId.getSessionId());
            logger.d(stringBuilder.toString());
            this.onDemandCounter.incrementDroppedOnDemandExceptions();
            taskCompletionSource.trySetResult(crashlyticsReportWithSessionId);
            return taskCompletionSource;
        }
    }

    private final class ReportRunnable
    implements Runnable {
        private final CrashlyticsReportWithSessionId reportWithSessionId;
        private final TaskCompletionSource<CrashlyticsReportWithSessionId> tcs;

        private ReportRunnable(CrashlyticsReportWithSessionId crashlyticsReportWithSessionId, TaskCompletionSource<CrashlyticsReportWithSessionId> taskCompletionSource) {
            this.reportWithSessionId = crashlyticsReportWithSessionId;
            this.tcs = taskCompletionSource;
        }

        @Override
        public void run() {
            ReportQueue.this.sendReport(this.reportWithSessionId, this.tcs);
            ReportQueue.this.onDemandCounter.resetDroppedOnDemandExceptions();
            double d = ReportQueue.this.calcDelay();
            Logger logger = Logger.getLogger();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Delay for: ");
            stringBuilder.append(String.format(Locale.US, "%.2f", d / 1000.0));
            stringBuilder.append(" s for report: ");
            stringBuilder.append(this.reportWithSessionId.getSessionId());
            logger.d(stringBuilder.toString());
            ReportQueue.sleep(d);
        }
    }
}

