/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings;

import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.json.JSONObject;

public class CachedSettingsIo {
    private static final String SETTINGS_CACHE_FILENAME = "com.crashlytics.settings.json";
    private final File cachedSettingsFile;

    public CachedSettingsIo(FileStore fileStore) {
        this.cachedSettingsFile = fileStore.getCommonFile(SETTINGS_CACHE_FILENAME);
    }

    private File getSettingsFile() {
        return this.cachedSettingsFile;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject readCachedSettings() {
        void var4_10;
        FileInputStream fileInputStream;
        block13: {
            Object object;
            block14: {
                Object var1_1;
                block12: {
                    block11: {
                        block10: {
                            Logger.getLogger().d("Checking for cached settings...");
                            var1_1 = null;
                            fileInputStream = null;
                            File file = this.getSettingsFile();
                            if (!file.exists()) break block10;
                            object = new FileInputStream(file);
                            fileInputStream = object;
                            String string2 = CommonUtils.streamToString((InputStream)object);
                            fileInputStream = object;
                            fileInputStream = object;
                            try {
                                file = new JSONObject(string2);
                                fileInputStream = object;
                                object = file;
                                break block11;
                            }
                            catch (Exception exception) {
                                break block12;
                            }
                        }
                        try {
                            Logger.getLogger().v("Settings file does not exist.");
                            object = null;
                        }
                        catch (Throwable throwable) {
                            fileInputStream = null;
                            break block13;
                        }
                        catch (Exception exception) {
                            object = null;
                        }
                    }
                    CommonUtils.closeOrLog(fileInputStream, "Error while closing settings cache file.");
                    break block14;
                }
                fileInputStream = object;
                try {
                    void var3_6;
                    Logger.getLogger().e("Failed to fetch cached settings", (Throwable)var3_6);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                CommonUtils.closeOrLog((Closeable)object, "Error while closing settings cache file.");
                object = var1_1;
            }
            return object;
        }
        CommonUtils.closeOrLog(fileInputStream, "Error while closing settings cache file.");
        throw var4_10;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeCachedSettings(long l, JSONObject object) {
        void var3_5;
        Object object2;
        block7: {
            Object object3;
            block8: {
                JSONObject jSONObject;
                Logger.getLogger().v("Writing settings to cache file...");
                if (object == null) return;
                Object var4_6 = null;
                object2 = jSONObject = null;
                try {
                    object.put("expires_at", l);
                    object2 = jSONObject;
                    object2 = jSONObject;
                    object3 = new FileWriter(this.getSettingsFile());
                }
                catch (Throwable throwable) {
                    break block7;
                }
                catch (Exception exception) {
                    object = var4_6;
                    break block8;
                }
                try {
                    ((Writer)object3).write(object.toString());
                    ((OutputStreamWriter)object3).flush();
                }
                catch (Throwable throwable) {
                    object2 = object3;
                    break block7;
                }
                catch (Exception exception) {
                    object = object3;
                    object3 = exception;
                    break block8;
                }
                CommonUtils.closeOrLog((Closeable)object3, "Failed to close settings writer.");
                return;
            }
            object2 = object;
            {
                Logger.getLogger().e("Failed to cache settings", (Throwable)object3);
            }
            CommonUtils.closeOrLog((Closeable)object, "Failed to close settings writer.");
            return;
        }
        CommonUtils.closeOrLog(object2, "Failed to close settings writer.");
        throw var3_5;
    }
}

