/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings;

import com.google.firebase.crashlytics.internal.common.CurrentTimeProvider;
import com.google.firebase.crashlytics.internal.settings.Settings;
import com.google.firebase.crashlytics.internal.settings.SettingsJsonTransform;
import org.json.JSONException;
import org.json.JSONObject;

class SettingsV3JsonTransform
implements SettingsJsonTransform {
    SettingsV3JsonTransform() {
    }

    private static Settings.FeatureFlagData buildFeatureFlagDataFrom(JSONObject jSONObject) {
        return new Settings.FeatureFlagData(jSONObject.optBoolean("collect_reports", true), jSONObject.optBoolean("collect_anrs", false));
    }

    private static Settings.SessionData buildSessionDataFrom(JSONObject jSONObject) {
        return new Settings.SessionData(jSONObject.optInt("max_custom_exception_events", 8), 4);
    }

    private static long getExpiresAtFrom(CurrentTimeProvider currentTimeProvider, long l, JSONObject jSONObject) {
        l = jSONObject.has("expires_at") ? jSONObject.optLong("expires_at") : currentTimeProvider.getCurrentTimeMillis() + l * 1000L;
        return l;
    }

    @Override
    public Settings buildFromJson(CurrentTimeProvider currentTimeProvider, JSONObject jSONObject) throws JSONException {
        int n = jSONObject.optInt("settings_version", 0);
        int n2 = jSONObject.optInt("cache_duration", 3600);
        double d = jSONObject.optDouble("on_demand_upload_rate_per_minute", 10.0);
        double d2 = jSONObject.optDouble("on_demand_backoff_base", 1.2);
        int n3 = jSONObject.optInt("on_demand_backoff_step_duration_seconds", 60);
        Settings.SessionData sessionData = jSONObject.has("session") ? SettingsV3JsonTransform.buildSessionDataFrom(jSONObject.getJSONObject("session")) : SettingsV3JsonTransform.buildSessionDataFrom(new JSONObject());
        Settings.FeatureFlagData featureFlagData = SettingsV3JsonTransform.buildFeatureFlagDataFrom(jSONObject.getJSONObject("features"));
        return new Settings(SettingsV3JsonTransform.getExpiresAtFrom(currentTimeProvider, n2, jSONObject), sessionData, featureFlagData, n, n2, d, d2, n3);
    }
}

