/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders.json;

import android.util.Base64;
import android.util.JsonWriter;
import com.google.firebase.encoders.Encoder;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.FieldDescriptor;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.encoders.ValueEncoder;
import com.google.firebase.encoders.ValueEncoderContext;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

final class JsonValueObjectEncoderContext
implements ObjectEncoderContext,
ValueEncoderContext {
    private boolean active = true;
    private JsonValueObjectEncoderContext childContext = null;
    private final ObjectEncoder<Object> fallbackEncoder;
    private final boolean ignoreNullValues;
    private final JsonWriter jsonWriter;
    private final Map<Class<?>, ObjectEncoder<?>> objectEncoders;
    private final Map<Class<?>, ValueEncoder<?>> valueEncoders;

    private JsonValueObjectEncoderContext(JsonValueObjectEncoderContext jsonValueObjectEncoderContext) {
        this.jsonWriter = jsonValueObjectEncoderContext.jsonWriter;
        this.objectEncoders = jsonValueObjectEncoderContext.objectEncoders;
        this.valueEncoders = jsonValueObjectEncoderContext.valueEncoders;
        this.fallbackEncoder = jsonValueObjectEncoderContext.fallbackEncoder;
        this.ignoreNullValues = jsonValueObjectEncoderContext.ignoreNullValues;
    }

    JsonValueObjectEncoderContext(Writer writer, Map<Class<?>, ObjectEncoder<?>> map, Map<Class<?>, ValueEncoder<?>> map2, ObjectEncoder<Object> objectEncoder, boolean bl) {
        this.jsonWriter = new JsonWriter(writer);
        this.objectEncoders = map;
        this.valueEncoders = map2;
        this.fallbackEncoder = objectEncoder;
        this.ignoreNullValues = bl;
    }

    private boolean cannotBeInline(Object object) {
        boolean bl = object == null || object.getClass().isArray() || object instanceof Collection || object instanceof Date || object instanceof Enum || object instanceof Number;
        return bl;
    }

    private JsonValueObjectEncoderContext internalAdd(String string2, Object object) throws IOException, EncodingException {
        this.maybeUnNest();
        this.jsonWriter.name(string2);
        if (object == null) {
            this.jsonWriter.nullValue();
            return this;
        }
        return this.add(object, false);
    }

    private JsonValueObjectEncoderContext internalAddIgnoreNullValues(String string2, Object object) throws IOException, EncodingException {
        if (object == null) {
            return this;
        }
        this.maybeUnNest();
        this.jsonWriter.name(string2);
        return this.add(object, false);
    }

    private void maybeUnNest() throws IOException {
        if (this.active) {
            JsonValueObjectEncoderContext jsonValueObjectEncoderContext = this.childContext;
            if (jsonValueObjectEncoderContext != null) {
                jsonValueObjectEncoderContext.maybeUnNest();
                this.childContext.active = false;
                this.childContext = null;
                this.jsonWriter.endObject();
            }
            return;
        }
        throw new IllegalStateException("Parent context used since this context was created. Cannot use this context anymore.");
    }

    @Override
    public ObjectEncoderContext add(FieldDescriptor fieldDescriptor, double d) throws IOException {
        return this.add(fieldDescriptor.getName(), d);
    }

    @Override
    public ObjectEncoderContext add(FieldDescriptor fieldDescriptor, float f) throws IOException {
        return this.add(fieldDescriptor.getName(), (double)f);
    }

    @Override
    public ObjectEncoderContext add(FieldDescriptor fieldDescriptor, int n) throws IOException {
        return this.add(fieldDescriptor.getName(), n);
    }

    @Override
    public ObjectEncoderContext add(FieldDescriptor fieldDescriptor, long l) throws IOException {
        return this.add(fieldDescriptor.getName(), l);
    }

    @Override
    public ObjectEncoderContext add(FieldDescriptor fieldDescriptor, Object object) throws IOException {
        return this.add(fieldDescriptor.getName(), object);
    }

    @Override
    public ObjectEncoderContext add(FieldDescriptor fieldDescriptor, boolean bl) throws IOException {
        return this.add(fieldDescriptor.getName(), bl);
    }

    @Override
    public JsonValueObjectEncoderContext add(double d) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.value(d);
        return this;
    }

    @Override
    public JsonValueObjectEncoderContext add(float f) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.value((double)f);
        return this;
    }

    @Override
    public JsonValueObjectEncoderContext add(int n) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.value((long)n);
        return this;
    }

    @Override
    public JsonValueObjectEncoderContext add(long l) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.value(l);
        return this;
    }

    JsonValueObjectEncoderContext add(Object object, boolean object2) throws IOException {
        int n = 0;
        Object object3 = 0;
        int n2 = 0;
        if (object2 && this.cannotBeInline(object)) {
            object = object == null ? null : object.getClass();
            throw new EncodingException(String.format("%s cannot be encoded inline", object));
        }
        if (object == null) {
            this.jsonWriter.nullValue();
            return this;
        }
        if (object instanceof Number) {
            this.jsonWriter.value((Number)object);
            return this;
        }
        if (object.getClass().isArray()) {
            int n3;
            if (object instanceof byte[]) {
                return this.add((byte[])object);
            }
            this.jsonWriter.beginArray();
            if (object instanceof int[]) {
                object = (int[])object;
                n = ((Iterator<E>)object).length;
                for (n3 = 0; n3 < n; ++n3) {
                    object3 = object[n3];
                    this.jsonWriter.value((long)object3);
                }
            } else if (object instanceof long[]) {
                object = (long[])object;
                object3 = ((Object)object).length;
                for (n3 = n; n3 < object3; ++n3) {
                    this.add((long)object[n3]);
                }
            } else if (object instanceof double[]) {
                object = (double[])object;
                n = ((Object)object).length;
                for (n3 = object3; n3 < n; ++n3) {
                    Object object4 = object[n3];
                    this.jsonWriter.value((double)object4);
                }
            } else if (object instanceof boolean[]) {
                object = (boolean[])object;
                n = ((Object)object).length;
                for (n3 = n2; n3 < n; ++n3) {
                    object2 = object[n3];
                    this.jsonWriter.value(object2);
                }
            } else if (object instanceof Number[]) {
                object = (Number[])object;
                n = ((Object[])object).length;
                for (n3 = 0; n3 < n; ++n3) {
                    this.add(object[n3], false);
                }
            } else {
                object = (Object[])object;
                n = ((Object[])object).length;
                for (n3 = 0; n3 < n; ++n3) {
                    this.add(object[n3], false);
                }
            }
            this.jsonWriter.endArray();
            return this;
        }
        if (object instanceof Collection) {
            object = (Collection)object;
            this.jsonWriter.beginArray();
            object = object.iterator();
            while (object.hasNext()) {
                this.add(object.next(), false);
            }
            this.jsonWriter.endArray();
            return this;
        }
        if (object instanceof Map) {
            object = (Map)object;
            this.jsonWriter.beginObject();
            for (Map.Entry entry : object.entrySet()) {
                object = entry.getKey();
                try {
                    this.add((String)object, entry.getValue());
                }
                catch (ClassCastException classCastException) {
                    throw new EncodingException(String.format("Only String keys are currently supported in maps, got %s of type %s instead.", object, object.getClass()), classCastException);
                }
            }
            this.jsonWriter.endObject();
            return this;
        }
        Encoder encoder = this.objectEncoders.get(object.getClass());
        if (encoder != null) {
            return this.doEncode((ObjectEncoder<Object>)encoder, object, (boolean)object2);
        }
        encoder = this.valueEncoders.get(object.getClass());
        if (encoder != null) {
            encoder.encode(object, this);
            return this;
        }
        if (object instanceof Enum) {
            this.add(((Enum)object).name());
            return this;
        }
        return this.doEncode(this.fallbackEncoder, object, (boolean)object2);
    }

    @Override
    public JsonValueObjectEncoderContext add(String string2) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.value(string2);
        return this;
    }

    @Override
    public JsonValueObjectEncoderContext add(String string2, double d) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.name(string2);
        return this.add(d);
    }

    @Override
    public JsonValueObjectEncoderContext add(String string2, int n) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.name(string2);
        return this.add(n);
    }

    @Override
    public JsonValueObjectEncoderContext add(String string2, long l) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.name(string2);
        return this.add(l);
    }

    @Override
    public JsonValueObjectEncoderContext add(String string2, Object object) throws IOException {
        if (this.ignoreNullValues) {
            return this.internalAddIgnoreNullValues(string2, object);
        }
        return this.internalAdd(string2, object);
    }

    @Override
    public JsonValueObjectEncoderContext add(String string2, boolean bl) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.name(string2);
        return this.add(bl);
    }

    @Override
    public JsonValueObjectEncoderContext add(boolean bl) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.value(bl);
        return this;
    }

    @Override
    public JsonValueObjectEncoderContext add(byte[] byArray) throws IOException {
        this.maybeUnNest();
        if (byArray == null) {
            this.jsonWriter.nullValue();
        } else {
            this.jsonWriter.value(Base64.encodeToString((byte[])byArray, (int)2));
        }
        return this;
    }

    void close() throws IOException {
        this.maybeUnNest();
        this.jsonWriter.flush();
    }

    JsonValueObjectEncoderContext doEncode(ObjectEncoder<Object> objectEncoder, Object object, boolean bl) throws IOException {
        if (!bl) {
            this.jsonWriter.beginObject();
        }
        objectEncoder.encode(object, this);
        if (!bl) {
            this.jsonWriter.endObject();
        }
        return this;
    }

    @Override
    public ObjectEncoderContext inline(Object object) throws IOException {
        return this.add(object, true);
    }

    @Override
    public ObjectEncoderContext nested(FieldDescriptor fieldDescriptor) throws IOException {
        return this.nested(fieldDescriptor.getName());
    }

    @Override
    public ObjectEncoderContext nested(String string2) throws IOException {
        this.maybeUnNest();
        this.childContext = new JsonValueObjectEncoderContext(this);
        this.jsonWriter.name(string2);
        this.jsonWriter.beginObject();
        return this.childContext;
    }
}

