/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders.proto;

import java.io.OutputStream;

final class LengthCountingOutputStream
extends OutputStream {
    private long length = 0L;

    LengthCountingOutputStream() {
    }

    long getLength() {
        return this.length;
    }

    @Override
    public void write(int n) {
        ++this.length;
    }

    @Override
    public void write(byte[] byArray) {
        this.length += (long)byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (n >= 0 && n <= byArray.length && n2 >= 0 && (n += n2) <= byArray.length && n >= 0) {
            this.length += (long)n2;
            return;
        }
        throw new IndexOutOfBoundsException();
    }
}

