/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders.proto;

import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.FieldDescriptor;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.encoders.ValueEncoder;
import com.google.firebase.encoders.proto.AtProtobuf;
import com.google.firebase.encoders.proto.LengthCountingOutputStream;
import com.google.firebase.encoders.proto.ProtoEnum;
import com.google.firebase.encoders.proto.Protobuf;
import com.google.firebase.encoders.proto.ProtobufDataEncoderContext$$ExternalSyntheticLambda0;
import com.google.firebase.encoders.proto.ProtobufValueEncoderContext;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;

final class ProtobufDataEncoderContext
implements ObjectEncoderContext {
    private static final ObjectEncoder<Map.Entry<Object, Object>> DEFAULT_MAP_ENCODER;
    private static final FieldDescriptor MAP_KEY_DESC;
    private static final FieldDescriptor MAP_VALUE_DESC;
    private static final Charset UTF_8;
    private final ObjectEncoder<Object> fallbackEncoder;
    private final Map<Class<?>, ObjectEncoder<?>> objectEncoders;
    private OutputStream output;
    private final ProtobufValueEncoderContext valueEncoderContext = new ProtobufValueEncoderContext(this);
    private final Map<Class<?>, ValueEncoder<?>> valueEncoders;

    static {
        UTF_8 = Charset.forName("UTF-8");
        MAP_KEY_DESC = FieldDescriptor.builder("key").withProperty(AtProtobuf.builder().tag(1).build()).build();
        MAP_VALUE_DESC = FieldDescriptor.builder("value").withProperty(AtProtobuf.builder().tag(2).build()).build();
        DEFAULT_MAP_ENCODER = ProtobufDataEncoderContext$$ExternalSyntheticLambda0.INSTANCE;
    }

    ProtobufDataEncoderContext(OutputStream outputStream, Map<Class<?>, ObjectEncoder<?>> map, Map<Class<?>, ValueEncoder<?>> map2, ObjectEncoder<Object> objectEncoder) {
        this.output = outputStream;
        this.objectEncoders = map;
        this.valueEncoders = map2;
        this.fallbackEncoder = objectEncoder;
    }

    private static ByteBuffer allocateBuffer(int n) {
        return ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
    }

    /*
     * Loose catch block
     */
    private <T> long determineSize(ObjectEncoder<T> objectEncoder, T t) throws IOException {
        LengthCountingOutputStream lengthCountingOutputStream = new LengthCountingOutputStream();
        OutputStream outputStream = this.output;
        this.output = lengthCountingOutputStream;
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        try {
            objectEncoder.encode(t, this);
        }
        catch (Throwable throwable) {
            this.output = outputStream;
            throw throwable;
        }
        try {
            this.output = outputStream;
            long l = lengthCountingOutputStream.getLength();
            return l;
        }
        finally {
            lengthCountingOutputStream.close();
        }
    }

    private <T> ProtobufDataEncoderContext doEncode(ObjectEncoder<T> objectEncoder, FieldDescriptor fieldDescriptor, T t, boolean bl) throws IOException {
        long l = this.determineSize(objectEncoder, t);
        if (bl && l == 0L) {
            return this;
        }
        this.writeVarInt32(ProtobufDataEncoderContext.getTag(fieldDescriptor) << 3 | 2);
        this.writeVarInt64(l);
        objectEncoder.encode(t, this);
        return this;
    }

    private <T> ProtobufDataEncoderContext doEncode(ValueEncoder<T> valueEncoder, FieldDescriptor fieldDescriptor, T t, boolean bl) throws IOException {
        this.valueEncoderContext.resetContext(fieldDescriptor, bl);
        valueEncoder.encode(t, this.valueEncoderContext);
        return this;
    }

    private static Protobuf getProtobuf(FieldDescriptor object) {
        if ((object = ((FieldDescriptor)object).getProperty(Protobuf.class)) != null) {
            return object;
        }
        throw new EncodingException("Field has no @Protobuf config");
    }

    private static int getTag(FieldDescriptor object) {
        if ((object = ((FieldDescriptor)object).getProperty(Protobuf.class)) != null) {
            return object.tag();
        }
        throw new EncodingException("Field has no @Protobuf config");
    }

    static /* synthetic */ void lambda$static$0(Map.Entry entry, ObjectEncoderContext objectEncoderContext) throws IOException {
        objectEncoderContext.add(MAP_KEY_DESC, entry.getKey());
        objectEncoderContext.add(MAP_VALUE_DESC, entry.getValue());
    }

    private void writeVarInt32(int n) throws IOException {
        while ((long)(n & 0xFFFFFF80) != 0L) {
            this.output.write(n & 0x7F | 0x80);
            n >>>= 7;
        }
        this.output.write(n & 0x7F);
    }

    private void writeVarInt64(long l) throws IOException {
        while ((0xFFFFFFFFFFFFFF80L & l) != 0L) {
            this.output.write((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
        this.output.write((int)l & 0x7F);
    }

    @Override
    public ObjectEncoderContext add(FieldDescriptor fieldDescriptor, double d) throws IOException {
        return this.add(fieldDescriptor, d, true);
    }

    ObjectEncoderContext add(FieldDescriptor fieldDescriptor, double d, boolean bl) throws IOException {
        if (bl && d == 0.0) {
            return this;
        }
        this.writeVarInt32(ProtobufDataEncoderContext.getTag(fieldDescriptor) << 3 | 1);
        this.output.write(ProtobufDataEncoderContext.allocateBuffer(8).putDouble(d).array());
        return this;
    }

    @Override
    public ObjectEncoderContext add(FieldDescriptor fieldDescriptor, float f) throws IOException {
        return this.add(fieldDescriptor, f, true);
    }

    ObjectEncoderContext add(FieldDescriptor fieldDescriptor, float f, boolean bl) throws IOException {
        if (bl && f == 0.0f) {
            return this;
        }
        this.writeVarInt32(ProtobufDataEncoderContext.getTag(fieldDescriptor) << 3 | 5);
        this.output.write(ProtobufDataEncoderContext.allocateBuffer(4).putFloat(f).array());
        return this;
    }

    @Override
    public ObjectEncoderContext add(FieldDescriptor fieldDescriptor, Object object) throws IOException {
        return this.add(fieldDescriptor, object, true);
    }

    ObjectEncoderContext add(FieldDescriptor object, Object object2, boolean bl) throws IOException {
        if (object2 == null) {
            return this;
        }
        if (object2 instanceof CharSequence) {
            object2 = (CharSequence)object2;
            if (bl && object2.length() == 0) {
                return this;
            }
            this.writeVarInt32(ProtobufDataEncoderContext.getTag((FieldDescriptor)object) << 3 | 2);
            object = object2.toString().getBytes(UTF_8);
            this.writeVarInt32(((Object)object).length);
            this.output.write((byte[])object);
            return this;
        }
        if (object2 instanceof Collection) {
            object2 = ((Collection)object2).iterator();
            while (object2.hasNext()) {
                this.add((FieldDescriptor)object, object2.next(), false);
            }
            return this;
        }
        if (object2 instanceof Map) {
            for (Map.Entry entry : ((Map)object2).entrySet()) {
                this.doEncode(DEFAULT_MAP_ENCODER, (FieldDescriptor)object, entry, false);
            }
            return this;
        }
        if (object2 instanceof Double) {
            return this.add((FieldDescriptor)object, (Double)object2, bl);
        }
        if (object2 instanceof Float) {
            return this.add((FieldDescriptor)object, ((Float)object2).floatValue(), bl);
        }
        if (object2 instanceof Number) {
            return this.add((FieldDescriptor)object, ((Number)object2).longValue(), bl);
        }
        if (object2 instanceof Boolean) {
            return this.add((FieldDescriptor)object, (Boolean)object2, bl);
        }
        if (object2 instanceof byte[]) {
            object2 = (byte[])object2;
            if (bl && ((Object)object2).length == 0) {
                return this;
            }
            this.writeVarInt32(ProtobufDataEncoderContext.getTag((FieldDescriptor)object) << 3 | 2);
            this.writeVarInt32(((Object)object2).length);
            this.output.write((byte[])object2);
            return this;
        }
        ObjectEncoder<?> encoder = this.objectEncoders.get(object2.getClass());
        if (encoder != null) {
            return this.doEncode(encoder, (FieldDescriptor)object, object2, bl);
        }
        ValueEncoder<?> valueEncoder = this.valueEncoders.get(object2.getClass());
        if (valueEncoder != null) {
            return this.doEncode(valueEncoder, (FieldDescriptor)object, object2, bl);
        }
        if (object2 instanceof ProtoEnum) {
            return this.add((FieldDescriptor)object, ((ProtoEnum)object2).getNumber());
        }
        if (object2 instanceof Enum) {
            return this.add((FieldDescriptor)object, ((Enum)object2).ordinal());
        }
        return this.doEncode(this.fallbackEncoder, (FieldDescriptor)object, object2, bl);
    }

    @Override
    public ObjectEncoderContext add(String string2, double d) throws IOException {
        return this.add(FieldDescriptor.of(string2), d);
    }

    @Override
    public ObjectEncoderContext add(String string2, int n) throws IOException {
        return this.add(FieldDescriptor.of(string2), n);
    }

    @Override
    public ObjectEncoderContext add(String string2, long l) throws IOException {
        return this.add(FieldDescriptor.of(string2), l);
    }

    @Override
    public ObjectEncoderContext add(String string2, Object object) throws IOException {
        return this.add(FieldDescriptor.of(string2), object);
    }

    @Override
    public ObjectEncoderContext add(String string2, boolean bl) throws IOException {
        return this.add(FieldDescriptor.of(string2), bl);
    }

    @Override
    public ProtobufDataEncoderContext add(FieldDescriptor fieldDescriptor, int n) throws IOException {
        return this.add(fieldDescriptor, n, true);
    }

    ProtobufDataEncoderContext add(FieldDescriptor object, int n, boolean bl) throws IOException {
        if (bl && n == 0) {
            return this;
        }
        int n2 = 1.$SwitchMap$com$google$firebase$encoders$proto$Protobuf$IntEncoding[(object = ProtobufDataEncoderContext.getProtobuf((FieldDescriptor)object)).intEncoding().ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 == 3) {
                    this.writeVarInt32(object.tag() << 3 | 5);
                    this.output.write(ProtobufDataEncoderContext.allocateBuffer(4).putInt(n).array());
                }
            } else {
                this.writeVarInt32(object.tag() << 3);
                this.writeVarInt32(n << 1 ^ n >> 31);
            }
        } else {
            this.writeVarInt32(object.tag() << 3);
            this.writeVarInt32(n);
        }
        return this;
    }

    @Override
    public ProtobufDataEncoderContext add(FieldDescriptor fieldDescriptor, long l) throws IOException {
        return this.add(fieldDescriptor, l, true);
    }

    ProtobufDataEncoderContext add(FieldDescriptor object, long l, boolean bl) throws IOException {
        if (bl && l == 0L) {
            return this;
        }
        int n = 1.$SwitchMap$com$google$firebase$encoders$proto$Protobuf$IntEncoding[(object = ProtobufDataEncoderContext.getProtobuf((FieldDescriptor)object)).intEncoding().ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    this.writeVarInt32(object.tag() << 3 | 1);
                    this.output.write(ProtobufDataEncoderContext.allocateBuffer(8).putLong(l).array());
                }
            } else {
                this.writeVarInt32(object.tag() << 3);
                this.writeVarInt64(l >> 63 ^ l << 1);
            }
        } else {
            this.writeVarInt32(object.tag() << 3);
            this.writeVarInt64(l);
        }
        return this;
    }

    @Override
    public ProtobufDataEncoderContext add(FieldDescriptor fieldDescriptor, boolean bl) throws IOException {
        return this.add(fieldDescriptor, bl, true);
    }

    ProtobufDataEncoderContext add(FieldDescriptor fieldDescriptor, boolean bl, boolean bl2) throws IOException {
        return this.add(fieldDescriptor, bl ? 1 : 0, bl2);
    }

    ProtobufDataEncoderContext encode(Object object) throws IOException {
        if (object == null) {
            return this;
        }
        ObjectEncoder<?> objectEncoder = this.objectEncoders.get(object.getClass());
        if (objectEncoder != null) {
            objectEncoder.encode(object, this);
            return this;
        }
        objectEncoder = new StringBuilder();
        ((StringBuilder)((Object)objectEncoder)).append("No encoder for ");
        ((StringBuilder)((Object)objectEncoder)).append(object.getClass());
        throw new EncodingException(((StringBuilder)((Object)objectEncoder)).toString());
    }

    @Override
    public ObjectEncoderContext inline(Object object) throws IOException {
        return this.encode(object);
    }

    @Override
    public ObjectEncoderContext nested(FieldDescriptor fieldDescriptor) throws IOException {
        throw new EncodingException("nested() is not implemented for protobuf encoding.");
    }

    @Override
    public ObjectEncoderContext nested(String string2) throws IOException {
        return this.nested(FieldDescriptor.of(string2));
    }
}

