/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders.proto;

import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.FieldDescriptor;
import com.google.firebase.encoders.ValueEncoderContext;
import com.google.firebase.encoders.proto.ProtobufDataEncoderContext;
import java.io.IOException;

class ProtobufValueEncoderContext
implements ValueEncoderContext {
    private boolean encoded = false;
    private FieldDescriptor field;
    private final ProtobufDataEncoderContext objEncoderCtx;
    private boolean skipDefault = false;

    ProtobufValueEncoderContext(ProtobufDataEncoderContext protobufDataEncoderContext) {
        this.objEncoderCtx = protobufDataEncoderContext;
    }

    private void checkNotUsed() {
        if (!this.encoded) {
            this.encoded = true;
            return;
        }
        throw new EncodingException("Cannot encode a second value in the ValueEncoderContext");
    }

    @Override
    public ValueEncoderContext add(double d) throws IOException {
        this.checkNotUsed();
        this.objEncoderCtx.add(this.field, d, this.skipDefault);
        return this;
    }

    @Override
    public ValueEncoderContext add(float f) throws IOException {
        this.checkNotUsed();
        this.objEncoderCtx.add(this.field, f, this.skipDefault);
        return this;
    }

    @Override
    public ValueEncoderContext add(int n) throws IOException {
        this.checkNotUsed();
        this.objEncoderCtx.add(this.field, n, this.skipDefault);
        return this;
    }

    @Override
    public ValueEncoderContext add(long l) throws IOException {
        this.checkNotUsed();
        this.objEncoderCtx.add(this.field, l, this.skipDefault);
        return this;
    }

    @Override
    public ValueEncoderContext add(String string2) throws IOException {
        this.checkNotUsed();
        this.objEncoderCtx.add(this.field, string2, this.skipDefault);
        return this;
    }

    @Override
    public ValueEncoderContext add(boolean bl) throws IOException {
        this.checkNotUsed();
        this.objEncoderCtx.add(this.field, bl, this.skipDefault);
        return this;
    }

    @Override
    public ValueEncoderContext add(byte[] byArray) throws IOException {
        this.checkNotUsed();
        this.objEncoderCtx.add(this.field, byArray, this.skipDefault);
        return this;
    }

    void resetContext(FieldDescriptor fieldDescriptor, boolean bl) {
        this.encoded = false;
        this.field = fieldDescriptor;
        this.skipDefault = bl;
    }
}

