/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations.remote;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.TrafficStats;
import android.text.TextUtils;
import android.util.JsonReader;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.Hex;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.heartbeatinfo.HeartBeatController;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsException;
import com.google.firebase.installations.remote.InstallationResponse;
import com.google.firebase.installations.remote.RequestLimiter;
import com.google.firebase.installations.remote.TokenResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class FirebaseInstallationServiceClient {
    private static final String ACCEPT_HEADER_KEY = "Accept";
    private static final String API_KEY_HEADER = "x-goog-api-key";
    private static final String CACHE_CONTROL_DIRECTIVE = "no-cache";
    private static final String CACHE_CONTROL_HEADER_KEY = "Cache-Control";
    private static final String CONTENT_ENCODING_HEADER_KEY = "Content-Encoding";
    private static final String CONTENT_TYPE_HEADER_KEY = "Content-Type";
    private static final String CREATE_REQUEST_RESOURCE_NAME_FORMAT = "projects/%s/installations";
    private static final String DELETE_REQUEST_RESOURCE_NAME_FORMAT = "projects/%s/installations/%s";
    private static final Pattern EXPIRATION_TIMESTAMP_PATTERN = Pattern.compile("[0-9]+s");
    private static final String FIREBASE_INSTALLATIONS_API_DOMAIN = "firebaseinstallations.googleapis.com";
    private static final String FIREBASE_INSTALLATIONS_API_VERSION = "v1";
    private static final String FIREBASE_INSTALLATIONS_ID_HEARTBEAT_TAG = "fire-installations-id";
    private static final String FIREBASE_INSTALLATION_AUTH_VERSION = "FIS_v2";
    private static final String FIS_TAG = "Firebase-Installations";
    private static final String GENERATE_AUTH_TOKEN_REQUEST_RESOURCE_NAME_FORMAT = "projects/%s/installations/%s/authTokens:generate";
    private static final String GZIP_CONTENT_ENCODING = "gzip";
    private static final String HEART_BEAT_HEADER = "x-firebase-client";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final int MAX_RETRIES = 1;
    private static final int NETWORK_TIMEOUT_MILLIS = 10000;
    static final String PARSING_EXPIRATION_TIME_ERROR_MESSAGE = "Invalid Expiration Timestamp.";
    private static final String SDK_VERSION_PREFIX = "a:";
    private static final int TRAFFIC_STATS_CREATE_INSTALLATION_TAG = 32769;
    private static final int TRAFFIC_STATS_DELETE_INSTALLATION_TAG = 32770;
    private static final int TRAFFIC_STATS_FIREBASE_INSTALLATIONS_TAG = 32768;
    private static final int TRAFFIC_STATS_GENERATE_AUTH_TOKEN_TAG = 32771;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String X_ANDROID_CERT_HEADER_KEY = "X-Android-Cert";
    private static final String X_ANDROID_IID_MIGRATION_KEY = "x-goog-fis-android-iid-migration-auth";
    private static final String X_ANDROID_PACKAGE_HEADER_KEY = "X-Android-Package";
    private final Context context;
    private final Provider<HeartBeatController> heartBeatProvider;
    private final RequestLimiter requestLimiter;
    private boolean shouldServerErrorRetry;

    public FirebaseInstallationServiceClient(Context context, Provider<HeartBeatController> provider) {
        this.context = context;
        this.heartBeatProvider = provider;
        this.requestLimiter = new RequestLimiter();
    }

    private static String availableFirebaseOptions(String string2, String string3, String string4) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(", ");
            stringBuilder.append(string2);
            string2 = stringBuilder.toString();
        }
        return String.format("Firebase options used while communicating with Firebase server APIs: %s, %s%s", string3, string4, string2);
    }

    private static JSONObject buildCreateFirebaseInstallationRequestBody(String string2, String string3) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("fid", (Object)string2);
            jSONObject.put("appId", (Object)string3);
            jSONObject.put("authVersion", (Object)FIREBASE_INSTALLATION_AUTH_VERSION);
            jSONObject.put("sdkVersion", (Object)"a:17.0.1");
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new IllegalStateException(jSONException);
        }
    }

    private static JSONObject buildGenerateAuthTokenRequestBody() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("sdkVersion", (Object)"a:17.0.1");
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("installation", (Object)jSONObject);
            return jSONObject2;
        }
        catch (JSONException jSONException) {
            throw new IllegalStateException(jSONException);
        }
    }

    private String getFingerprintHashForPackage() {
        Object object;
        block4: {
            try {
                object = this.context;
                object = AndroidUtilsLight.getPackageCertificateHashBytes((Context)object, object.getPackageName());
                if (object != null) break block4;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("No such package: ");
                stringBuilder.append(this.context.getPackageName());
                Log.e((String)"ContentValues", (String)stringBuilder.toString(), (Throwable)nameNotFoundException);
                return null;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Could not get fingerprint hash for package: ");
            ((StringBuilder)object).append(this.context.getPackageName());
            Log.e((String)"ContentValues", (String)((StringBuilder)object).toString());
            return null;
        }
        object = Hex.bytesToStringUppercase((byte[])object, false);
        return object;
    }

    private URL getFullyQualifiedRequestUri(String object) throws FirebaseInstallationsException {
        try {
            object = new URL(String.format("https://%s/%s/%s", FIREBASE_INSTALLATIONS_API_DOMAIN, FIREBASE_INSTALLATIONS_API_VERSION, object));
            return object;
        }
        catch (MalformedURLException malformedURLException) {
            throw new FirebaseInstallationsException(malformedURLException.getMessage(), FirebaseInstallationsException.Status.UNAVAILABLE);
        }
    }

    private static byte[] getJsonBytes(JSONObject jSONObject) throws IOException {
        return jSONObject.toString().getBytes("UTF-8");
    }

    private static boolean isSuccessfulResponseCode(int n) {
        boolean bl = n >= 200 && n < 300;
        return bl;
    }

    private static void logBadConfigError() {
        Log.e((String)FIS_TAG, (String)"Firebase Installations can not communicate with Firebase server APIs due to invalid configuration. Please update your Firebase initialization process and set valid Firebase options (API key, Project ID, Application ID) when initializing Firebase.");
    }

    private static void logFisCommunicationError(HttpURLConnection object, String string2, String string3, String string4) {
        if (!TextUtils.isEmpty((CharSequence)(object = FirebaseInstallationServiceClient.readErrorResponse((HttpURLConnection)object)))) {
            Log.w((String)FIS_TAG, (String)object);
            Log.w((String)FIS_TAG, (String)FirebaseInstallationServiceClient.availableFirebaseOptions(string2, string3, string4));
        }
    }

    private HttpURLConnection openHttpURLConnection(URL object, String string2) throws FirebaseInstallationsException {
        try {
            object = (HttpURLConnection)((URL)object).openConnection();
        }
        catch (IOException iOException) {
            throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
        }
        ((URLConnection)object).setConnectTimeout(10000);
        ((URLConnection)object).setUseCaches(false);
        ((URLConnection)object).setReadTimeout(10000);
        ((URLConnection)object).addRequestProperty(CONTENT_TYPE_HEADER_KEY, JSON_CONTENT_TYPE);
        ((URLConnection)object).addRequestProperty(ACCEPT_HEADER_KEY, JSON_CONTENT_TYPE);
        ((URLConnection)object).addRequestProperty(CONTENT_ENCODING_HEADER_KEY, GZIP_CONTENT_ENCODING);
        ((URLConnection)object).addRequestProperty(CACHE_CONTROL_HEADER_KEY, CACHE_CONTROL_DIRECTIVE);
        ((URLConnection)object).addRequestProperty(X_ANDROID_PACKAGE_HEADER_KEY, this.context.getPackageName());
        HeartBeatController heartBeatController = this.heartBeatProvider.get();
        if (heartBeatController != null) {
            try {
                ((URLConnection)object).addRequestProperty(HEART_BEAT_HEADER, Tasks.await(heartBeatController.getHeartBeatsHeader()));
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                Log.w((String)"ContentValues", (String)"Failed to get heartbeats header", (Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                Log.w((String)"ContentValues", (String)"Failed to get heartbeats header", (Throwable)executionException);
            }
        }
        ((URLConnection)object).addRequestProperty(X_ANDROID_CERT_HEADER_KEY, this.getFingerprintHashForPackage());
        ((URLConnection)object).addRequestProperty(API_KEY_HEADER, string2);
        return object;
    }

    static long parseTokenExpirationTimestamp(String string2) {
        Preconditions.checkArgument(EXPIRATION_TIMESTAMP_PATTERN.matcher(string2).matches(), PARSING_EXPIRATION_TIME_ERROR_MESSAGE);
        long l = string2 != null && string2.length() != 0 ? Long.parseLong(string2.substring(0, string2.length() - 1)) : 0L;
        return l;
    }

    private InstallationResponse readCreateResponse(HttpURLConnection object) throws AssertionError, IOException {
        InputStream inputStream = ((URLConnection)object).getInputStream();
        JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(inputStream, UTF_8));
        object = TokenResult.builder();
        InstallationResponse.Builder builder = InstallationResponse.builder();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            if (string2.equals("name")) {
                builder.setUri(jsonReader.nextString());
                continue;
            }
            if (string2.equals("fid")) {
                builder.setFid(jsonReader.nextString());
                continue;
            }
            if (string2.equals("refreshToken")) {
                builder.setRefreshToken(jsonReader.nextString());
                continue;
            }
            if (string2.equals("authToken")) {
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    string2 = jsonReader.nextName();
                    if (string2.equals("token")) {
                        ((TokenResult.Builder)object).setToken(jsonReader.nextString());
                        continue;
                    }
                    if (string2.equals("expiresIn")) {
                        ((TokenResult.Builder)object).setTokenExpirationTimestamp(FirebaseInstallationServiceClient.parseTokenExpirationTimestamp(jsonReader.nextString()));
                        continue;
                    }
                    jsonReader.skipValue();
                }
                builder.setAuthToken(((TokenResult.Builder)object).build());
                jsonReader.endObject();
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        jsonReader.close();
        inputStream.close();
        return builder.setResponseCode(InstallationResponse.ResponseCode.OK).build();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    private static String readErrorResponse(HttpURLConnection var0) {
        var1_4 = var0.getErrorStream();
        if (var1_4 == null) {
            return null;
        }
        var1_4 = new BufferedReader(new InputStreamReader((InputStream)var1_4, FirebaseInstallationServiceClient.UTF_8));
        var2_7 = new StringBuilder();
        while ((var3_8 = var1_4.readLine()) != null) {
            var2_7.append(var3_8);
            var2_7.append('\n');
        }
        var0 = String.format("Error when communicating with the Firebase Installations server API. HTTP response: [%d %s: %s]", new Object[]{var0.getResponseCode(), var0.getResponseMessage(), var2_7});
        var1_4.close();
lbl16:
        // 2 sources

        return var0;
        catch (Throwable var0_1) {
            var1_4.close();
lbl21:
            // 2 sources

            throw var0_1;
        }
        catch (IOException var0_2) {
            var1_4.close();
lbl26:
            // 2 sources

            return null;
        }
        catch (IOException var1_5) {
            ** continue;
        }
        {
            catch (IOException var1_6) {
                ** continue;
            }
        }
        {
            catch (IOException var0_3) {
                ** continue;
            }
        }
    }

    private TokenResult readGenerateAuthTokenResponse(HttpURLConnection object) throws AssertionError, IOException {
        InputStream inputStream = ((URLConnection)object).getInputStream();
        JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(inputStream, UTF_8));
        TokenResult.Builder builder = TokenResult.builder();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            object = jsonReader.nextName();
            if (((String)object).equals("token")) {
                builder.setToken(jsonReader.nextString());
                continue;
            }
            if (((String)object).equals("expiresIn")) {
                builder.setTokenExpirationTimestamp(FirebaseInstallationServiceClient.parseTokenExpirationTimestamp(jsonReader.nextString()));
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        jsonReader.close();
        inputStream.close();
        return builder.setResponseCode(TokenResult.ResponseCode.OK).build();
    }

    private void writeFIDCreateRequestBodyToOutputStream(HttpURLConnection httpURLConnection, String string2, String string3) throws IOException {
        FirebaseInstallationServiceClient.writeRequestBodyToOutputStream(httpURLConnection, FirebaseInstallationServiceClient.getJsonBytes(FirebaseInstallationServiceClient.buildCreateFirebaseInstallationRequestBody(string2, string3)));
    }

    private void writeGenerateAuthTokenRequestBodyToOutputStream(HttpURLConnection httpURLConnection) throws IOException {
        FirebaseInstallationServiceClient.writeRequestBodyToOutputStream(httpURLConnection, FirebaseInstallationServiceClient.getJsonBytes(FirebaseInstallationServiceClient.buildGenerateAuthTokenRequestBody()));
    }

    private static void writeRequestBodyToOutputStream(URLConnection object, byte[] byArray) throws IOException {
        GZIPOutputStream gZIPOutputStream;
        if ((object = ((URLConnection)object).getOutputStream()) != null) {
            gZIPOutputStream = new GZIPOutputStream((OutputStream)object);
            gZIPOutputStream.write(byArray);
            return;
        }
        throw new IOException("Cannot send request to FIS servers. No OutputStream available.");
        finally {
            gZIPOutputStream.close();
            ((OutputStream)object).close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InstallationResponse createFirebaseInstallation(String object, String string2, String string3, String string4, String string5) throws FirebaseInstallationsException {
        if (!this.requestLimiter.isRequestAllowed()) {
            throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
        }
        int n = 0;
        URL uRL = this.getFullyQualifiedRequestUri(String.format(CREATE_REQUEST_RESOURCE_NAME_FORMAT, string3));
        while (true) {
            HttpURLConnection httpURLConnection;
            block11: {
                if (n > 1) {
                    throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
                }
                TrafficStats.setThreadStatsTag((int)32769);
                httpURLConnection = this.openHttpURLConnection(uRL, (String)object);
                try {
                    httpURLConnection.setRequestMethod("POST");
                    httpURLConnection.setDoOutput(true);
                    if (string5 != null) {
                        httpURLConnection.addRequestProperty(X_ANDROID_IID_MIGRATION_KEY, string5);
                    }
                    this.writeFIDCreateRequestBodyToOutputStream(httpURLConnection, string2, string4);
                    int n2 = httpURLConnection.getResponseCode();
                    this.requestLimiter.setNextRequestTime(n2);
                    if (FirebaseInstallationServiceClient.isSuccessfulResponseCode(n2)) {
                        InstallationResponse installationResponse = this.readCreateResponse(httpURLConnection);
                        object = installationResponse;
                    } else {
                        FirebaseInstallationServiceClient.logFisCommunicationError(httpURLConnection, string4, (String)object, string3);
                        if (n2 == 429) {
                            FirebaseInstallationsException firebaseInstallationsException = new FirebaseInstallationsException("Firebase servers have received too many requests from this client in a short period of time. Please try again later.", FirebaseInstallationsException.Status.TOO_MANY_REQUESTS);
                            throw firebaseInstallationsException;
                        }
                        if (n2 >= 500 && n2 < 600) break block11;
                        FirebaseInstallationServiceClient.logBadConfigError();
                        InstallationResponse installationResponse = InstallationResponse.builder().setResponseCode(InstallationResponse.ResponseCode.BAD_CONFIG).build();
                        object = installationResponse;
                    }
                    httpURLConnection.disconnect();
                }
                catch (Throwable throwable) {
                    httpURLConnection.disconnect();
                    TrafficStats.clearThreadStatsTag();
                    throw throwable;
                }
                catch (IOException | AssertionError object2) {}
                TrafficStats.clearThreadStatsTag();
                return object;
            }
            httpURLConnection.disconnect();
            TrafficStats.clearThreadStatsTag();
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteFirebaseInstallation(String string2, String object, String string3, String string4) throws FirebaseInstallationsException {
        int n = 0;
        URL uRL = this.getFullyQualifiedRequestUri(String.format(DELETE_REQUEST_RESOURCE_NAME_FORMAT, string3, object));
        while (true) {
            block7: {
                if (n > 1) {
                    throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
                }
                TrafficStats.setThreadStatsTag((int)32770);
                object = this.openHttpURLConnection(uRL, string2);
                try {
                    ((HttpURLConnection)object).setRequestMethod("DELETE");
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("FIS_v2 ");
                    stringBuilder.append(string4);
                    ((URLConnection)object).addRequestProperty("Authorization", stringBuilder.toString());
                    int n2 = ((HttpURLConnection)object).getResponseCode();
                    if (n2 != 200 && n2 != 401 && n2 != 404) {
                        FirebaseInstallationServiceClient.logFisCommunicationError((HttpURLConnection)object, null, string2, string3);
                        if (n2 != 429 && (n2 < 500 || n2 >= 600)) {
                            FirebaseInstallationServiceClient.logBadConfigError();
                            FirebaseInstallationsException firebaseInstallationsException = new FirebaseInstallationsException("Bad config while trying to delete FID", FirebaseInstallationsException.Status.BAD_CONFIG);
                            throw firebaseInstallationsException;
                        }
                        break block7;
                    }
                    ((HttpURLConnection)object).disconnect();
                }
                catch (Throwable throwable) {
                    ((HttpURLConnection)object).disconnect();
                    TrafficStats.clearThreadStatsTag();
                    throw throwable;
                }
                catch (IOException iOException) {}
                TrafficStats.clearThreadStatsTag();
                return;
            }
            ++n;
            ((HttpURLConnection)object).disconnect();
            TrafficStats.clearThreadStatsTag();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TokenResult generateAuthToken(String object, String object2, String string2, String string3) throws FirebaseInstallationsException {
        if (!this.requestLimiter.isRequestAllowed()) {
            throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
        }
        int n = 0;
        URL uRL = this.getFullyQualifiedRequestUri(String.format(GENERATE_AUTH_TOKEN_REQUEST_RESOURCE_NAME_FORMAT, string2, object2));
        while (true) {
            HttpURLConnection httpURLConnection;
            block12: {
                if (n > 1) {
                    throw new FirebaseInstallationsException("Firebase Installations Service is unavailable. Please try again later.", FirebaseInstallationsException.Status.UNAVAILABLE);
                }
                TrafficStats.setThreadStatsTag((int)32771);
                httpURLConnection = this.openHttpURLConnection(uRL, (String)object);
                try {
                    httpURLConnection.setRequestMethod("POST");
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("FIS_v2 ");
                    ((StringBuilder)object2).append(string3);
                    httpURLConnection.addRequestProperty("Authorization", ((StringBuilder)object2).toString());
                    httpURLConnection.setDoOutput(true);
                    this.writeGenerateAuthTokenRequestBodyToOutputStream(httpURLConnection);
                    int n2 = httpURLConnection.getResponseCode();
                    this.requestLimiter.setNextRequestTime(n2);
                    if (FirebaseInstallationServiceClient.isSuccessfulResponseCode(n2)) {
                        object = object2 = this.readGenerateAuthTokenResponse(httpURLConnection);
                    } else {
                        FirebaseInstallationServiceClient.logFisCommunicationError(httpURLConnection, null, (String)object, string2);
                        if (n2 != 401 && n2 != 404) {
                            if (n2 == 429) {
                                object2 = new FirebaseInstallationsException("Firebase servers have received too many requests from this client in a short period of time. Please try again later.", FirebaseInstallationsException.Status.TOO_MANY_REQUESTS);
                                throw object2;
                            }
                            if (n2 >= 500 && n2 < 600) break block12;
                            FirebaseInstallationServiceClient.logBadConfigError();
                            object = object2 = TokenResult.builder().setResponseCode(TokenResult.ResponseCode.BAD_CONFIG).build();
                        } else {
                            object = object2 = TokenResult.builder().setResponseCode(TokenResult.ResponseCode.AUTH_ERROR).build();
                        }
                    }
                    httpURLConnection.disconnect();
                }
                catch (Throwable throwable) {
                    httpURLConnection.disconnect();
                    TrafficStats.clearThreadStatsTag();
                    throw throwable;
                }
                catch (IOException | AssertionError object3) {}
                TrafficStats.clearThreadStatsTag();
                return object;
            }
            httpURLConnection.disconnect();
            TrafficStats.clearThreadStatsTag();
            ++n;
        }
    }
}

