/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations.remote;

import com.google.firebase.installations.Utils;
import java.util.concurrent.TimeUnit;

class RequestLimiter {
    private static final long MAXIMUM_BACKOFF_DURATION_FOR_CONFIGURATION_ERRORS = TimeUnit.HOURS.toMillis(24L);
    private static final long MAXIMUM_BACKOFF_DURATION_FOR_SERVER_ERRORS = TimeUnit.MINUTES.toMillis(30L);
    private int attemptCount;
    private long nextRequestTime;
    private final Utils utils;

    RequestLimiter() {
        this.utils = Utils.getInstance();
    }

    RequestLimiter(Utils utils) {
        this.utils = utils;
    }

    private long getBackoffDuration(int n) {
        synchronized (this) {
            block4: {
                if (RequestLimiter.isRetryableError(n)) break block4;
                long l = MAXIMUM_BACKOFF_DURATION_FOR_CONFIGURATION_ERRORS;
                return l;
            }
            double d = Math.min(Math.pow(2.0, this.attemptCount) + (double)this.utils.getRandomDelayForSyncPrevention(), (double)MAXIMUM_BACKOFF_DURATION_FOR_SERVER_ERRORS);
            long l = (long)d;
            return l;
        }
    }

    private static boolean isRetryableError(int n) {
        boolean bl = n == 429 || n >= 500 && n < 600;
        return bl;
    }

    private static boolean isSuccessfulOrRequiresNewFidCreation(int n) {
        boolean bl = n >= 200 && n < 300 || n == 401 || n == 404;
        return bl;
    }

    private void resetBackoffStrategy() {
        synchronized (this) {
            this.attemptCount = 0;
            return;
        }
    }

    public boolean isRequestAllowed() {
        synchronized (this) {
            boolean bl;
            block4: {
                long l;
                long l2;
                if (this.attemptCount != 0 && (l2 = this.utils.currentTimeInMillis()) <= (l = this.nextRequestTime)) {
                    bl = false;
                    break block4;
                }
                bl = true;
            }
            return bl;
        }
    }

    public void setNextRequestTime(int n) {
        synchronized (this) {
            if (RequestLimiter.isSuccessfulOrRequiresNewFidCreation(n)) {
                this.resetBackoffStrategy();
                return;
            }
            ++this.attemptCount;
            long l = this.getBackoffDuration(n);
            this.nextRequestTime = this.utils.currentTimeInMillis() + l;
            return;
        }
    }
}

