/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.core.content.ContextCompat;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.events.Event;
import com.google.firebase.events.Publisher;

public class DataCollectionConfigStorage {
    public static final String DATA_COLLECTION_DEFAULT_ENABLED = "firebase_data_collection_default_enabled";
    private static final String FIREBASE_APP_PREFS = "com.google.firebase.common.prefs:";
    private boolean dataCollectionDefaultEnabled;
    private final Context deviceProtectedContext;
    private final Publisher publisher;
    private final SharedPreferences sharedPreferences;

    public DataCollectionConfigStorage(Context object, String string2, Publisher publisher) {
        Context context;
        this.deviceProtectedContext = context = DataCollectionConfigStorage.directBootSafe((Context)object);
        object = new StringBuilder();
        ((StringBuilder)object).append(FIREBASE_APP_PREFS);
        ((StringBuilder)object).append(string2);
        this.sharedPreferences = context.getSharedPreferences(((StringBuilder)object).toString(), 0);
        this.publisher = publisher;
        this.dataCollectionDefaultEnabled = this.readAutoDataCollectionEnabled();
    }

    private static Context directBootSafe(Context context) {
        if (Build.VERSION.SDK_INT < 24) {
            return context;
        }
        return ContextCompat.createDeviceProtectedStorageContext((Context)context);
    }

    private boolean readAutoDataCollectionEnabled() {
        if (this.sharedPreferences.contains(DATA_COLLECTION_DEFAULT_ENABLED)) {
            return this.sharedPreferences.getBoolean(DATA_COLLECTION_DEFAULT_ENABLED, true);
        }
        return this.readManifestDataCollectionEnabled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readManifestDataCollectionEnabled() {
        PackageManager packageManager;
        try {
            packageManager = this.deviceProtectedContext.getPackageManager();
            if (packageManager == null) return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return true;
        }
        packageManager = packageManager.getApplicationInfo(this.deviceProtectedContext.getPackageName(), 128);
        if (packageManager == null) return true;
        if (packageManager.metaData == null) return true;
        if (!packageManager.metaData.containsKey(DATA_COLLECTION_DEFAULT_ENABLED)) return true;
        return packageManager.metaData.getBoolean(DATA_COLLECTION_DEFAULT_ENABLED);
    }

    private void updateDataCollectionDefaultEnabled(boolean bl) {
        synchronized (this) {
            if (this.dataCollectionDefaultEnabled != bl) {
                this.dataCollectionDefaultEnabled = bl;
                Publisher publisher = this.publisher;
                DataCollectionDefaultChange dataCollectionDefaultChange = new DataCollectionDefaultChange(bl);
                Event<DataCollectionDefaultChange> event = new Event<DataCollectionDefaultChange>(DataCollectionDefaultChange.class, dataCollectionDefaultChange);
                publisher.publish(event);
            }
            return;
        }
    }

    public boolean isEnabled() {
        synchronized (this) {
            boolean bl = this.dataCollectionDefaultEnabled;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setEnabled(Boolean bl) {
        synchronized (this) {
            if (bl == null) {
                this.sharedPreferences.edit().remove(DATA_COLLECTION_DEFAULT_ENABLED).apply();
                this.updateDataCollectionDefaultEnabled(this.readManifestDataCollectionEnabled());
            } else {
                boolean bl2 = Boolean.TRUE.equals(bl);
                this.sharedPreferences.edit().putBoolean(DATA_COLLECTION_DEFAULT_ENABLED, bl2).apply();
                this.updateDataCollectionDefaultEnabled(bl2);
            }
            return;
        }
    }
}

