/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.internal.$Gson$Preconditions;
import com.google.gson.internal.LazilyParsedNumber;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class JsonPrimitive
extends JsonElement {
    private final Object value;

    public JsonPrimitive(Boolean bl) {
        this.value = $Gson$Preconditions.checkNotNull(bl);
    }

    public JsonPrimitive(Character c) {
        this.value = $Gson$Preconditions.checkNotNull(c).toString();
    }

    public JsonPrimitive(Number number) {
        this.value = $Gson$Preconditions.checkNotNull(number);
    }

    public JsonPrimitive(String string2) {
        this.value = $Gson$Preconditions.checkNotNull(string2);
    }

    private static boolean isIntegral(JsonPrimitive object) {
        boolean bl;
        block2: {
            block3: {
                boolean bl2;
                object = ((JsonPrimitive)object).value;
                boolean bl3 = object instanceof Number;
                bl = bl2 = false;
                if (!bl3) break block2;
                if ((object = (Number)object) instanceof BigInteger || object instanceof Long || object instanceof Integer || object instanceof Short) break block3;
                bl = bl2;
                if (!(object instanceof Byte)) break block2;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public JsonPrimitive deepCopy() {
        return this;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (JsonPrimitive)object;
            if (this.value == null) {
                if (((JsonPrimitive)object).value != null) {
                    bl3 = false;
                }
                return bl3;
            }
            if (JsonPrimitive.isIntegral(this) && JsonPrimitive.isIntegral((JsonPrimitive)object)) {
                bl3 = this.getAsNumber().longValue() == ((JsonPrimitive)object).getAsNumber().longValue() ? bl : false;
                return bl3;
            }
            Object object2 = this.value;
            if (object2 instanceof Number && ((JsonPrimitive)object).value instanceof Number) {
                double d = this.getAsNumber().doubleValue();
                double d2 = ((JsonPrimitive)object).getAsNumber().doubleValue();
                bl3 = bl2;
                if (d != d2) {
                    bl3 = Double.isNaN(d) && Double.isNaN(d2) ? bl2 : false;
                }
                return bl3;
            }
            return object2.equals(((JsonPrimitive)object).value);
        }
        return false;
    }

    @Override
    public BigDecimal getAsBigDecimal() {
        Object object = this.value;
        object = object instanceof BigDecimal ? (BigDecimal)object : new BigDecimal(this.value.toString());
        return object;
    }

    @Override
    public BigInteger getAsBigInteger() {
        Object object = this.value;
        object = object instanceof BigInteger ? (BigInteger)object : new BigInteger(this.value.toString());
        return object;
    }

    @Override
    public boolean getAsBoolean() {
        if (this.isBoolean()) {
            return (Boolean)this.value;
        }
        return Boolean.parseBoolean(this.getAsString());
    }

    @Override
    public byte getAsByte() {
        byte by;
        byte by2;
        byte by3 = this.isNumber() ? (by2 = this.getAsNumber().byteValue()) : (by = Byte.parseByte(this.getAsString()));
        return by3;
    }

    @Override
    public char getAsCharacter() {
        return this.getAsString().charAt(0);
    }

    @Override
    public double getAsDouble() {
        double d = this.isNumber() ? this.getAsNumber().doubleValue() : Double.parseDouble(this.getAsString());
        return d;
    }

    @Override
    public float getAsFloat() {
        float f = this.isNumber() ? this.getAsNumber().floatValue() : Float.parseFloat(this.getAsString());
        return f;
    }

    @Override
    public int getAsInt() {
        int n = this.isNumber() ? this.getAsNumber().intValue() : Integer.parseInt(this.getAsString());
        return n;
    }

    @Override
    public long getAsLong() {
        long l = this.isNumber() ? this.getAsNumber().longValue() : Long.parseLong(this.getAsString());
        return l;
    }

    @Override
    public Number getAsNumber() {
        Object object = this.value;
        object = object instanceof String ? new LazilyParsedNumber((String)object) : (Number)object;
        return object;
    }

    @Override
    public short getAsShort() {
        short s;
        short s2;
        short s3 = this.isNumber() ? (s2 = this.getAsNumber().shortValue()) : (s = Short.parseShort(this.getAsString()));
        return s3;
    }

    @Override
    public String getAsString() {
        if (this.isNumber()) {
            return this.getAsNumber().toString();
        }
        if (this.isBoolean()) {
            return ((Boolean)this.value).toString();
        }
        return (String)this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        long l;
        if (this.value == null) {
            return 31;
        }
        if (JsonPrimitive.isIntegral(this)) {
            l = this.getAsNumber().longValue();
            return (int)(l >>> 32 ^ l);
        }
        Object object = this.value;
        if (!(object instanceof Number)) return object.hashCode();
        l = Double.doubleToLongBits(this.getAsNumber().doubleValue());
        return (int)(l >>> 32 ^ l);
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    public boolean isString() {
        return this.value instanceof String;
    }
}

