/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonParseException;
import com.google.gson.ToNumberStrategy;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.math.BigDecimal;

public abstract class ToNumberPolicy
extends Enum<ToNumberPolicy>
implements ToNumberStrategy {
    private static final /* synthetic */ ToNumberPolicy[] $VALUES;
    public static final /* enum */ ToNumberPolicy BIG_DECIMAL;
    public static final /* enum */ ToNumberPolicy DOUBLE;
    public static final /* enum */ ToNumberPolicy LAZILY_PARSED_NUMBER;
    public static final /* enum */ ToNumberPolicy LONG_OR_DOUBLE;

    static {
        ToNumberPolicy toNumberPolicy;
        ToNumberPolicy toNumberPolicy2;
        ToNumberPolicy toNumberPolicy3;
        ToNumberPolicy toNumberPolicy4;
        DOUBLE = toNumberPolicy4 = new ToNumberPolicy(){

            @Override
            public Double readNumber(JsonReader jsonReader) throws IOException {
                return jsonReader.nextDouble();
            }
        };
        LAZILY_PARSED_NUMBER = toNumberPolicy3 = new ToNumberPolicy(){

            @Override
            public Number readNumber(JsonReader jsonReader) throws IOException {
                return new LazilyParsedNumber(jsonReader.nextString());
            }
        };
        LONG_OR_DOUBLE = toNumberPolicy2 = new ToNumberPolicy(){

            @Override
            public Number readNumber(JsonReader jsonReader) throws IOException, JsonParseException {
                long l;
                String string2 = jsonReader.nextString();
                try {
                    l = Long.parseLong(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    Double d;
                    block5: {
                        try {
                            d = Double.valueOf(string2);
                            if ((d.isInfinite() || d.isNaN()) && !jsonReader.isLenient()) break block5;
                            return d;
                        }
                        catch (NumberFormatException numberFormatException2) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Cannot parse ");
                            stringBuilder.append(string2);
                            stringBuilder.append("; at path ");
                            stringBuilder.append(jsonReader.getPreviousPath());
                            throw new JsonParseException(stringBuilder.toString(), numberFormatException2);
                        }
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("JSON forbids NaN and infinities: ");
                    stringBuilder.append(d);
                    stringBuilder.append("; at path ");
                    stringBuilder.append(jsonReader.getPreviousPath());
                    MalformedJsonException malformedJsonException = new MalformedJsonException(stringBuilder.toString());
                    throw malformedJsonException;
                }
                return l;
            }
        };
        BIG_DECIMAL = toNumberPolicy = new ToNumberPolicy(){

            @Override
            public BigDecimal readNumber(JsonReader jsonReader) throws IOException {
                String string2 = jsonReader.nextString();
                try {
                    BigDecimal bigDecimal = new BigDecimal(string2);
                    return bigDecimal;
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Cannot parse ");
                    stringBuilder.append(string2);
                    stringBuilder.append("; at path ");
                    stringBuilder.append(jsonReader.getPreviousPath());
                    throw new JsonParseException(stringBuilder.toString(), numberFormatException);
                }
            }
        };
        $VALUES = new ToNumberPolicy[]{toNumberPolicy4, toNumberPolicy3, toNumberPolicy2, toNumberPolicy};
    }

    public static ToNumberPolicy valueOf(String string2) {
        return Enum.valueOf(ToNumberPolicy.class, string2);
    }

    public static ToNumberPolicy[] values() {
        return (ToNumberPolicy[])$VALUES.clone();
    }
}

