/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.$Gson$Preconditions;
import com.google.gson.internal.JavaVersion;
import com.google.gson.internal.PreJava9DateFormatProvider;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class DefaultDateTypeAdapter<T extends Date>
extends TypeAdapter<T> {
    private static final String SIMPLE_NAME = "DefaultDateTypeAdapter";
    private final List<DateFormat> dateFormats;
    private final DateType<T> dateType;

    private DefaultDateTypeAdapter(DateType<T> dateType, int n) {
        ArrayList<DateFormat> arrayList = new ArrayList<DateFormat>();
        this.dateFormats = arrayList;
        this.dateType = $Gson$Preconditions.checkNotNull(dateType);
        arrayList.add(DateFormat.getDateInstance(n, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            arrayList.add(DateFormat.getDateInstance(n));
        }
        if (JavaVersion.isJava9OrLater()) {
            arrayList.add(PreJava9DateFormatProvider.getUSDateFormat(n));
        }
    }

    private DefaultDateTypeAdapter(DateType<T> dateType, int n, int n2) {
        ArrayList<DateFormat> arrayList = new ArrayList<DateFormat>();
        this.dateFormats = arrayList;
        this.dateType = $Gson$Preconditions.checkNotNull(dateType);
        arrayList.add(DateFormat.getDateTimeInstance(n, n2, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            arrayList.add(DateFormat.getDateTimeInstance(n, n2));
        }
        if (JavaVersion.isJava9OrLater()) {
            arrayList.add(PreJava9DateFormatProvider.getUSDateTimeFormat(n, n2));
        }
    }

    private DefaultDateTypeAdapter(DateType<T> dateType, String string2) {
        ArrayList<DateFormat> arrayList = new ArrayList<DateFormat>();
        this.dateFormats = arrayList;
        this.dateType = $Gson$Preconditions.checkNotNull(dateType);
        arrayList.add(new SimpleDateFormat(string2, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            arrayList.add(new SimpleDateFormat(string2));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Date deserializeToDate(JsonReader jsonReader) throws IOException {
        String string2 = jsonReader.nextString();
        Object object = this.dateFormats;
        synchronized (object) {
            for (Cloneable cloneable : this.dateFormats) {
                try {
                    return cloneable.parse(string2);
                }
                catch (ParseException parseException) {
                }
            }
        }
        try {
            object = new ParsePosition(0);
            return ISO8601Utils.parse(string2, (ParsePosition)object);
        }
        catch (ParseException parseException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed parsing '");
            stringBuilder.append(string2);
            stringBuilder.append("' as Date; at path ");
            stringBuilder.append(jsonReader.getPreviousPath());
            throw new JsonSyntaxException(stringBuilder.toString(), parseException);
        }
    }

    @Override
    public T read(JsonReader object) throws IOException {
        if (((JsonReader)object).peek() == JsonToken.NULL) {
            ((JsonReader)object).nextNull();
            return null;
        }
        object = this.deserializeToDate((JsonReader)object);
        return this.dateType.deserialize((Date)object);
    }

    public String toString() {
        DateFormat dateFormat = this.dateFormats.get(0);
        if (dateFormat instanceof SimpleDateFormat) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DefaultDateTypeAdapter(");
            stringBuilder.append(((SimpleDateFormat)dateFormat).toPattern());
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DefaultDateTypeAdapter(");
        stringBuilder.append(dateFormat.getClass().getSimpleName());
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(JsonWriter jsonWriter, Date object) throws IOException {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        DateFormat dateFormat = this.dateFormats.get(0);
        List<DateFormat> list = this.dateFormats;
        synchronized (list) {
            object = dateFormat.format((Date)object);
        }
        jsonWriter.value((String)object);
    }

    public static abstract class DateType<T extends Date> {
        public static final DateType<Date> DATE = new DateType<Date>(Date.class){

            @Override
            protected Date deserialize(Date date) {
                return date;
            }
        };
        private final Class<T> dateClass;

        protected DateType(Class<T> clazz) {
            this.dateClass = clazz;
        }

        private final TypeAdapterFactory createFactory(DefaultDateTypeAdapter<T> defaultDateTypeAdapter) {
            return TypeAdapters.newFactory(this.dateClass, defaultDateTypeAdapter);
        }

        public final TypeAdapterFactory createAdapterFactory(int n) {
            return this.createFactory(new DefaultDateTypeAdapter(this, n));
        }

        public final TypeAdapterFactory createAdapterFactory(int n, int n2) {
            return this.createFactory(new DefaultDateTypeAdapter(this, n, n2));
        }

        public final TypeAdapterFactory createAdapterFactory(String string2) {
            return this.createFactory(new DefaultDateTypeAdapter(this, string2));
        }

        public final TypeAdapterFactory createDefaultsAdapterFactory() {
            return this.createFactory(new DefaultDateTypeAdapter(this, 2, 2));
        }

        protected abstract T deserialize(Date var1);
    }
}

